package consulting.pigott.wordpress.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import java.io.IOException;

public class CommentStatusDeserializer extends JsonDeserializer<CommentStatus> {

    @Override
    public CommentStatus deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        return CommentStatus.fromString(jsonParser.getValueAsString());
    }
}
