/*
 * Decompiled with CFR 0.152.
 */
package consulting.pigott.wordpress;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import consulting.pigott.wordpress.WordpressClient;
import consulting.pigott.wordpress.authentication.AuthenticationProvider;
import consulting.pigott.wordpress.config.Config;
import consulting.pigott.wordpress.model.JsonViews;
import consulting.pigott.wordpress.model.Media;
import consulting.pigott.wordpress.model.PagedResponse;
import consulting.pigott.wordpress.model.Post;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.net.URIBuilder;

public class WordpressClientImpl
implements WordpressClient {
    private Config config;
    private HttpClient httpClient;
    private AuthenticationProvider authenticationProvider;
    private ObjectMapper mapper;

    public WordpressClientImpl(Config config, AuthenticationProvider authenticationProvider) throws IOException {
        this.config = config;
        this.authenticationProvider = authenticationProvider;
        this.httpClient = HttpClientBuilder.create().build();
        this.mapper = new ObjectMapper();
        this.mapper.configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true);
        this.mapper.configure(JsonParser.Feature.IGNORE_UNDEFINED, true);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public List<Post> getAllPosts(Optional<Map<String, String>> queryParams) throws IOException, URISyntaxException {
        return this.getAll(this::getPosts, queryParams);
    }

    @Override
    public PagedResponse<Post> getPosts(Integer page, Integer perPage, Optional<Map<String, String>> queryParams) throws IOException, URISyntaxException {
        URIBuilder builder = this.makeBaseURIBuilder(page, perPage).setPathSegments(new String[]{"wp-json", "wp", "v2", "posts"});
        if (queryParams.isPresent()) {
            for (String key : queryParams.get().keySet()) {
                builder.addParameter(key, queryParams.get().get(key));
            }
        }
        return this.executeList(this.makeStandardRequest((HttpUriRequest)new HttpGet(builder.build().toURL().toString())), Post.class, JsonViews.Read.class);
    }

    @Override
    public Post getPost(String id) throws IOException, URISyntaxException {
        return this.executeSingle(this.makeStandardRequest((HttpUriRequest)new HttpGet(this.makeBaseURIBuilder().setPathSegments(new String[]{"wp-json", "wp", "v2", "posts", id}).build().toURL().toString())), Post.class, JsonViews.Read.class);
    }

    @Override
    public Post savePost(Post post) throws IOException, URISyntaxException {
        Boolean isExisting = null != post.getId();
        String url = isExisting != false ? this.makeBaseURIBuilder().setPathSegments(new String[]{"wp-json", "wp", "v2", "posts", post.getId().toString()}).build().toURL().toString() : this.makeBaseURIBuilder().setPathSegments(new String[]{"wp-json", "wp", "v2", "posts"}).build().toURL().toString();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(this.mapper.writerWithView(JsonViews.Edit.class).writeValueAsString((Object)post), ContentType.APPLICATION_JSON));
        return this.executeSingle(this.makeStandardRequest((HttpUriRequest)httpPost), Post.class, JsonViews.Edit.class);
    }

    @Override
    public void deletePost(String id) throws IOException, URISyntaxException {
        this.executeSingle(this.makeStandardRequest((HttpUriRequest)new HttpDelete(this.makeBaseURIBuilder().setPathSegments(new String[]{"wp-json", "wp", "v2", "posts", id}).build().toURL().toString())), Post.class, JsonViews.Read.class);
    }

    @Override
    public List<Media> getAllMedia(Optional<Map<String, String>> queryParams) throws IOException, URISyntaxException {
        return this.getAll(this::getMedias, queryParams);
    }

    @Override
    public PagedResponse<Media> getMedias(Integer page, Integer perPage, Optional<Map<String, String>> queryParams) throws IOException, URISyntaxException {
        URIBuilder builder = this.makeBaseURIBuilder(page, perPage).setPathSegments(new String[]{"wp-json", "wp", "v2", "media"});
        if (queryParams.isPresent()) {
            for (String key : queryParams.get().keySet()) {
                builder.addParameter(key, queryParams.get().get(key));
            }
        }
        return this.executeList(this.makeStandardRequest((HttpUriRequest)new HttpGet(builder.build().toURL().toString())), Media.class, JsonViews.Read.class);
    }

    @Override
    public Media getMedia(String id) throws IOException, URISyntaxException {
        return this.executeSingle(this.makeStandardRequest((HttpUriRequest)new HttpGet(this.makeBaseURIBuilder().setPathSegments(new String[]{"wp-json", "wp", "v2", "media", id}).build().toURL().toString())), Media.class, JsonViews.Read.class);
    }

    @Override
    public Media uploadMedia(File content, ContentType contentType, String filename) throws IOException, URISyntaxException {
        String url = this.makeBaseURIBuilder().setPathSegments(new String[]{"wp-json", "wp", "v2", "media"}).build().toURL().toString();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new FileEntity(content, contentType));
        httpPost.addHeader("Content-Disposition", (Object)("attachment; filename=" + filename));
        return this.executeSingle(this.makeStandardRequest((HttpUriRequest)httpPost), Media.class, JsonViews.Edit.class);
    }

    @Override
    public Media updateMedia(Media media) throws IOException, URISyntaxException {
        String url = this.makeBaseURIBuilder().setPathSegments(new String[]{"wp-json", "wp", "v2", "media", media.getId().toString()}).build().toURL().toString();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(this.mapper.writerWithView(JsonViews.Edit.class).writeValueAsString((Object)media), ContentType.APPLICATION_JSON));
        return this.executeSingle(this.makeStandardRequest((HttpUriRequest)httpPost), Media.class, JsonViews.Edit.class);
    }

    @Override
    public void deleteMedia(String id) throws IOException, URISyntaxException {
        this.executeSingle(this.makeStandardRequest((HttpUriRequest)new HttpDelete(this.makeBaseURIBuilder().setPathSegments(new String[]{"wp-json", "wp", "v2", "media", id}).build().toURL().toString())), Media.class, JsonViews.Read.class);
    }

    private <T> List<T> getAll(EntityGetter<T> getter, Optional<Map<String, String>> queryParams) throws IOException, URISyntaxException {
        ArrayList<T> entities = new ArrayList<T>();
        boolean lastPage = false;
        int pageNum = 1;
        while (!lastPage) {
            PagedResponse<T> response = getter.get(pageNum, 20, queryParams);
            entities.addAll(response);
            if (pageNum < response.getPages()) {
                ++pageNum;
                continue;
            }
            lastPage = true;
        }
        return entities;
    }

    private HttpUriRequest makeStandardRequest(HttpUriRequest request) {
        request.addHeader("Connection", (Object)"keep-alive");
        request.addHeader("Accept", (Object)"application/json");
        return this.authenticationProvider.addAuthenticationToRequest(request);
    }

    private URIBuilder makeBaseURIBuilder(Integer page, Integer perPage) throws MalformedURLException, URISyntaxException {
        return this.makeBaseURIBuilder().addParameter("page", page.toString()).addParameter("per_page", perPage.toString());
    }

    private URIBuilder makeBaseURIBuilder() throws URISyntaxException, MalformedURLException {
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(this.config.getScheme()).setHost(this.config.getHost());
        if (this.config.getPort() != null) {
            uriBuilder.setPort(this.config.getPort().intValue());
        }
        return uriBuilder;
    }

    private <T> T executeSingle(HttpUriRequest request, Class<T> entityClass, Class<?> viewClass) throws IOException {
        SingleResponseHandler handler = new SingleResponseHandler();
        String responseBody = (String)this.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)handler);
        return (T)this.mapper.readerWithView(viewClass).forType(entityClass).readValue(responseBody);
    }

    private <T> PagedResponse<T> executeList(HttpUriRequest request, Class<T> entityClass, Class<?> viewClass) throws IOException {
        PagedResponseHandler handler = new PagedResponseHandler();
        String responseBody = (String)this.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)handler);
        PagedResponse pagedResponse = new PagedResponse();
        pagedResponse.setTotal(handler.totalEntries);
        pagedResponse.setPages(handler.totalPages);
        CollectionType type = this.mapper.getTypeFactory().constructCollectionType(List.class, entityClass);
        List entries = (List)this.mapper.readerWithView(viewClass).forType((JavaType)type).readValue(responseBody);
        pagedResponse.addAll(entries);
        return pagedResponse;
    }

    private static interface EntityGetter<T> {
        public PagedResponse<T> get(Integer var1, Integer var2, Optional<Map<String, String>> var3) throws IOException, URISyntaxException;
    }

    private class PagedResponseHandler
    implements HttpClientResponseHandler<String> {
        public Integer totalPages;
        public Integer totalEntries;

        private PagedResponseHandler() {
        }

        public String handleResponse(ClassicHttpResponse response) throws HttpException, IOException {
            int status = response.getCode();
            if (status >= 200 && status < 300) {
                HttpEntity entity = response.getEntity();
                try {
                    this.totalEntries = Integer.valueOf(response.getHeader("X-Wp-Total").getValue());
                    this.totalPages = Integer.valueOf(response.getHeader("X-Wp-Totalpages").getValue());
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                catch (ParseException ex) {
                    throw new ClientProtocolException((Throwable)ex);
                }
            }
            throw new ClientProtocolException("Unexpected response status: " + status);
        }
    }

    private class SingleResponseHandler
    implements HttpClientResponseHandler<String> {
        private SingleResponseHandler() {
        }

        public String handleResponse(ClassicHttpResponse response) throws HttpException, IOException {
            int status = response.getCode();
            if (status >= 200 && status < 300) {
                HttpEntity entity = response.getEntity();
                try {
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                catch (ParseException ex) {
                    throw new ClientProtocolException((Throwable)ex);
                }
            }
            throw new ClientProtocolException("Unexpected response status: " + status);
        }
    }
}

