/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow;

import com.bea.wlw.netui.pageflow.FlowController;
import com.bea.wlw.netui.pageflow.GlobalApp;
import com.bea.wlw.netui.pageflow.PageFlowController;
import com.bea.wlw.netui.pageflow.PageFlowUtils;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.Stack;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FlowControllerFactory {
    private static final Debug debug;
    private static final Logger logger;
    private static final String WRONG_CLASS_NAME_PREFIX = "(wrong name: ";
    private static final String WRONG_CLASS_NAME_SUFFIX = ")";
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$FlowControllerFactory;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$PageFlowController;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$GlobalApp;

    public static PageFlowController getPageFlowForRequest(HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        String relativeUrl = PageFlowUtils.getRelativeURI(request, PageFlowUtils.decodeURI(request), null);
        String parentDir = PageFlowUtils.getModulePathForRelativeURI(relativeUrl);
        String jpfClassName = PageFlowUtils.getPageFlowClassName(parentDir, (ServletRequest)request, context);
        return jpfClassName != null ? FlowControllerFactory.getPageFlow(jpfClassName, request, response, context) : null;
    }

    public static FlowController getPageFlowForURI(HttpServletRequest request, HttpServletResponse response, String uri, ServletContext context) {
        String relativeUrl = PageFlowUtils.getRelativeURI(request, uri, null);
        String parentDir = PageFlowUtils.getModulePathForRelativeURI(relativeUrl);
        String jpfClassName = PageFlowUtils.getPageFlowClassName(parentDir, (ServletRequest)request, context);
        return jpfClassName != null ? FlowControllerFactory.getPageFlow(jpfClassName, request, response, context) : null;
    }

    public static PageFlowController getPageFlow(String jpfClassName, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        return FlowControllerFactory.getPageFlow(jpfClassName, request, response, servletContext, true);
    }

    private static PageFlowController getPageFlow(String jpfClassName, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, boolean correctWrongName) {
        try {
            Class<?> jpfClass = Class.forName(jpfClassName);
            return FlowControllerFactory.getPageFlow(jpfClass, request, response, servletContext, true);
        }
        catch (ClassNotFoundException e) {
            String uri = PageFlowUtils.decodeURI(request);
            if (debug.isOn()) {
                debug.out("info: no PageFlowController found for request " + uri + " (looked for " + jpfClassName + WRONG_CLASS_NAME_SUFFIX);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("No PageFlowController found for request " + uri));
            }
            return null;
        }
        catch (NoClassDefFoundError noDefError) {
            String msg;
            int prefix;
            if (correctWrongName && (prefix = (msg = noDefError.getMessage()).indexOf(WRONG_CLASS_NAME_PREFIX)) != -1) {
                String correctClass = msg.substring(prefix + WRONG_CLASS_NAME_PREFIX.length());
                int suffix = correctClass.lastIndexOf(WRONG_CLASS_NAME_SUFFIX);
                if (!$assertionsDisabled && suffix == -1) {
                    throw new AssertionError((Object)correctClass);
                }
                correctClass = correctClass.substring(0, suffix).replace('/', '.');
                if (debug.isOn()) {
                    debug.out("Got wrong class name " + jpfClassName + "; trying " + correctClass);
                }
                return FlowControllerFactory.getPageFlow(correctClass, request, response, servletContext, false);
            }
            throw noDefError;
        }
    }

    public static GlobalApp getGlobalApp(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        try {
            Class<?> globalAppClass = Class.forName("global.Global");
            return FlowControllerFactory.getGlobalApp(globalAppClass, request, response, servletContext);
        }
        catch (ClassNotFoundException e) {
            if (debug.isOn()) {
                debug.out("info: GlobalApp instance not found.");
            }
            logger.info((Object)"GlobalApp instance not found.");
            return null;
        }
    }

    static FlowController getFlowController(Class fcClass, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        if ((class$com$bea$wlw$netui$pageflow$PageFlowController == null ? (class$com$bea$wlw$netui$pageflow$PageFlowController = FlowControllerFactory.class$("com.bea.wlw.netui.pageflow.PageFlowController")) : class$com$bea$wlw$netui$pageflow$PageFlowController).isAssignableFrom(fcClass)) {
            return FlowControllerFactory.getPageFlow(fcClass, request, response, servletContext, true);
        }
        if (!$assertionsDisabled && !(class$com$bea$wlw$netui$pageflow$GlobalApp == null ? (class$com$bea$wlw$netui$pageflow$GlobalApp = FlowControllerFactory.class$("com.bea.wlw.netui.pageflow.GlobalApp")) : class$com$bea$wlw$netui$pageflow$GlobalApp).isAssignableFrom(fcClass)) {
            throw new AssertionError((Object)fcClass.getName());
        }
        return FlowControllerFactory.getGlobalApp(fcClass, request, response, servletContext);
    }

    static PageFlowController getPageFlow(Class jpfClass, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, boolean useCurrentIfAppropriate) {
        if (!(class$com$bea$wlw$netui$pageflow$PageFlowController == null ? (class$com$bea$wlw$netui$pageflow$PageFlowController = FlowControllerFactory.class$("com.bea.wlw.netui.pageflow.PageFlowController")) : class$com$bea$wlw$netui$pageflow$PageFlowController).isAssignableFrom(jpfClass)) {
            return null;
        }
        PageFlowController current = PageFlowUtils.getCurrentPageFlow(request);
        if (current != null && useCurrentIfAppropriate && current.getClass().equals(jpfClass)) {
            if (debug.isOn()) {
                debug.out("Using current PageFlow: " + current);
            }
            return current;
        }
        if (debug.isOn()) {
            debug.out("Creating PageFlowController of type " + jpfClass.getName());
        }
        try {
            PageFlowController retVal = (PageFlowController)jpfClass.newInstance();
            retVal.create(request, response, servletContext);
            if (retVal.isNestable(request, servletContext)) {
                if (current != null) {
                    if (debug.isOn()) {
                        debug.out("Pushing PageFlowController " + current + " onto the nesting stack");
                    }
                    Stack pfStack = PageFlowUtils.getPageFlowStack(request);
                    pfStack.push(current);
                    current.setIsOnNestingStack(true);
                    PageFlowUtils.ensurePageFlowStackFailover(request, pfStack);
                }
            } else {
                if (debug.isOn()) {
                    debug.out("Destroying the PageFlowController stack.");
                }
                PageFlowUtils.destroyPageFlowStack(request);
            }
            if (debug.isOn()) {
                debug.out("Storing " + retVal + " in the session...");
            }
            retVal.persistInSession(request, response, servletContext);
            return retVal;
        }
        catch (InstantiationException e) {
            logger.error((Object)("Could not instantiate PageFlowController of type " + jpfClass.getName()), (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("Could not instantiate PageFlowController of type " + jpfClass.getName()), (Throwable)e);
            return null;
        }
    }

    static GlobalApp getGlobalApp(Class globalAppClass, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        if (!$assertionsDisabled && !(class$com$bea$wlw$netui$pageflow$GlobalApp == null ? (class$com$bea$wlw$netui$pageflow$GlobalApp = FlowControllerFactory.class$("com.bea.wlw.netui.pageflow.GlobalApp")) : class$com$bea$wlw$netui$pageflow$GlobalApp).isAssignableFrom(globalAppClass)) {
            throw new AssertionError((Object)globalAppClass.getName());
        }
        GlobalApp current = PageFlowUtils.getGlobalApp(request);
        if (current != null && current.getClass().equals(globalAppClass)) {
            if (debug.isOn()) {
                debug.out("Using existing instance of GlobalApp: " + current);
            }
            return current;
        }
        if (debug.isOn()) {
            debug.out("Creating GlobalApp of type " + globalAppClass.getName());
        }
        try {
            GlobalApp retVal = (GlobalApp)globalAppClass.newInstance();
            retVal.create(request, response, servletContext);
            if (debug.isOn()) {
                debug.out("Storing " + retVal + " in the session...");
            }
            PageFlowUtils.setGlobalApp(retVal, request);
            return retVal;
        }
        catch (InstantiationException e) {
            logger.error((Object)("Could not instantiate GlobalApp of type " + globalAppClass.getName()), (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("Could not instantiate GlobalApp of type " + globalAppClass.getName()), (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$wlw$netui$pageflow$FlowControllerFactory == null ? (class$com$bea$wlw$netui$pageflow$FlowControllerFactory = FlowControllerFactory.class$("com.bea.wlw.netui.pageflow.FlowControllerFactory")) : class$com$bea$wlw$netui$pageflow$FlowControllerFactory).desiredAssertionStatus();
        debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$pageflow$FlowControllerFactory == null ? (class$com$bea$wlw$netui$pageflow$FlowControllerFactory = FlowControllerFactory.class$("com.bea.wlw.netui.pageflow.FlowControllerFactory")) : class$com$bea$wlw$netui$pageflow$FlowControllerFactory));
        logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$pageflow$FlowControllerFactory == null ? (class$com$bea$wlw$netui$pageflow$FlowControllerFactory = FlowControllerFactory.class$("com.bea.wlw.netui.pageflow.FlowControllerFactory")) : class$com$bea$wlw$netui$pageflow$FlowControllerFactory));
    }
}

