/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow.util;

import com.bea.wlw.netui.pageflow.GlobalApp;
import com.bea.wlw.netui.pageflow.PageFlowController;
import com.bea.wlw.netui.pageflow.PageFlowUtils;
import com.bea.wlw.netui.pageflow.util.URLRewriter;
import com.bea.wlw.netui.pageflow.util.URLRewriterService;
import com.bea.wlw.netui.util.logging.Logger;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class PageflowTagUtils {
    private static final Logger logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$pageflow$util$PageflowTagUtils == null ? (class$com$bea$wlw$netui$pageflow$util$PageflowTagUtils = PageflowTagUtils.class$("com.bea.wlw.netui.pageflow.util.PageflowTagUtils")) : class$com$bea$wlw$netui$pageflow$util$PageflowTagUtils));
    private static MessageResources messages = MessageResources.getMessageResources((String)"org.apache.struts.util.LocalStrings");
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$util$PageflowTagUtils;

    public static String getRewrittenFormAction(String action, PageContext pageContext) {
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        String actionUrl = PageflowTagUtils.createActionURL(pageContext, action);
        actionUrl = PageflowTagUtils.prepareActionUrl(pageContext, actionUrl);
        return response.encodeURL(actionUrl);
    }

    public static String prepareActionUrl(PageContext pageContext, String url) {
        ServletContext servletContext = pageContext.getServletContext();
        ServletRequest request = pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        String templateType = URLRewriter.ACTION_UNSECURE;
        if (URLRewriterService.needsSecure(request, servletContext, url, false)) {
            templateType = URLRewriter.ACTION_SECURE;
        }
        url = URLRewriterService.rewriteURL(servletContext, request, (ServletResponse)response, url, templateType);
        return response.encodeURL(url);
    }

    public static String prepareResourceUrl(PageContext pageContext, String url) {
        if (PageFlowUtils.isAbsoluteURI(url)) {
            return url;
        }
        ServletContext servletContext = pageContext.getServletContext();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        if (!url.startsWith("/")) {
            String reqUri = request.getRequestURI();
            String path = reqUri.substring(0, reqUri.lastIndexOf("/") + 1);
            url = path + url;
        }
        String templateType = URLRewriter.RESOURCE_UNSECURE;
        if (URLRewriterService.needsSecure((ServletRequest)request, servletContext, url, true)) {
            templateType = URLRewriter.RESOURCE_SECURE;
        }
        url = URLRewriterService.rewriteURL(servletContext, (ServletRequest)request, (ServletResponse)response, url, templateType);
        return response.encodeURL(url);
    }

    public static String createActionURL(PageContext pageContext, String action) {
        String servletMapping;
        ServletContext servletContext = pageContext.getServletContext();
        HttpServletRequest servletRequest = (HttpServletRequest)pageContext.getRequest();
        StringBuffer value = new StringBuffer();
        String pageURI = servletRequest.getRequestURI();
        int lastSlash = pageURI.lastIndexOf(47);
        if (lastSlash != -1) {
            value.append(pageURI.substring(0, lastSlash));
        }
        if ((servletMapping = (String)servletContext.getAttribute("org.apache.struts.action.SERVLET_MAPPING")) != null) {
            String queryString = null;
            int question = action.indexOf("?");
            if (question >= 0) {
                queryString = action.substring(question);
            }
            String actionMapping = URLRewriterService.getActionMappingName(action);
            if (servletMapping.startsWith("*.")) {
                value.append(actionMapping);
                value.append(servletMapping.substring(1));
            } else if (servletMapping.endsWith("/*")) {
                value.append(servletMapping.substring(0, servletMapping.length() - 2));
                value.append(actionMapping);
            } else if (servletMapping.equals("/")) {
                value.append(actionMapping);
            }
            if (queryString != null) {
                value.append(queryString);
            }
        } else {
            if (!action.startsWith("/")) {
                value.append("/");
            }
            value.append(action);
        }
        return value.toString();
    }

    public static String createActionPath(ServletContext servletContext, HttpServletRequest request, String action) {
        String servletMapping;
        StringBuffer value = new StringBuffer();
        ModuleConfig appConfig = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
        if (appConfig != null) {
            value.append(appConfig.getPrefix());
        }
        if ((servletMapping = (String)servletContext.getAttribute("org.apache.struts.action.SERVLET_MAPPING")) != null) {
            String queryString = null;
            int question = action.indexOf("?");
            if (question >= 0) {
                queryString = action.substring(question);
            }
            String actionMapping = URLRewriterService.getActionMappingName(action);
            if (servletMapping.startsWith("*.")) {
                value.append(actionMapping);
                value.append(servletMapping.substring(1));
            } else if (servletMapping.endsWith("/*")) {
                value.append(servletMapping.substring(0, servletMapping.length() - 2));
                value.append(actionMapping);
            } else if (servletMapping.equals("/")) {
                value.append(actionMapping);
            }
            if (queryString != null) {
                value.append(queryString);
            }
        } else {
            if (!action.startsWith("/")) {
                value.append("/");
            }
            value.append(action);
        }
        return value.toString();
    }

    public static String getActionPath(PageContext pageContext, String action) {
        return PageflowTagUtils.createActionPath(pageContext.getServletContext(), (HttpServletRequest)pageContext.getRequest(), action);
    }

    public static boolean isAction(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, String action) {
        boolean isAnAction = true;
        PageFlowController flowController = PageFlowUtils.getCurrentPageFlow(request);
        if (flowController != null) {
            GlobalApp globalController;
            String checkAction = action;
            if (checkAction.startsWith("/")) {
                checkAction = checkAction.substring(1);
            }
            if (checkAction.endsWith(".do")) {
                checkAction = checkAction.substring(0, checkAction.indexOf(".do"));
            }
            if (!(isAnAction = flowController.isAction(checkAction)) && (globalController = PageFlowUtils.ensureGlobalApp(request, response, servletContext)) != null) {
                isAnAction = globalController.isAction(checkAction);
            }
        }
        return isAnAction;
    }

    public static String computeURL(PageContext pageContext, String forward, String href, String page, Map params, String anchor, boolean redirect) throws MalformedURLException {
        return PageflowTagUtils.computeURL(pageContext, forward, href, page, null, params, anchor, redirect);
    }

    public static String computeURL(PageContext pageContext, String forward, String href, String page, String action, Map params, String anchor, boolean redirect) throws MalformedURLException {
        String encoding = pageContext.getResponse().getCharacterEncoding();
        int n = 0;
        if (forward != null) {
            ++n;
        }
        if (href != null) {
            ++n;
        }
        if (page != null) {
            ++n;
        }
        if (action != null) {
            ++n;
        }
        if (n != 1) {
            throw new MalformedURLException(messages.getMessage("computeURL.specifier"));
        }
        ModuleConfig config = (ModuleConfig)pageContext.getRequest().getAttribute("org.apache.struts.action.MODULE");
        if (config == null) {
            config = (ModuleConfig)pageContext.getServletContext().getAttribute("org.apache.struts.action.MODULE");
            pageContext.getRequest().setAttribute("org.apache.struts.action.MODULE", (Object)config);
        }
        StringBuffer url = new StringBuffer();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        if (forward != null) {
            ForwardConfig fc = config.findForwardConfig(forward);
            if (fc == null) {
                throw new MalformedURLException(messages.getMessage("computeURL.forward", (Object)forward));
            }
            if (fc.getRedirect()) {
                redirect = true;
            }
            if (fc.getPath().startsWith("/")) {
                url.append(request.getContextPath());
                url.append(RequestUtils.forwardURL((HttpServletRequest)request, (ForwardConfig)fc));
            } else {
                url.append(fc.getPath());
            }
        } else if (href != null) {
            url.append(href);
        } else if (action != null) {
            url.append(RequestUtils.getActionMappingURL((String)action, (PageContext)pageContext));
        } else {
            url.append(request.getContextPath());
            url.append(RequestUtils.pageURL((HttpServletRequest)request, (String)page));
        }
        if (anchor != null) {
            String temp = url.toString();
            int hash = temp.indexOf(35);
            if (hash >= 0) {
                url.setLength(hash);
            }
            url.append('#');
            url.append(PageflowTagUtils.encodeURL(anchor, encoding));
        }
        if (params != null && params.size() > 0) {
            PageflowTagUtils.addParameters(url, encoding, redirect, params);
        }
        return url.toString();
    }

    public static void addParameters(StringBuffer url, String encoding, boolean redirect, Map params) {
        if (params != null && params.size() > 0) {
            String anchor;
            String temp = url.toString();
            int hash = temp.indexOf(35);
            if (hash >= 0) {
                anchor = temp.substring(hash + 1);
                url.setLength(hash);
                temp = url.toString();
            } else {
                anchor = null;
            }
            String separator = "&amp;";
            if (redirect) {
                separator = "&";
            }
            boolean question = temp.indexOf(63) >= 0;
            Iterator keys = params.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = params.get(key);
                if (value == null) {
                    if (!question) {
                        url.append('?');
                        question = true;
                    } else {
                        url.append(separator);
                    }
                    url.append(PageflowTagUtils.encodeURL(key, encoding));
                    url.append('=');
                    continue;
                }
                if (value instanceof String) {
                    if (!question) {
                        url.append('?');
                        question = true;
                    } else {
                        url.append(separator);
                    }
                    url.append(PageflowTagUtils.encodeURL(key, encoding));
                    url.append('=');
                    url.append(PageflowTagUtils.encodeURL((String)value, encoding));
                    continue;
                }
                if (value instanceof String[]) {
                    String[] values = (String[])value;
                    int i = 0;
                    while (i < values.length) {
                        if (!question) {
                            url.append('?');
                            question = true;
                        } else {
                            url.append(separator);
                        }
                        url.append(PageflowTagUtils.encodeURL(key, encoding));
                        url.append('=');
                        url.append(PageflowTagUtils.encodeURL(values[i], encoding));
                        ++i;
                    }
                    continue;
                }
                if (!question) {
                    url.append('?');
                    question = true;
                } else {
                    url.append(separator);
                }
                url.append(PageflowTagUtils.encodeURL(key, encoding));
                url.append('=');
                url.append(PageflowTagUtils.encodeURL(value.toString(), encoding));
            }
            if (anchor != null) {
                url.append('#');
                url.append(PageflowTagUtils.encodeURL(anchor, encoding));
            }
        }
    }

    public static String encodeURL(String url, String encoding) {
        String encodedURL = null;
        try {
            encodedURL = URLEncoder.encode(url, encoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("Unsupported encoding:" + encoding), (Throwable)e);
            try {
                encodedURL = URLEncoder.encode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException ignore) {}
        }
        return encodedURL;
    }

    public static String addParam(String url, String paramName, String paramVal) {
        return url + (url.indexOf(63) != -1 ? (char)'&' : '?') + paramName + '=' + paramVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

