/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow.util;

import com.bea.wlw.netui.pageflow.PageFlowUtils;
import com.bea.wlw.netui.pageflow.util.UrlTemplateDescriptor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateHelper
implements Cloneable {
    public static final String POSTBACK_PARAM = "_nfpb";
    public static final String WINDOW_LABEL_PARAM = "_windowLabel";
    public static final String STATE_PARAM = "_state";
    public static final String MODE_PARAM = "_mode";
    public static final String PAGE_LABEL_PARAM = "_pageLabel";
    public static final String CONTROL_STATE_PARAM = "__controlState";
    protected HttpServletRequest httpRequest;
    protected HttpServletResponse httpResponse;
    private String template;
    private String scheme;
    private int port;
    private String domain;
    private String pathPrefix;
    private String path;
    private String queryString;
    private boolean encodeSession;
    protected LinkedHashMap params;

    public TemplateHelper(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.scheme = httpRequest.getScheme();
        this.port = httpRequest.getServerPort();
        this.domain = httpRequest.getServerName();
        this.encodeSession = true;
    }

    public boolean hasTemplateRef(String templateRef) {
        String ref = UrlTemplateDescriptor.getInstance().getJPFUrlTemplateRef(templateRef);
        return ref != null;
    }

    public String getTemplateName(String templateRef) {
        String ref = UrlTemplateDescriptor.getInstance().getJPFUrlTemplateRef(templateRef);
        return ref;
    }

    public void setTemplate(String templateName) {
        String _template = UrlTemplateDescriptor.getInstance().getUrlTemplate(templateName);
        if (_template == null) {
            throw new IllegalArgumentException("URL template " + templateName + " does not exist");
        }
        this.template = _template;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setPath(String path) {
        this.path = path;
    }

    private String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setEncodeSession(boolean encodeSession) {
        this.encodeSession = encodeSession;
    }

    public boolean getEncodeSession() {
        return this.encodeSession;
    }

    public void setUrl(String url) {
        try {
            URI uri;
            int query = url.indexOf(63);
            String queryString = null;
            if (query != -1) {
                queryString = url.substring(query + 1);
                url = url.substring(0, query);
            }
            if ((uri = new URI(url)).getScheme() != null) {
                this.setScheme(uri.getScheme());
            }
            if (uri.getHost() != null) {
                this.setDomain(uri.getHost());
            }
            if (uri.getPort() > -1) {
                this.setPort(uri.getPort());
            }
            if (uri.getPath() != null) {
                this.setPath(uri.getPath());
            }
            if (queryString != null) {
                this.setQueryString(queryString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addParameter(String name, String value) {
        ArrayList<String> values;
        if (this.params == null) {
            this.params = new LinkedHashMap();
        }
        if ((values = (ArrayList<String>)this.params.get(name)) == null) {
            values = new ArrayList<String>();
            this.params.put(name, values);
        }
        values.add(value);
    }

    public void removeParameter(String name) {
        if (this.params == null) {
            return;
        }
        this.params.remove(name);
    }

    public String getParameter(String name) {
        if (this.params == null) {
            return null;
        }
        List values = (List)this.params.get(name);
        if (values != null && values.size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    public List getParameters(String name) {
        if (this.params == null) {
            return new ArrayList(0);
        }
        List values = (List)this.params.get(name);
        return values;
    }

    public Object clone() {
        TemplateHelper other = new TemplateHelper(this.httpRequest, this.httpResponse);
        other.setDomain(this.getDomain());
        other.setEncodeSession(this.getEncodeSession());
        other.setPathPrefix(this.getPath());
        other.setPathPrefix(this.getPathPrefix());
        other.setPort(this.getPort());
        other.setScheme(this.getScheme());
        other.setTemplate(this.getTemplate());
        other.setQueryString(this.getQueryString());
        if (this.params != null) {
            other.params = new LinkedHashMap(this.params.size());
            Iterator iterator = this.params.keySet().iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                ArrayList values = (ArrayList)this.params.get(name);
                other.params.put(name, values.clone());
            }
        }
        return other;
    }

    private static StringBuffer appendEnsureSeparator(StringBuffer buf, String token) {
        if (token != null && token.length() > 0) {
            if (buf.charAt(buf.length() - 1) != '/' && token.charAt(0) != '/') {
                buf.append("/");
            }
            if (buf.charAt(buf.length() - 1) == '/' && token.charAt(0) == '/') {
                token = token.substring(1);
            }
            buf.append(token);
        }
        return buf;
    }

    public String toString() {
        String val = null;
        val = this.getTemplate() == null ? this.toStringDefault() : this.toStringTemplate();
        return val;
    }

    private String toStringDefault() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.scheme).append("://");
        buf.append(this.domain).append(":").append(this.port);
        buf = TemplateHelper.appendEnsureSeparator(buf, this.getPathPrefix());
        if (this.getPath() != null) {
            buf = TemplateHelper.appendEnsureSeparator(buf, this.getPath());
        } else {
            String desktopPath = (String)this.httpRequest.getAttribute("desktopPath");
            String portalPath = (String)this.httpRequest.getAttribute("portalPath");
            if (desktopPath == null && portalPath == null) {
                buf = TemplateHelper.appendEnsureSeparator(buf, this.httpRequest.getRequestURI());
            } else {
                String webAppName = PageFlowUtils.getServerAdapter().getFullContextPath(this.httpRequest);
                buf = TemplateHelper.appendEnsureSeparator(buf, webAppName);
                String servletName = this.httpRequest.getServletPath();
                buf = TemplateHelper.appendEnsureSeparator(buf, servletName);
                buf = TemplateHelper.appendEnsureSeparator(buf, portalPath);
                buf = TemplateHelper.appendEnsureSeparator(buf, desktopPath);
            }
        }
        if (this.params != null && this.params.size() > 0) {
            buf.append("?");
            if (this.queryString != null) {
                buf.append(this.queryString);
            }
            Iterator iterator = this.params.keySet().iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                List values = (List)this.params.get(name);
                int i = 0;
                while (i < values.size()) {
                    char lastChar = buf.charAt(buf.length() - 1);
                    if (lastChar != '?' && lastChar != '&') {
                        buf.append("&");
                    }
                    buf.append(name).append("=").append(values.get(i));
                    ++i;
                }
            }
        } else if (buf.charAt(buf.length() - 1) == '&' || buf.charAt(buf.length() - 1) == '?') {
            buf.deleteCharAt(buf.length() - 1);
        }
        String url = buf.toString();
        if (this.encodeSession) {
            url = this.httpResponse.encodeURL(url);
        }
        return url;
    }

    private String toStringTemplate() {
        String _template = new String(this.template);
        _template = TemplateHelper.replace(_template, "{url:scheme}", this.getScheme());
        _template = TemplateHelper.replace(_template, "{url:domain}", this.getDomain());
        _template = this.replace(_template, "{url:port}", this.getPort());
        _template = TemplateHelper.replace(_template, "{url:prefix}", this.getPathPrefix());
        StringBuffer buf = new StringBuffer();
        if (this.getPath() != null) {
            buf.append(this.getPath());
        } else {
            String desktopPath = (String)this.httpRequest.getAttribute("desktopPath");
            String portalPath = (String)this.httpRequest.getAttribute("portalPath");
            if (desktopPath == null && portalPath == null) {
                buf = buf.append(this.httpRequest.getRequestURI());
            } else {
                String webAppName = PageFlowUtils.getServerAdapter().getFullContextPath(this.httpRequest);
                buf.append(webAppName);
                String servletName = this.httpRequest.getServletPath();
                buf = TemplateHelper.appendEnsureSeparator(buf, servletName);
                buf = TemplateHelper.appendEnsureSeparator(buf, portalPath);
                buf = TemplateHelper.appendEnsureSeparator(buf, desktopPath);
            }
        }
        _template = TemplateHelper.replace(_template, "{url:path}", buf.toString());
        buf = new StringBuffer();
        if (this.queryString != null) {
            buf.append(this.queryString);
        }
        if (this.params != null && this.params.size() > 0) {
            Iterator iterator = this.params.keySet().iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                List values = (List)this.params.get(name);
                int i = 0;
                while (i < values.size()) {
                    char lastChar;
                    if (buf.length() > 0 && (lastChar = buf.charAt(buf.length() - 1)) != '?' && lastChar != '&') {
                        buf.append("&");
                    }
                    buf.append(name).append("=").append(values.get(i));
                    ++i;
                }
            }
        }
        _template = TemplateHelper.replace(_template, "{url:queryString}", buf.toString());
        return _template;
    }

    private static String replace(String template, String param, String value) {
        if (value == null) {
            return template;
        }
        int index = template.indexOf(param);
        if (index != -1) {
            String post;
            String pre = template.substring(0, index);
            if (pre.length() > 0 && value.length() > 0 && pre.charAt(pre.length() - 1) == '/' && value.charAt(0) == '/') {
                value = value.substring(1);
            }
            if ((post = template.substring(index + param.length())).length() > 0 && value.length() > 0 && post.charAt(0) == '/' && value.charAt(value.length() - 1) == '/') {
                post = post.substring(1);
            }
            template = pre + value + post;
        }
        return template;
    }

    private String replace(String template, String param, int value) {
        String valueStr = Integer.toString(value);
        return TemplateHelper.replace(template, param, valueStr);
    }
}

