/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow.util;

import com.bea.wlw.netui.pageflow.PageFlowUtils;
import com.bea.wlw.netui.pageflow.util.DefaultURLRewriter;
import com.bea.wlw.netui.pageflow.util.URLRewriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class URLRewriterService {
    private static URLRewriter defaultRewriter = new DefaultURLRewriter();
    private static String URL_REWRITER_KEY = "url_rewriter";

    public static final URLRewriter getDefaultRewriter() {
        return new DefaultURLRewriter();
    }

    public static String rewriteName(ServletContext servletContext, ServletRequest request, String name) {
        URLRewriter rewriter = (URLRewriter)request.getAttribute(URL_REWRITER_KEY);
        String rewrittenName = null;
        rewrittenName = rewriter != null ? rewriter.rewriteName(servletContext, request, name) : defaultRewriter.rewriteName(servletContext, request, name);
        return rewrittenName;
    }

    public static String rewriteURL(ServletContext servletContext, ServletRequest request, ServletResponse response, String url, String type) {
        return URLRewriterService.rewriteURL(servletContext, request, response, url, type, true);
    }

    public static String rewriteURL(ServletContext servletContext, ServletRequest request, ServletResponse response, String url, String type, boolean doEncode) {
        URLRewriter rewriter = (URLRewriter)request.getAttribute(URL_REWRITER_KEY);
        String rewrittenURL = null;
        rewrittenURL = rewriter != null ? rewriter.rewriteURL(servletContext, request, response, url, type) : defaultRewriter.rewriteURL(servletContext, request, response, url, type);
        if (doEncode) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            rewrittenURL = httpResponse.encodeRedirectURL(rewrittenURL.toString());
        }
        return rewrittenURL;
    }

    public static void registerURLRewriter(ServletRequest request, URLRewriter rewriter) {
        request.setAttribute(URL_REWRITER_KEY, (Object)rewriter);
    }

    public static URLRewriter unregisterURLRewriter(ServletRequest request) {
        URLRewriter rewriter = (URLRewriter)request.getAttribute(URL_REWRITER_KEY);
        request.removeAttribute(URL_REWRITER_KEY);
        return rewriter;
    }

    public static String getActionMappingName(String action) {
        String value = action;
        int question = action.indexOf("?");
        if (question >= 0) {
            value = value.substring(0, question);
        }
        int slash = value.lastIndexOf("/");
        int period = value.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            value = value.substring(0, period);
        }
        if (value.startsWith("/")) {
            return value;
        }
        return "/" + value;
    }

    public static boolean needsSecure(ServletRequest request, ServletContext context, String uri, boolean stripContextPath) {
        Boolean secureResource;
        String secureCheck = uri;
        if (stripContextPath && secureCheck.substring(1).indexOf("/") > -1) {
            secureCheck = secureCheck.substring(1);
            secureCheck = secureCheck.substring(secureCheck.indexOf("/"));
        }
        boolean secure = false;
        if (secureCheck.indexOf("?") > -1) {
            secureCheck = secureCheck.substring(0, secureCheck.indexOf("?"));
        }
        secure = (secureResource = PageFlowUtils.isSecureResource(secureCheck, context, (HttpServletRequest)request)) == null ? request.isSecure() : secureResource.booleanValue();
        return secure;
    }

    public static boolean allowParamsOnFormAction(ServletContext servletContext, ServletRequest request) {
        URLRewriter rewriter = (URLRewriter)request.getAttribute(URL_REWRITER_KEY);
        return rewriter != null ? rewriter.allowParamsOnFormAction(servletContext, request) : true;
    }
}

