/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags;

import com.bea.wlw.netui.script.ExpressionEvaluationException;
import com.bea.wlw.netui.tags.AbstractBaseTag;
import com.bea.wlw.netui.tags.EvalErrorInfo;
import com.bea.wlw.netui.tags.naming.FormDataNameInterceptor;
import com.bea.wlw.netui.tags.naming.IndexedNameInterceptor;
import com.bea.wlw.netui.tags.naming.NameInterceptor;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

public abstract class DataSourceTag
extends AbstractBaseTag {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$tags$DataSourceTag == null ? (class$com$bea$wlw$netui$tags$DataSourceTag = DataSourceTag.class$("com.bea.wlw.netui.tags.DataSourceTag")) : class$com$bea$wlw$netui$tags$DataSourceTag));
    private List namingChain = null;
    private String dataSource = null;
    static /* synthetic */ Class class$com$bea$wlw$netui$tags$DataSourceTag;

    public DataSourceTag() {
        this.addNamingInterceptor(new FormDataNameInterceptor());
        this.addNamingInterceptor(new IndexedNameInterceptor((Tag)this));
    }

    protected void localRelease() {
        super.localRelease();
        this.dataSource = null;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    protected void addNamingInterceptor(NameInterceptor item) {
        if (this.namingChain == null) {
            this.namingChain = new ArrayList();
        }
        this.namingChain.add(item);
    }

    protected void removeNamingInterceptor(NameInterceptor item) {
        if (this.namingChain == null) {
            return;
        }
        int i = 0;
        while (i < this.namingChain.size()) {
            if (this.namingChain.get(i) == item) {
                this.namingChain.remove(item);
            }
            ++i;
        }
    }

    protected String qualifyAttribute(String name) throws JspException {
        block3: {
            if (name == null) {
                return null;
            }
            try {
                name = new FormDataNameInterceptor().rewriteName(name);
            }
            catch (Exception e) {
                String msg = "An error occurred converting the data source \"" + name + "\" into an expression; " + e.toString();
                msg = this.registerTagError(msg);
                if (msg == null) break block3;
                throw new JspException(msg);
            }
        }
        return name;
    }

    protected Object evaluateDataSource() throws JspException {
        String currDataSource = null;
        try {
            currDataSource = this.getDataSource();
            boolean isExpr = this.isExpression(currDataSource);
            if (!isExpr && this.containsExpression(currDataSource)) {
                String s = Bundle.getString((String)"DataSourceError", (Object[])new Object[]{currDataSource});
                if ((s = this.registerTagError(s)) != null) {
                    throw new JspException(s);
                }
                return null;
            }
            if (!isExpr) {
                this.setDataSource(this.qualifyAttribute(currDataSource));
                if (!this.isExpression(this.getDataSource())) {
                    String s = Bundle.getString((String)"DataSourceError", (Object[])new Object[]{currDataSource});
                    if ((s = this.registerTagError(s)) != null) {
                        throw new JspException(s);
                    }
                    return null;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof JspException) {
                throw (JspException)((Object)e);
            }
            String s = Bundle.getString((String)"DataSourceError", (Object[])new Object[]{currDataSource});
            if ((s = this.registerTagError(s)) != null) {
                throw new JspException(s);
            }
            return null;
        }
        return this.evaluateExpression(this.getDataSource(), "dataSource");
    }

    protected String doNaming() throws JspException {
        String name = this.getDataSource();
        if (DataSourceTag.debug.ON) {
            debug.out("rewrite name \"" + name + "\" on tag of type \"" + ((Object)((Object)this)).getClass().getName() + " with namingChain " + (this.namingChain != null ? "size " + this.namingChain.size() : "null"));
        }
        if (this.namingChain == null) {
            return this.rewriteName(name);
        }
        try {
            String newName = name;
            int i = 0;
            while (i < this.namingChain.size()) {
                if (DataSourceTag.debug.ON) {
                    debug.out("rewriteName: \"" + newName + "\" with NameInterceptor: " + this.namingChain.get(i).getClass().getName());
                }
                newName = ((NameInterceptor)this.namingChain.get(i)).rewriteName(newName);
                if (DataSourceTag.debug.ON) {
                    debug.out("rewrite result: " + newName);
                }
                ++i;
            }
            return this.rewriteName(newName);
        }
        catch (ExpressionEvaluationException ee) {
            Logger.error((String)Bundle.getString((String)"Tags_ExpressionQualifyingFailure", (Object)name), ((Object)((Object)this)).getClass());
            EvalErrorInfo info = new EvalErrorInfo();
            info.evalExcp = ee;
            info.expression = name;
            info.attr = "dataSource";
            info.tagType = this.getTagName();
            this.registerError(info);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

