/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.html;

import com.bea.wlw.netui.tags.html.FormatTag;
import com.bea.wlw.netui.tags.html.Formattable;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.logging.Logger;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import weblogic.utils.UnsyncStringBuffer;

public class FormatDate
extends FormatTag {
    static String[] commonFormats = new String[]{"MM/dd/yy", "yyyy-MM-dd", "MMddyy", null};
    private String _stringInput;

    public String getTagName() {
        return "FormatDate";
    }

    public void setStringInputPattern(String pattern) {
        this._stringInput = pattern;
    }

    public String getStringInputPattern() {
        return this._stringInput;
    }

    public int doStartTag() throws JspException {
        if (this.hasErrors()) {
            this.reportErrors();
            this.localRelease();
            return 6;
        }
        Tag parentTag = this.getParent();
        if (parentTag instanceof Formattable) {
            if (this.containsExpression(this._stringInput)) {
                Object o = this.evaluateExpression(this._stringInput, "stringInputPattern");
                this._stringInput = o != null ? o.toString() : null;
            }
            DateFormatter formatter = new DateFormatter();
            formatter.setPattern(this.patternValue);
            formatter.setLocale(this.getLocale());
            formatter.setInputPattern(this._stringInput);
            Formattable parent = (Formattable)parentTag;
            parent.addFormatter(formatter);
        }
        this.localRelease();
        return 0;
    }

    protected void localRelease() {
        super.localRelease();
        this._stringInput = null;
    }

    public static class DateFormatter
    extends FormatTag.Formatter {
        private String type;
        private Locale locale;
        private String inputPattern;

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public void setInputPattern(String pattern) {
            this.inputPattern = pattern;
        }

        public String format(Object dataToFormat) throws JspException {
            if (dataToFormat == null) {
                return null;
            }
            UnsyncStringBuffer formattedString = new UnsyncStringBuffer(32);
            SimpleDateFormat dateFormat = null;
            dateFormat = this.getPattern() != null ? (this.locale != null ? new SimpleDateFormat(this.getPattern(), this.locale) : new SimpleDateFormat(this.getPattern())) : new SimpleDateFormat();
            if (dataToFormat instanceof java.sql.Date) {
                java.sql.Date date = (java.sql.Date)dataToFormat;
                formattedString.append(dateFormat.format(date));
            } else if (dataToFormat instanceof Date) {
                Date date = (Date)dataToFormat;
                formattedString.append(dateFormat.format(date));
            } else if (dataToFormat instanceof Calendar) {
                Calendar c = (Calendar)dataToFormat;
                Date date = new Date(c.getTimeInMillis());
                formattedString.append(dateFormat.format(date));
            } else if (dataToFormat instanceof String) {
                if (((String)dataToFormat).equals("")) {
                    return "";
                }
                SimpleDateFormat df = null;
                if (this.inputPattern != null) {
                    try {
                        df = new SimpleDateFormat(this.inputPattern);
                    }
                    catch (IllegalArgumentException e) {
                        String s = Bundle.getString((String)"Tags_formatDate_StringPatternError", (Object[])new Object[]{this.inputPattern, e.getMessage()});
                        Logger.error((String)s, this.getClass());
                        throw new JspException(s);
                    }
                    Date date = ((DateFormat)df).parse((String)dataToFormat, new ParsePosition(0));
                    if (date != null) {
                        formattedString.append(dateFormat.format(date));
                        return formattedString.toString();
                    }
                }
                int i = 0;
                while (i < commonFormats.length) {
                    df = commonFormats[i] != null ? new SimpleDateFormat(commonFormats[i]) : new SimpleDateFormat();
                    Date date = ((DateFormat)df).parse((String)dataToFormat, new ParsePosition(0));
                    if (date != null) {
                        formattedString.append(dateFormat.format(date));
                        break;
                    }
                    ++i;
                }
                if (i == commonFormats.length) {
                    String s = Bundle.getString((String)"Tags_formatDate_String_Error", (Object[])new Object[]{dataToFormat});
                    Logger.error((String)s, this.getClass());
                    throw new JspException(s);
                }
            } else {
                String s = Bundle.getString((String)"Tags_formatDate_Type_Error", (Object[])new Object[]{dataToFormat.getClass().getName()});
                Logger.error((String)s, this.getClass());
                throw new JspException(s);
            }
            return formattedString.toString();
        }
    }
}

