/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.html;

import com.bea.wlw.netui.pageflow.PageFlowUtils;
import com.bea.wlw.netui.pageflow.util.PageflowTagUtils;
import com.bea.wlw.netui.pageflow.util.URLRewriterService;
import com.bea.wlw.netui.script.ExpressionEvaluatorFactory;
import com.bea.wlw.netui.script.ExpressionUpdateException;
import com.bea.wlw.netui.script.IllegalExpressionException;
import com.bea.wlw.netui.tags.DataSourceTag;
import com.bea.wlw.netui.tags.html.TreeNode;
import com.bea.wlw.netui.util.Bundle;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import weblogic.utils.UnsyncStringBuffer;

public class Tree
extends DataSourceTag {
    static final String DEFAULT_IMAGES = "images";
    static final String IMAGE_HANDLE_DOWN_LAST = "handledownlast.gif";
    static final String IMAGE_HANDLE_DOWN_MIDDLE = "handledownmiddle.gif";
    static final String IMAGE_HANDLE_RIGHT_LAST = "handlerightlast.gif";
    static final String IMAGE_HANDLE_RIGHT_MIDDLE = "handlerightmiddle.gif";
    static final String IMAGE_LINE_LAST = "linelastnode.gif";
    static final String IMAGE_LINE_MIDDLE = "linemiddlenode.gif";
    static final String IMAGE_LINE_VERTICAL = "linevertical.gif";
    protected String imageHandleDownLast = "handledownlast.gif";
    protected String imageHandleDownMiddle = "handledownmiddle.gif";
    protected String imageHandleRightLast = "handlerightlast.gif";
    protected String imageHandleRightMiddle = "handlerightmiddle.gif";
    protected String imageLineLast = "linelastnode.gif";
    protected String imageLineMiddle = "linemiddlenode.gif";
    protected String imageLineVertical = "linevertical.gif";
    protected String action = null;
    protected String imageRoot = "images";
    protected TreeNode rootNode = null;
    protected String style = null;
    protected String styleSelected = null;
    protected String styleUnselected = null;
    protected String tree = null;
    private TreeNode treeNode = null;
    private boolean shouldExit = false;

    public String getTagName() {
        return "Tree";
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getImageHandleDownLast() {
        return this.imageHandleDownLast;
    }

    public void setImageHandleDownLast(String imageHandleDownLast) {
        this.imageHandleDownLast = imageHandleDownLast;
    }

    public String getImageHandleDownMiddle() {
        return this.imageHandleDownMiddle;
    }

    public void setImageHandleDownMiddle(String imageHandleDownMiddle) {
        this.imageHandleDownMiddle = imageHandleDownMiddle;
    }

    public String getImageHandleRightLast() {
        return this.imageHandleRightLast;
    }

    public void setImageHandleRightLast(String imageHandleRightLast) {
        this.imageHandleRightLast = imageHandleRightLast;
    }

    public String getImageHandleRightMiddle() {
        return this.imageHandleRightMiddle;
    }

    public void setImageHandleRightMiddle(String imageHandleRightMiddle) {
        this.imageHandleRightMiddle = imageHandleRightMiddle;
    }

    public String getImageLineLast() {
        return this.imageLineLast;
    }

    public void setImageLineLast(String imageLineLast) {
        this.imageLineLast = imageLineLast;
    }

    public String getImageLineMiddle() {
        return this.imageLineMiddle;
    }

    public void setImageLineMiddle(String imageLineMiddle) {
        this.imageLineMiddle = imageLineMiddle;
    }

    public String getImageLineVertical() {
        return this.imageLineVertical;
    }

    public void setImageLineVertical(String imageLineVertical) {
        this.imageLineVertical = imageLineVertical;
    }

    public String getImageRoot() {
        return this.imageRoot;
    }

    public void setImageRoot(String imageRoot) {
        this.imageRoot = imageRoot;
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(TreeNode rootNode) {
        this.rootNode = rootNode;
        if (rootNode.getName() == null) {
            rootNode.setName("0");
        }
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleSelected() {
        return this.styleSelected;
    }

    public void setStyleSelected(String styleSelected) {
        this.styleSelected = styleSelected;
    }

    public String getStyleUnselected() {
        return this.styleUnselected;
    }

    public void setStyleUnselected(String styleUnselected) {
        this.styleUnselected = styleUnselected;
    }

    public String getTree() {
        return this.tree;
    }

    public void setTree(String tree) {
        this.tree = tree;
    }

    public int doStartTag() throws JspException {
        TreeNode node;
        block4: {
            node = null;
            try {
                node = this.getTreeRoot();
            }
            catch (IllegalExpressionException iee) {
                String s = Bundle.getString((String)"TreeRootError", (Object[])new Object[]{this.tree, iee.getMessage()});
                s = this.registerTagError(s);
                if (s == null) break block4;
                throw new JspException(s);
            }
        }
        if (this.hasErrors()) {
            this.reportErrors();
            this.shouldExit = true;
            return 0;
        }
        if (node == null) {
            return 2;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        if (this.shouldExit) {
            this.localRelease();
            return 6;
        }
        TreeNode treeRoot = this.getTreeRoot();
        if (this.hasErrors()) {
            this.reportErrors();
            this.localRelease();
            return 6;
        }
        if (treeRoot == null) {
            if (this.rootNode != null) {
                if (this.isExpression(this.tree)) {
                    HashMap map = new HashMap();
                    this.populateAvailableContexts(map);
                    try {
                        ExpressionEvaluatorFactory.getInstance().update(this.tree, (Object)this.rootNode, map, false);
                    }
                    catch (ExpressionUpdateException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.pageContext.getSession().setAttribute(this.tree, (Object)this.rootNode);
                }
                treeRoot = this.rootNode;
            }
            if (treeRoot == null) {
                String s = Bundle.getString((String)"Tags_TreeNoAttribute", (Object)this.tree);
                if ((s = this.registerTagError(s)) != null) {
                    throw new JspException(s);
                }
                this.reportErrors();
                this.localRelease();
                return 6;
            }
        }
        JspWriter out = this.pageContext.getOut();
        try {
            out.print("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"");
            if (this.style != null) {
                out.print(" class=\"");
                out.print(this.style);
                out.print("\"");
            }
            out.println(">");
            int level = 0;
            this.render(out, treeRoot, level, treeRoot.getWidth(), true);
            out.println("</table>");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        this.localRelease();
        return 6;
    }

    protected void localRelease() {
        super.localRelease();
        this.imageHandleDownLast = IMAGE_HANDLE_DOWN_LAST;
        this.imageHandleDownMiddle = IMAGE_HANDLE_DOWN_MIDDLE;
        this.imageHandleRightLast = IMAGE_HANDLE_RIGHT_LAST;
        this.imageHandleRightMiddle = IMAGE_HANDLE_RIGHT_MIDDLE;
        this.imageLineLast = IMAGE_LINE_LAST;
        this.imageLineMiddle = IMAGE_LINE_MIDDLE;
        this.imageLineVertical = IMAGE_LINE_VERTICAL;
        this.action = null;
        this.imageRoot = DEFAULT_IMAGES;
        this.rootNode = null;
        this.style = null;
        this.styleSelected = null;
        this.styleUnselected = null;
        this.tree = null;
        this.treeNode = null;
        this.shouldExit = false;
    }

    protected TreeNode getTreeRoot() throws JspException {
        Object treeNode = null;
        treeNode = this.isExpression(this.tree) ? this.evaluateExpression(this.tree, "tree") : this.pageContext.getAttribute(this.tree, 3);
        if (this.hasErrors()) {
            return null;
        }
        if (treeNode != null) {
            if (!(treeNode instanceof TreeNode)) {
                String s = Bundle.getString((String)"Tags_TreeInvalidAttribute", (Object)this.tree);
                if ((s = this.registerTagError(s)) != null) {
                    throw new JspException(s);
                }
                return null;
            }
            return (TreeNode)treeNode;
        }
        return null;
    }

    protected void render(JspWriter out, TreeNode node, int level, int width, boolean last) throws IOException {
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        String encoding = response.getCharacterEncoding();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if ("ROOT-NODE".equalsIgnoreCase(node.getName()) && node.getLabel() == null) {
            TreeNode[] children = node.getChildren();
            int lastIndex = children.length - 1;
            int newLevel = level + 1;
            int i = 0;
            while (i < children.length) {
                this.render(out, children[i], newLevel, width, i == lastIndex);
                ++i;
            }
            return;
        }
        out.println("  <tr valign=\"middle\">");
        int i = 0;
        while (i < level) {
            int levels = level - i;
            TreeNode parent = node;
            int j = 1;
            while (j <= levels) {
                parent = parent.getParent();
                ++j;
            }
            if (parent.isLast()) {
                out.print("    <td></td>");
            } else {
                out.print("    <td><img src=\"");
                out.print(this.imageRoot);
                out.print("/");
                out.print(this.imageLineVertical);
                out.print("\" border=\"0\"></td>");
            }
            out.println();
            ++i;
        }
        String encodedNodeName = URLEncoder.encode(node.getName(), encoding);
        boolean isAction = PageflowTagUtils.isAction((HttpServletRequest)request, (HttpServletResponse)response, (ServletContext)this.pageContext.getServletContext(), (String)this.action);
        if (!isAction) {
            this.registerTagError(Bundle.getString((String)"Tags_BadAction", (Object)this.action));
            return;
        }
        String action = PageflowTagUtils.createActionURL((PageContext)this.pageContext, (String)this.getAction());
        action = (action = PageflowTagUtils.prepareActionUrl((PageContext)this.pageContext, (String)action)).indexOf("?") > -1 ? action + "&" + URLRewriterService.rewriteName((ServletContext)this.pageContext.getServletContext(), (ServletRequest)request, (String)"netui_treenode") + "=" + encodedNodeName : action + "?" + URLRewriterService.rewriteName((ServletContext)this.pageContext.getServletContext(), (ServletRequest)request, (String)"netui_treenode") + "=" + encodedNodeName;
        out.print("    <td>");
        if (action != null && !node.isLeaf()) {
            out.print("<a href=\"");
            out.print(action);
            out.print("\">");
        }
        out.print("<img src=\"");
        out.print(this.imageRoot);
        out.print("/");
        if (node.isLeaf()) {
            if (node.isLast()) {
                out.print(this.imageLineLast);
            } else {
                out.print(this.imageLineMiddle);
            }
        } else if (node.isExpanded()) {
            if (node.isLast()) {
                out.print(this.imageHandleDownLast);
            } else {
                out.print(this.imageHandleDownMiddle);
            }
        } else if (node.isLast()) {
            out.print(this.imageHandleRightLast);
        } else {
            out.print(this.imageHandleRightMiddle);
        }
        out.print("\" border=\"0\">");
        if (action != null && !node.isLeaf()) {
            out.print("</a>");
        }
        out.println("</td>");
        String hyperlink = null;
        if (node.getAction() != null) {
            hyperlink = PageflowTagUtils.createActionURL((PageContext)this.pageContext, (String)node.getAction());
            hyperlink = hyperlink.indexOf("?") > -1 ? hyperlink + "&" + URLRewriterService.rewriteName((ServletContext)this.pageContext.getServletContext(), (ServletRequest)request, (String)"netui_treeselected") + "=" + encodedNodeName : hyperlink + "?" + URLRewriterService.rewriteName((ServletContext)this.pageContext.getServletContext(), (ServletRequest)request, (String)"netui_treeselected") + "=" + encodedNodeName;
        } else if (node.getHref() != null) {
            hyperlink = node.getHref();
        }
        if (hyperlink != null && !PageFlowUtils.isAbsoluteURI((String)hyperlink)) {
            hyperlink = PageflowTagUtils.prepareActionUrl((PageContext)this.pageContext, (String)hyperlink);
        }
        out.print("    <td colspan=\"");
        out.print(width - level + 1);
        out.print("\">");
        if (node.getIcon() != null) {
            if (hyperlink != null) {
                out.print("<a href=\"");
                out.print(hyperlink);
                out.print("\"");
                String target = node.getTarget();
                if (target != null) {
                    out.print(" target=\"");
                    out.print(target);
                    out.print("\"");
                }
                out.print(">");
            }
            out.print("<img src=\"");
            out.print(this.imageRoot);
            out.print("/");
            out.print(node.getIcon());
            out.print("\" border=\"0\">");
            if (hyperlink != null) {
                out.print("</a>");
            }
        }
        if (node.getLabel() != null) {
            String labelStyle = null;
            if (node.isSelected() && this.styleSelected != null) {
                labelStyle = this.styleSelected;
            } else if (!node.isSelected() && this.styleUnselected != null) {
                labelStyle = this.styleUnselected;
            }
            if (hyperlink != null) {
                out.print(" <a href=\"");
                out.print(hyperlink);
                out.print("\"");
                String target = node.getTarget();
                if (target != null) {
                    out.print(" target=\"");
                    out.print(target);
                    out.print("\"");
                }
                if (labelStyle != null) {
                    out.print(" class=\"");
                    out.print(labelStyle);
                    out.print("\"");
                }
                out.print(">");
            } else if (labelStyle != null) {
                out.print("<span class=\"");
                out.print(labelStyle);
                out.print("\">");
            }
            out.print(node.getLabel());
            if (hyperlink != null) {
                out.print("</a>");
            } else if (labelStyle != null) {
                out.print("</span>");
            }
        }
        out.println("</td>");
        out.println("  </tr>");
        if (node.isExpanded()) {
            TreeNode[] children = node.getChildren();
            int lastIndex = children.length - 1;
            int newLevel = level + 1;
            int i2 = 0;
            while (i2 < children.length) {
                this.render(out, children[i2], newLevel, width, i2 == lastIndex);
                ++i2;
            }
        }
    }

    protected String replace(String template, String placeholder, String value) {
        int index;
        if (template == null) {
            return null;
        }
        if (placeholder == null || value == null) {
            return template;
        }
        while ((index = template.indexOf(placeholder)) >= 0) {
            UnsyncStringBuffer temp = new UnsyncStringBuffer(template.substring(0, index));
            temp.append(value);
            temp.append(template.substring(index + placeholder.length()));
            template = temp.toString();
        }
        return template;
    }
}

