/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBase;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.apache.xml.dtm.ref.IncrementalSAXSource_Filter;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTMdefaultNamespaceDeclarationNode;
import org.apache.xml.dtm.ref.sax2dtm.SAX2DTM;
import org.apache.xml.dtm.ref.sax2dtm.SAX2RTFDTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SuballocatedIntVector;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DTMManagerDefault
extends DTMManager {
    private static final boolean DUMPTREE = false;
    private static final boolean DEBUG = false;
    protected DTM[] m_dtms = new DTM[256];
    int[] m_dtm_offsets = new int[256];
    private ExpandedNameTable m_expandedNameTable = new ExpandedNameTable();

    public synchronized void addDTM(DTM dtm, int id) {
        this.addDTM(dtm, id, 0);
    }

    public synchronized void addDTM(DTM dtm, int id, int offset) {
        if (id >= 65536) {
            throw new DTMException(XSLMessages.createMessage("ER_NO_DTMIDS_AVAIL", null));
        }
        int oldlen = this.m_dtms.length;
        if (oldlen <= id) {
            int newlen = Math.min(id + 256, 65536);
            DTM[] new_m_dtms = new DTM[newlen];
            System.arraycopy(this.m_dtms, 0, new_m_dtms, 0, oldlen);
            this.m_dtms = new_m_dtms;
            int[] new_m_dtm_offsets = new int[newlen];
            System.arraycopy(this.m_dtm_offsets, 0, new_m_dtm_offsets, 0, oldlen);
            this.m_dtm_offsets = new_m_dtm_offsets;
        }
        this.m_dtms[id] = dtm;
        this.m_dtm_offsets[id] = offset;
        dtm.documentRegistration();
    }

    public synchronized int getFirstFreeDTMID() {
        int n = this.m_dtms.length;
        int i = 1;
        while (i < n) {
            if (null == this.m_dtms[i]) {
                return i;
            }
            ++i;
        }
        return n;
    }

    public synchronized DTM getDTM(Source source, boolean unique, DTMWSFilter whiteSpaceFilter, boolean incremental, boolean doIndexing) {
        boolean isStreamSource;
        XMLStringFactory xstringFactory = this.m_xsf;
        int dtmPos = this.getFirstFreeDTMID();
        int documentID = dtmPos << 16;
        if (null != source && source instanceof DOMSource) {
            DOM2DTM dtm = new DOM2DTM((DTMManager)this, (DOMSource)source, documentID, whiteSpaceFilter, xstringFactory, doIndexing);
            this.addDTM(dtm, dtmPos, 0);
            return dtm;
        }
        boolean isSAXSource = null != source ? source instanceof SAXSource : true;
        boolean bl = isStreamSource = null != source ? source instanceof StreamSource : false;
        if (isSAXSource || isStreamSource) {
            boolean haveXercesParser;
            XMLReader reader;
            InputSource xmlSource;
            if (null == source) {
                xmlSource = null;
                reader = null;
            } else {
                reader = this.getXMLReader(source);
                xmlSource = SAXSource.sourceToInputSource(source);
                String urlOfSource = xmlSource.getSystemId();
                if (null != urlOfSource) {
                    try {
                        urlOfSource = SystemIDResolver.getAbsoluteURI(urlOfSource);
                    }
                    catch (Exception e) {
                        System.err.println("Can not absolutize URL: " + urlOfSource);
                    }
                    xmlSource.setSystemId(urlOfSource);
                }
            }
            SAX2DTM dtm = source == null && unique && !incremental && !doIndexing ? new SAX2RTFDTM(this, source, documentID, whiteSpaceFilter, xstringFactory, doIndexing) : new SAX2DTM(this, source, documentID, whiteSpaceFilter, xstringFactory, doIndexing);
            this.addDTM(dtm, dtmPos, 0);
            boolean bl2 = haveXercesParser = null != reader && reader.getClass().getName().equals("org.apache.xerces.parsers.SAXParser");
            if (haveXercesParser) {
                incremental = true;
            }
            if (DTMManager.m_incremental && incremental) {
                IncrementalSAXSource coParser = null;
                if (haveXercesParser) {
                    try {
                        coParser = (IncrementalSAXSource)Class.forName("org.apache.xml.dtm.ref.IncrementalSAXSource_Xerces").newInstance();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        coParser = null;
                    }
                }
                if (coParser == null) {
                    if (null == reader) {
                        coParser = new IncrementalSAXSource_Filter();
                    } else {
                        IncrementalSAXSource_Filter filter = new IncrementalSAXSource_Filter();
                        filter.setXMLReader(reader);
                        coParser = filter;
                    }
                }
                dtm.setIncrementalSAXSource(coParser);
                if (null == xmlSource) {
                    return dtm;
                }
                if (null == reader.getErrorHandler()) {
                    reader.setErrorHandler(dtm);
                }
                reader.setDTDHandler(dtm);
                try {
                    coParser.startParse(xmlSource);
                }
                catch (RuntimeException re) {
                    dtm.clearCoRoutine();
                    throw re;
                }
                catch (Exception e) {
                    dtm.clearCoRoutine();
                    throw new WrappedRuntimeException(e);
                }
            }
            if (null == reader) {
                return dtm;
            }
            reader.setContentHandler(dtm);
            reader.setDTDHandler(dtm);
            if (null == reader.getErrorHandler()) {
                reader.setErrorHandler(dtm);
            }
            try {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", dtm);
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
                // empty catch block
            }
            try {
                reader.parse(xmlSource);
            }
            catch (RuntimeException re) {
                dtm.clearCoRoutine();
                throw re;
            }
            catch (Exception e) {
                dtm.clearCoRoutine();
                throw new WrappedRuntimeException(e);
            }
            return dtm;
        }
        throw new DTMException(XSLMessages.createMessage("ER_NOT_SUPPORTED", new Object[]{source}));
    }

    public synchronized int getDTMHandleFromNode(Node node) {
        int handle;
        if (null == node) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_NODE_NON_NULL", null));
        }
        if (node instanceof DTMNodeProxy) {
            return ((DTMNodeProxy)node).getDTMNodeNumber();
        }
        int max = this.m_dtms.length;
        int i = 0;
        while (i < max) {
            int handle2;
            DTM thisDTM = this.m_dtms[i];
            if (null != thisDTM && thisDTM instanceof DOM2DTM && (handle2 = ((DOM2DTM)thisDTM).getHandleOfNode(node)) != -1) {
                return handle2;
            }
            ++i;
        }
        Node root = node;
        Node p = root.getNodeType() == 2 ? ((Attr)root).getOwnerElement() : root.getParentNode();
        while (p != null) {
            root = p;
            p = p.getParentNode();
        }
        DOM2DTM dtm = (DOM2DTM)this.getDTM(new DOMSource(root), false, null, true, true);
        if (node instanceof DOM2DTMdefaultNamespaceDeclarationNode) {
            handle = dtm.getHandleOfNode(((Attr)node).getOwnerElement());
            handle = dtm.getAttributeNode(handle, node.getNamespaceURI(), node.getLocalName());
        } else {
            handle = dtm.getHandleOfNode(node);
        }
        if (-1 == handle) {
            throw new RuntimeException(XSLMessages.createMessage("ER_COULD_NOT_RESOLVE_NODE", null));
        }
        return handle;
    }

    public synchronized XMLReader getXMLReader(Source inputSource) {
        try {
            boolean isUserReader;
            XMLReader reader = inputSource instanceof SAXSource ? ((SAXSource)inputSource).getXMLReader() : null;
            boolean bl = isUserReader = reader != null;
            if (null == reader) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    SAXParser jaxpParser = factory.newSAXParser();
                    reader = jaxpParser.getXMLReader();
                }
                catch (ParserConfigurationException ex) {
                    throw new SAXException(ex);
                }
                catch (FactoryConfigurationError ex1) {
                    throw new SAXException(ex1.toString());
                }
                catch (NoSuchMethodError ex2) {
                }
                catch (AbstractMethodError ame) {
                    // empty catch block
                }
                if (null == reader) {
                    reader = XMLReaderFactory.createXMLReader();
                }
            }
            try {
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException se) {
                // empty catch block
            }
            return reader;
        }
        catch (SAXException se) {
            throw new DTMException(se.getMessage(), se);
        }
    }

    public synchronized DTM getDTM(int nodeHandle) {
        try {
            return this.m_dtms[nodeHandle >>> 16];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (nodeHandle == -1) {
                return null;
            }
            throw e;
        }
    }

    public synchronized int getDTMIdentity(DTM dtm) {
        if (dtm instanceof DTMDefaultBase) {
            DTMDefaultBase dtmdb = (DTMDefaultBase)dtm;
            if (dtmdb.getManager() == this) {
                return dtmdb.getDTMIDs().elementAt(0);
            }
            return -1;
        }
        int n = this.m_dtms.length;
        int i = 0;
        while (i < n) {
            DTM tdtm = this.m_dtms[i];
            if (tdtm == dtm && this.m_dtm_offsets[i] == 0) {
                return i << 16;
            }
            ++i;
        }
        return -1;
    }

    public synchronized boolean release(DTM dtm, boolean shouldHardDelete) {
        if (dtm instanceof SAX2DTM) {
            ((SAX2DTM)dtm).clearCoRoutine();
        }
        if (dtm instanceof DTMDefaultBase) {
            SuballocatedIntVector ids = ((DTMDefaultBase)dtm).getDTMIDs();
            int i = ids.size() - 1;
            while (i >= 0) {
                this.m_dtms[ids.elementAt((int)i) >>> 16] = null;
                --i;
            }
        } else {
            int i = this.getDTMIdentity(dtm);
            if (i >= 0) {
                this.m_dtms[i >>> 16] = null;
            }
        }
        dtm.documentRelease();
        return true;
    }

    public synchronized DTM createDocumentFragment() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            DocumentFragment df = doc.createDocumentFragment();
            return this.getDTM(new DOMSource(df), true, null, false, false);
        }
        catch (Exception e) {
            throw new DTMException(e);
        }
    }

    public synchronized DTMIterator createDTMIterator(int whatToShow, DTMFilter filter, boolean entityReferenceExpansion) {
        return null;
    }

    public synchronized DTMIterator createDTMIterator(String xpathString, PrefixResolver presolver) {
        return null;
    }

    public synchronized DTMIterator createDTMIterator(int node) {
        return null;
    }

    public synchronized DTMIterator createDTMIterator(Object xpathCompiler, int pos) {
        return null;
    }

    public ExpandedNameTable getExpandedNameTable(DTM dtm) {
        return this.m_expandedNameTable;
    }
}

