/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class HtmlExceptionFormatter {
    private static final String HTML_LINE_BREAK = "<br/>";
    private static final String LINE_BREAK = "\n";
    private static final String CAUSED_BY = "caused by: ";

    public static String format(String message, Throwable t, boolean stackTrace) {
        StringBuffer buf = new StringBuffer();
        if (message != null) {
            buf.append(message);
            buf.append(HTML_LINE_BREAK);
        }
        if (t.getCause() != null) {
            buf.append(CAUSED_BY);
            buf.append(": ");
            buf.append(t.getCause().toString());
        }
        buf.append(HTML_LINE_BREAK);
        if (stackTrace) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.flush();
            pw.close();
            buf.append(sw.toString());
        }
        return buf.toString().replaceAll(LINE_BREAK, HTML_LINE_BREAK);
    }
}

