/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.util.cache;

import com.bea.wlw.netui.util.logging.Logger;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PropertyCache {
    private static final Logger logger = Logger.getInstance(class$com$bea$wlw$netui$util$cache$PropertyCache == null ? (class$com$bea$wlw$netui$util$cache$PropertyCache = PropertyCache.class$("com.bea.wlw.netui.util.cache.PropertyCache")) : class$com$bea$wlw$netui$util$cache$PropertyCache);
    private final Map cachedClass = new HashMap();
    static /* synthetic */ Class class$com$bea$wlw$netui$util$cache$PropertyCache;

    public final PropertyDescriptor[] getPropertyDescriptors(Class type) {
        CachedClass cc = this.getCachedClass(type);
        return cc != null ? cc.getPropertyDescriptors() : null;
    }

    public final Method getPropertyGetter(Class type, String property) {
        CachedClass cc = this.getCachedClass(type);
        if (cc == null) {
            return null;
        }
        CachedProperty cp = cc.getProperty(property);
        return cp != null ? cp.getReadMethod() : null;
    }

    public final Method getPropertySetter(Class type, String property) {
        CachedClass cc = this.getCachedClass(type);
        if (cc == null) {
            return null;
        }
        CachedProperty cp = cc.getProperty(property);
        return cp != null ? cp.getWriteMethod() : null;
    }

    public final Class getPropertyType(Class type, String property) {
        CachedClass cc = this.getCachedClass(type);
        if (cc == null) {
            return null;
        }
        CachedProperty cp = cc.getProperty(property);
        return cp != null ? cp.getType() : null;
    }

    public final Field getField(Class type, String field) {
        CachedClass cc = this.getCachedClass(type);
        return cc != null ? cc.getField(field) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CachedClass getCachedClass(Class type) {
        Object obj = this.cachedClass.get(type);
        if (obj != null) {
            return (CachedClass)obj;
        }
        if (obj == null) {
            Map map = this.cachedClass;
            synchronized (map) {
                if (this.cachedClass.get(type) == null) {
                    try {
                        obj = new CachedClass(type);
                        this.cachedClass.put(type, obj);
                    }
                    catch (Exception e) {
                        if (logger.isErrorEnabled()) {
                            logger.error("Error introspecting a class of type \"" + type + "\" when determining its JavaBean property info", e);
                        }
                        return null;
                    }
                }
            }
        }
        return (CachedClass)obj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CachedField {
        private Field field = null;
        private String name = null;

        CachedField(Field field) {
            this.name = field.getName();
            this.field = field;
        }

        Field getField() {
            return this.field;
        }

        String getName() {
            return this.name;
        }
    }

    private class CachedProperty {
        private Method readMethod = null;
        private Method writeMethod = null;
        private String name = null;
        private PropertyDescriptor pd = null;
        private Class type = null;

        CachedProperty(PropertyDescriptor pd) {
            this.pd = pd;
            this.name = pd.getName();
            this.readMethod = pd.getReadMethod();
            this.writeMethod = pd.getWriteMethod();
            this.type = pd.getPropertyType();
        }

        PropertyDescriptor getPropertyDescriptor() {
            return this.pd;
        }

        Method getReadMethod() {
            return this.readMethod;
        }

        Method getWriteMethod() {
            return this.writeMethod;
        }

        String getName() {
            return this.name;
        }

        Class getType() {
            return this.type;
        }
    }

    private class CachedClass {
        private Class type = null;
        private Map props = null;
        private Map fields = null;
        private PropertyDescriptor[] pds = null;

        CachedClass(Class type) throws IntrospectionException {
            this.type = type;
            this.init(type);
        }

        private void init(Class type) throws IntrospectionException {
            this.props = new HashMap();
            if (Modifier.isPublic(type.getModifiers())) {
                PropertyDescriptor[] pds = Introspector.getBeanInfo(type).getPropertyDescriptors();
                int i = 0;
                while (i < pds.length) {
                    this.props.put(pds[i].getName(), new CachedProperty(pds[i]));
                    ++i;
                }
                this.fields = new HashMap();
                Field[] fs = type.getFields();
                int i2 = 0;
                while (i2 < fs.length) {
                    if (Modifier.isPublic(fs[i2].getModifiers()) && !Modifier.isStatic(fs[i2].getModifiers())) {
                        this.fields.put(fs[i2].getName(), new CachedField(fs[i2]));
                    }
                    ++i2;
                }
            } else {
                Class c = type;
                while (c != null) {
                    Class<?>[] interfaces = c.getInterfaces();
                    int i = 0;
                    while (i < interfaces.length) {
                        Class<?> iface = interfaces[i];
                        if (Modifier.isPublic(iface.getModifiers())) {
                            PropertyDescriptor[] pds = Introspector.getBeanInfo(iface).getPropertyDescriptors();
                            int j = 0;
                            while (j < pds.length) {
                                if (!this.props.containsKey(pds[j].getName())) {
                                    this.props.put(pds[j].getName(), new CachedProperty(pds[j]));
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    c = c.getSuperclass();
                }
                Class baseClass = type.getSuperclass();
                while (!Modifier.isPublic(baseClass.getModifiers())) {
                    baseClass = baseClass.getSuperclass();
                }
                PropertyDescriptor[] pds = Introspector.getBeanInfo(baseClass).getPropertyDescriptors();
                int j = 0;
                while (j < pds.length) {
                    if (!this.props.containsKey(pds[j].getName())) {
                        this.props.put(pds[j].getName(), new CachedProperty(pds[j]));
                    }
                    ++j;
                }
                this.fields = new HashMap();
                Field[] fs = baseClass.getFields();
                int i = 0;
                while (i < fs.length) {
                    if (Modifier.isPublic(fs[i].getModifiers()) && !Modifier.isStatic(fs[i].getModifiers())) {
                        this.fields.put(fs[i].getName(), new CachedField(fs[i]));
                    }
                    ++i;
                }
            }
            if (this.props.size() > 0) {
                this.pds = new PropertyDescriptor[this.props.size()];
                Iterator iterator = this.props.values().iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    this.pds[i] = ((CachedProperty)iterator.next()).getPropertyDescriptor();
                    ++i;
                }
            }
        }

        PropertyDescriptor[] getPropertyDescriptors() {
            return this.pds;
        }

        Field getField(String name) {
            CachedField cf = (CachedField)this.fields.get(name);
            return cf != null ? cf.getField() : null;
        }

        CachedProperty getProperty(String name) {
            return (CachedProperty)this.props.get(name);
        }
    }
}

