/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.util.debug;

import com.bea.wlw.netui.util.debug.DebugUtil;

final class Location {
    private static final boolean debug = false;
    String pkg = "<unknown>";
    String clazz = "<unknown>";
    String method = "<unknown>";
    String linenum = "<unknown>";
    String fullClass = "<unknown>";
    String sourcefile = "<unknown>";
    private static final boolean VERBOSE_CLASS_NAMES = DebugUtil.getPropertyAsBoolean("tagFullClassNames", false);
    private static final boolean VERBOSE_METHODS = DebugUtil.getPropertyAsBoolean("tagMethodNames", true);
    private static final boolean SHOW_LINE_NUMBERS = DebugUtil.getPropertyAsBoolean("tagLineNumbers", true);

    Location(String line) {
        int begin = line.indexOf("at ") + 3;
        int end = line.indexOf("(");
        if (begin == -1 || end == -1) {
            return;
        }
        String fullName = line.substring(begin, end);
        if ((end = fullName.lastIndexOf(".")) == -1) {
            return;
        }
        this.fullClass = fullName.substring(0, end);
        this.method = fullName.substring(end + 1);
        end = this.fullClass.lastIndexOf(".");
        if (end == -1) {
            this.pkg = "<default>";
            this.clazz = this.fullClass;
        } else {
            this.pkg = this.fullClass.substring(0, end);
            this.clazz = this.fullClass.substring(end + 1);
        }
        begin = line.indexOf("(") + 1;
        end = line.indexOf(":");
        if (begin == -1 || end == -1) {
            return;
        }
        this.sourcefile = line.substring(begin, end);
        begin = end + 1;
        end = line.lastIndexOf(")");
        this.linenum = end != -1 ? line.substring(begin, end) : line.substring(begin);
    }

    public String tag() {
        StringBuffer sb = new StringBuffer("[");
        if (VERBOSE_CLASS_NAMES) {
            sb.append(this.fullClass);
        } else {
            sb.append(this.clazz);
        }
        if (VERBOSE_METHODS) {
            sb.append(".").append(this.method).append("()");
        }
        if (SHOW_LINE_NUMBERS) {
            sb.append(":").append(this.linenum);
        }
        sb.append("] ");
        return sb.toString();
    }

    public String here() {
        return this.fullname().append("() @ ").append(this.sourcefile).append(":").append(this.linenum).toString();
    }

    private StringBuffer fullname() {
        StringBuffer sb = new StringBuffer();
        if (this.fullClass.length() > 0) {
            sb.append(this.fullClass).append(".");
        }
        sb.append(this.method);
        return sb;
    }
}

