/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.util.iterator;

import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.iterator.ArrayIterator;
import com.bea.wlw.netui.util.iterator.AtomicObjectIterator;
import com.bea.wlw.netui.util.iterator.EmptyIterator;
import com.bea.wlw.netui.util.iterator.EnumerationIterator;
import com.bea.wlw.netui.util.iterator.IteratorFactoryException;
import com.bea.wlw.netui.util.iterator.MapIterator;
import com.bea.wlw.netui.util.logging.Logger;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class IteratorFactory {
    private static final Debug debug = Debug.getInstance(class$com$bea$wlw$netui$util$iterator$IteratorFactory == null ? (class$com$bea$wlw$netui$util$iterator$IteratorFactory = IteratorFactory.class$("com.bea.wlw.netui.util.iterator.IteratorFactory")) : class$com$bea$wlw$netui$util$iterator$IteratorFactory);
    private static final Logger logger = Logger.getInstance(class$com$bea$wlw$netui$util$iterator$IteratorFactory == null ? (class$com$bea$wlw$netui$util$iterator$IteratorFactory = IteratorFactory.class$("com.bea.wlw.netui.util.iterator.IteratorFactory")) : class$com$bea$wlw$netui$util$iterator$IteratorFactory);
    private static final String ITERATOR_PROPERTIES = "com/bea/wlw/netui/util/iterator/IteratorFactory.properties";
    private static final Map plantMap = new LinkedHashMap();
    public static final Iterator EMPTY_ITERATOR;
    static /* synthetic */ Class class$com$bea$wlw$netui$util$iterator$IteratorFactory;

    public static Iterator makeIterator(Object object) throws IteratorFactoryException {
        if (IteratorFactory.debug.ON) {
            debug.out("Trying to make an iterator for class: " + (object == null ? "null" : object.getClass().getName()));
        }
        if (object == null) {
            return null;
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return collection.iterator();
        }
        if (object instanceof Map) {
            return new MapIterator((Map)object);
        }
        if (object.getClass().isArray()) {
            return new ArrayIterator(object);
        }
        if (object instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)object);
        }
        Iterator ret = null;
        Iterator factories = plantMap.keySet().iterator();
        while (factories.hasNext()) {
            IteratorPlant plant = (IteratorPlant)plantMap.get(factories.next());
            ret = plant.createIterator(object);
            if (ret == null) continue;
            return ret;
        }
        return new AtomicObjectIterator(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static final void initialize() {
        Properties props;
        block19: {
            props = null;
            InputStream is = null;
            is = (class$com$bea$wlw$netui$util$iterator$IteratorFactory == null ? (class$com$bea$wlw$netui$util$iterator$IteratorFactory = IteratorFactory.class$("com.bea.wlw.netui.util.iterator.IteratorFactory")) : class$com$bea$wlw$netui$util$iterator$IteratorFactory).getClassLoader().getResourceAsStream(ITERATOR_PROPERTIES);
            if (is == null) {
                String msg = "Did not find properties file \"com/bea/wlw/netui/util/iterator/IteratorFactory.properties\"; the expression evaluator configuration is invalid.";
                logger.error(msg);
                throw new RuntimeException(msg);
            }
            props = new Properties();
            props.load(is);
            Object var4_5 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block19;
            }
            catch (Exception ignore) {}
            break block19;
            {
                catch (Exception e) {
                    logger.error("Error occurred reading the script properties file", e);
                    var4_5 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block19;
                    }
                    catch (Exception ignore) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (props == null) {
            return;
        }
        IteratorPlant plant = null;
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String className = props.getProperty(name);
            try {
                Class<?> type = Class.forName(className);
                plant = (IteratorPlant)type.newInstance();
            }
            catch (ClassNotFoundException cnf) {
                logger.warn("Could not create an IteratorPlant for type \"" + className + "\" because the implementation class could not be found.");
                continue;
            }
            catch (Exception e) {
                logger.warn("Could not create an IteratorPlant for type \"" + className + "\" because an error occurred creating the plant.  Cause: " + e, e);
                continue;
            }
            if (plantMap.containsKey(name)) {
                logger.warn("Overwriting a previously defined IteratorPlant named \"" + name + "\" with a new IteratorPlant of type \"" + className + "\"");
            } else {
                logger.info("Adding an IteratorPlant named \"" + name + "\" with implementation \"" + className + "\"");
            }
            plantMap.put(name, plant);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IteratorFactory.initialize();
        EMPTY_ITERATOR = new EmptyIterator();
    }

    static abstract class IteratorPlant {
        IteratorPlant() {
        }

        abstract Iterator createIterator(Object var1);
    }
}

