/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.util.type;

import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import com.bea.wlw.netui.util.type.TypeConversionException;
import com.bea.wlw.netui.util.type.TypeConverter;
import com.bea.wlw.netui.util.type.TypeConverterNotFoundException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class TypeUtils {
    private static final Debug debug = Debug.getInstance(class$com$bea$wlw$netui$util$type$TypeUtils == null ? (class$com$bea$wlw$netui$util$type$TypeUtils = TypeUtils.class$("com.bea.wlw.netui.util.type.TypeUtils")) : class$com$bea$wlw$netui$util$type$TypeUtils);
    private static final Logger logger = Logger.getInstance(class$com$bea$wlw$netui$util$type$TypeUtils == null ? (class$com$bea$wlw$netui$util$type$TypeUtils = TypeUtils.class$("com.bea.wlw.netui.util.type.TypeUtils")) : class$com$bea$wlw$netui$util$type$TypeUtils);
    private static final String TYPE_CONVERTER_PROPERTIES = "/properties/netui-typeconverter.properties";
    private static final Map converters = new HashMap();
    private static final String EMPTY_STRING = "";
    private static String toString = null;
    static /* synthetic */ Class class$com$bea$wlw$netui$util$type$TypeUtils;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;

    private TypeUtils() {
    }

    public static final Object convertToObject(String value, Class type) {
        TypeConverter converter = (TypeConverter)converters.get(type);
        if (converter == null) {
            String msg = "Could not find a TypeConverter for converting a String to an object of type \"" + (type != null ? type.getName() : null) + "\"";
            TypeConverterNotFoundException tcn = new TypeConverterNotFoundException(msg);
            msg = type == null ? Bundle.getErrorString("TypeUtils_nullType") : Bundle.getErrorString("TypeUtils_noConverterForType", new Object[]{type.getName()});
            tcn.setLocalizedMessage(msg);
            if (logger.isInfoEnabled()) {
                logger.info(msg);
            }
            throw tcn;
        }
        return converter.convertToObject(value);
    }

    private static String registeredConvertersToString() {
        if (toString != null) {
            return toString;
        }
        StringBuffer buf = new StringBuffer();
        buf.append((class$com$bea$wlw$netui$util$type$TypeUtils == null ? (class$com$bea$wlw$netui$util$type$TypeUtils = TypeUtils.class$("com.bea.wlw.netui.util.type.TypeUtils")) : class$com$bea$wlw$netui$util$type$TypeUtils).getName() + " regestered converters (class name, TypeConverter implementation):\n");
        buf.append(":::::\n");
        Iterator iterator = converters.keySet().iterator();
        while (iterator.hasNext()) {
            Class key = (Class)iterator.next();
            String keyName = key.getName();
            String value = converters.get(key) != null ? converters.get(key).getClass().getName() : "null";
            buf.append(keyName);
            buf.append(", ");
            buf.append(value);
            buf.append("\n");
        }
        buf.append(":::::\n");
        toString = buf.toString();
        return toString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readProperties() {
        block27: {
            block26: {
                block25: {
                    props = null;
                    is = null;
                    try {
                        try {
                            is = (TypeUtils.class$com$bea$wlw$netui$util$type$TypeUtils == null ? (TypeUtils.class$com$bea$wlw$netui$util$type$TypeUtils = TypeUtils.class$("com.bea.wlw.netui.util.type.TypeUtils")) : TypeUtils.class$com$bea$wlw$netui$util$type$TypeUtils).getClassLoader().getResourceAsStream("/properties/netui-typeconverter.properties");
                            if (TypeUtils.debug.ON) {
                                TypeUtils.debug.out("InputStream: " + is);
                            }
                            if (is == null) {
                                var4_2 = null;
                                break block25;
                            }
                            props = new Properties();
                            props.load(is);
                            break block26;
                        }
                        catch (Exception e) {
                            if (TypeUtils.logger.isWarnEnabled()) {
                                TypeUtils.logger.warn("Error occurred reading type converter properties file", e);
                            }
                            var4_3 = null;
                            try {
                                if (is != null) {
                                    is.close();
                                }
                                break block27;
                            }
                            catch (Exception ignore) {}
                            break block27;
                        }
                    }
                    catch (Throwable var3_10) {
                        var4_4 = null;
                        ** try [egrp 2[TRYBLOCK] [6 : 128->139)] { 
lbl31:
                        // 1 sources

                        if (is == null) throw var3_10;
                        is.close();
                        throw var3_10;
lbl34:
                        // 1 sources

                        catch (Exception ignore) {
                            // empty catch block
                        }
                        throw var3_10;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [6 : 128->139)] { 
lbl39:
                // 1 sources

                if (is == null) return;
                is.close();
                return;
lbl42:
                // 1 sources

                catch (Exception ignore) {
                    // empty catch block
                }
                return;
            }
            var4_3 = null;
            try {}
            catch (Exception ignore) {}
            if (is != null) {
                is.close();
            }
        }
        if (props == null) {
            return;
        }
        iterator = props.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return;
            }
            key = (String)iterator.next();
            className = (String)props.get(key);
            if (key == null || key.equals("") || className == null || className.equals("")) {
                msg = "Could not create a TypeConverter for type \"" + key + "\" and TypeConverter \"" + className + "\"";
                if (!TypeUtils.logger.isWarnEnabled()) continue;
                TypeUtils.logger.warn(msg);
                continue;
            }
            targetClazz = null;
            tcClazz = null;
            tc = null;
            try {
                targetClazz = Class.forName(key);
            }
            catch (ClassNotFoundException cnf) {
                msg = "Could not create a TypeConverter for type \"" + key + "\" because the target type could not be found.";
                if (!TypeUtils.logger.isWarnEnabled()) continue;
                TypeUtils.logger.warn(msg);
                continue;
            }
            try {
                tcClazz = Class.forName(className);
                tc = (TypeConverter)tcClazz.newInstance();
            }
            catch (ClassNotFoundException cnf) {
                if (!TypeUtils.logger.isWarnEnabled()) continue;
                TypeUtils.logger.warn("Could not create a TypeConverter for type \"" + key + "\" because the TypeConverter implementation class \"" + (tcClazz != null ? tcClazz.getName() : null) + "\" could not be found.");
                continue;
            }
            catch (Exception e) {
                if (!TypeUtils.logger.isWarnEnabled()) continue;
                TypeUtils.logger.warn("Could not create a TypeConverter for type \"" + key + "\" because the implementation class \"" + (tcClazz != null ? tcClazz.getName() : null) + "\" could not be instantiated.");
                continue;
            }
            if (TypeUtils.converters.containsKey(targetClazz) && TypeUtils.logger.isWarnEnabled()) {
                TypeUtils.logger.warn("Overwriting a previously defined TypeConverter named \"" + targetClazz + "\" with a new TypeConverter implementation of type \"" + className + "\"");
            }
            if (TypeUtils.logger.isInfoEnabled()) {
                TypeUtils.logger.info("Adding a type converter; target type=\"" + targetClazz.getName() + "\" TypeConverter implementation=\"" + tc.getClass().getName() + "\"");
            }
            TypeUtils.converters.put(targetClazz, tc);
        }
    }

    private static void initialize() {
        converters.put(Byte.TYPE, new TypeConverter(){

            public Object convertToObject(String value) {
                return value == null || value.equals(TypeUtils.EMPTY_STRING) ? new Byte(0) : new Byte(value.trim());
            }
        });
        converters.put(class$java$lang$Byte == null ? (class$java$lang$Byte = TypeUtils.class$("java.lang.Byte")) : class$java$lang$Byte, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Byte.TYPE);
            }
        });
        converters.put(Boolean.TYPE, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return Boolean.FALSE;
                }
                if ((value = value.toLowerCase().trim()).equals("on") || value.equals("true")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        converters.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Boolean.TYPE);
            }
        });
        converters.put(Character.TYPE, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return new Character('\u0000');
                }
                return new Character(value.charAt(0));
            }
        });
        converters.put(class$java$lang$Character == null ? (class$java$lang$Character = TypeUtils.class$("java.lang.Character")) : class$java$lang$Character, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Character.TYPE);
            }
        });
        converters.put(Double.TYPE, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return new Double(0.0);
                }
                return new Double(value.trim());
            }
        });
        converters.put(class$java$lang$Double == null ? (class$java$lang$Double = TypeUtils.class$("java.lang.Double")) : class$java$lang$Double, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Double.TYPE);
            }
        });
        converters.put(Float.TYPE, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return new Float(0.0);
                }
                return new Float(value.trim());
            }
        });
        converters.put(class$java$lang$Float == null ? (class$java$lang$Float = TypeUtils.class$("java.lang.Float")) : class$java$lang$Float, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Float.TYPE);
            }
        });
        converters.put(Integer.TYPE, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return new Integer(0);
                }
                return new Integer(value.trim());
            }
        });
        converters.put(class$java$lang$Integer == null ? (class$java$lang$Integer = TypeUtils.class$("java.lang.Integer")) : class$java$lang$Integer, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Integer.TYPE);
            }
        });
        converters.put(Long.TYPE, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return new Long(0L);
                }
                return new Long(value.trim());
            }
        });
        converters.put(class$java$lang$Long == null ? (class$java$lang$Long = TypeUtils.class$("java.lang.Long")) : class$java$lang$Long, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Long.TYPE);
            }
        });
        converters.put(Short.TYPE, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return new Short(0);
                }
                return new Short(value.trim());
            }
        });
        converters.put(class$java$lang$Short == null ? (class$java$lang$Short = TypeUtils.class$("java.lang.Short")) : class$java$lang$Short, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Short.TYPE);
            }
        });
        converters.put(class$java$lang$String == null ? (class$java$lang$String = TypeUtils.class$("java.lang.String")) : class$java$lang$String, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null) {
                    return null;
                }
                return value;
            }
        });
        converters.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return new BigDecimal(value.trim());
            }
        });
        converters.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = TypeUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return new BigInteger(value.trim());
            }
        });
        converters.put(array$B == null ? (array$B = TypeUtils.class$("[B")) : array$B, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return value.getBytes();
            }
        });
        converters.put(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = TypeUtils.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                TypeConverter primByte = (TypeConverter)converters.get(Byte.TYPE);
                byte[] bytes = value.getBytes();
                Byte[] wBytes = new Byte[bytes.length];
                int i = 0;
                while (i < bytes.length) {
                    wBytes[i] = new Byte(bytes[i]);
                    ++i;
                }
                return wBytes;
            }
        });
        converters.put(class$java$util$Date == null ? (class$java$util$Date = TypeUtils.class$("java.util.Date")) : class$java$util$Date, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                try {
                    DateFormat df = DateFormat.getDateInstance(3);
                    return df.parse(value);
                }
                catch (ParseException pe) {
                    String msg = "Caugnt an error converting a String to a DateFormat.SHORT formatted Date";
                    if (logger.isWarnEnabled()) {
                        logger.warn(msg, pe);
                    }
                    System.err.println(msg);
                    TypeConversionException tce = new TypeConversionException(msg, pe);
                    tce.setLocalizedMessage(Bundle.getString("TypeUtils_javaUtilDateConvertError", new Object[]{pe.getMessage()}));
                    throw tce;
                }
            }
        });
        converters.put(class$java$sql$Date == null ? (class$java$sql$Date = TypeUtils.class$("java.sql.Date")) : class$java$sql$Date, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                try {
                    return Date.valueOf(value);
                }
                catch (Exception e) {
                    String msg = "Caught an error converting a String to a java.sql.Date";
                    if (logger.isWarnEnabled()) {
                        logger.warn(msg, e);
                    }
                    System.err.println(msg);
                    TypeConversionException tce = new TypeConversionException(msg, e);
                    tce.setLocalizedMessage(Bundle.getString("TypeUtils_javaSqlDateConvertError", new Object[]{e.getMessage()}));
                    throw tce;
                }
            }
        });
        converters.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = TypeUtils.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                try {
                    return Timestamp.valueOf(value);
                }
                catch (Exception e) {
                    String msg = "Caught an error converting a String to a java.sql.Timestamp";
                    if (logger.isWarnEnabled()) {
                        logger.warn(msg, e);
                    }
                    System.err.println(msg);
                    TypeConversionException tce = new TypeConversionException(msg, e);
                    tce.setLocalizedMessage(Bundle.getString("TypeUtils_javaSqlTimestampConvertError", new Object[]{e.getMessage()}));
                    throw tce;
                }
            }
        });
        converters.put(class$java$sql$Time == null ? (class$java$sql$Time = TypeUtils.class$("java.sql.Time")) : class$java$sql$Time, new TypeConverter(){

            public Object convertToObject(String value) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                try {
                    return Time.valueOf(value);
                }
                catch (Exception e) {
                    String msg = "Caught an error converting a String to a java.sql.Time";
                    if (logger.isWarnEnabled()) {
                        logger.warn(msg, e);
                    }
                    System.err.println(msg);
                    TypeConversionException tce = new TypeConversionException(msg, e);
                    tce.setLocalizedMessage(Bundle.getString("TypeUtils_javaSqlTimeConvertError", new Object[]{e.getMessage()}));
                    throw tce;
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TypeUtils.initialize();
        TypeUtils.readProperties();
        if (logger.isInfoEnabled()) {
            logger.info(TypeUtils.registeredConvertersToString());
        }
    }
}

