/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.databinding.form;

import com.bea.wlw.netui.databinding.form.RowSetFormException;
import com.bea.wlw.netui.pageflow.FormData;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.cache.PropertyCache;
import com.bea.wlw.netui.util.exception.LocalizedIllegalStateException;
import com.bea.wlw.netui.util.logging.Logger;
import com.bea.wlw.netui.util.type.TypeUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import weblogic.jdbc.rowset.RowSetClob;
import weblogic.jdbc.rowset.WLCachedRowSet;

public abstract class RowSetForm
extends FormData {
    private static final Logger logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$databinding$form$RowSetForm == null ? (class$com$bea$wlw$netui$databinding$form$RowSetForm = RowSetForm.class$("com.bea.wlw.netui.databinding.form.RowSetForm")) : class$com$bea$wlw$netui$databinding$form$RowSetForm));
    private static final int GETTER = 1;
    private static final int SETTER = 2;
    private static final PropertyCache cache = new PropertyCache();
    private List properties = null;
    private List changes = null;
    private PropertyDescriptor[] pds = null;
    static /* synthetic */ Class class$com$bea$wlw$netui$databinding$form$RowSetForm;

    protected Object writeForm(String columnName, Object rowSetValue) {
        return rowSetValue;
    }

    protected Object writeRowSet(String columnName, Object formValue, Object oldRowSetValue) {
        return formValue;
    }

    public void applyInsertValuesToRowSet(RowSet rowSet) throws RowSetFormException {
        if (this.changes == null || rowSet == null) {
            return;
        }
        if (!(rowSet instanceof WLCachedRowSet)) {
            RowSetFormException rsf = new RowSetFormException("The RowSetForm can not handle a RowSet of type \"" + rowSet.getClass().getName() + "\"; the RowSet must be an instance of weblogic.jdbc.rowset.WLCachedRowSet");
            rsf.setLocalizedMessage(Bundle.getErrorString((String)"RowSetForm_invalidRowSetType", (Object[])new Object[]{rowSet.getClass().getName()}));
            throw rsf;
        }
        try {
            Iterator iterator = this.changes.iterator();
            String name = null;
            while (iterator.hasNext()) {
                name = (String)iterator.next();
                Object value = this.convertToRowSetObject(rowSet, name, this.getPropertyValue(name));
                value = this.writeRowSet(name, value, rowSet.getObject(name));
                rowSet.updateObject(name, value);
            }
            rowSet.insertRow();
            rowSet.moveToCurrentRow();
        }
        catch (Exception e) {
            if (e instanceof RowSetFormException) {
                throw (RowSetFormException)e;
            }
            String msg = "An exception occurred inserting values into a RowSet from a RowSetForm of type \"" + ((Object)((Object)this)).getClass().getName() + "\".";
            if (logger.isWarnEnabled()) {
                logger.warn((Object)msg, (Throwable)e);
            }
            RowSetFormException rsf = new RowSetFormException(msg, e);
            rsf.setLocalizedMessage(Bundle.getErrorString((String)"RowSetForm_insertError", (Object[])new Object[]{e}));
            throw rsf;
        }
    }

    public void applyUpdateValuesToRowSet(RowSet rowSet) throws RowSetFormException {
        block9: {
            if (rowSet == null) {
                return;
            }
            if (!(rowSet instanceof WLCachedRowSet)) {
                RowSetFormException rsf = new RowSetFormException("The RowSetForm can not handle a RowSet of type \"" + rowSet.getClass().getName() + "\"; the RowSet must be an instance of weblogic.jdbc.rowset.WLCachedRowSet");
                rsf.setLocalizedMessage(Bundle.getErrorString((String)"RowSetForm_invalidRowSetType", (Object[])new Object[]{rowSet.getClass().getName()}));
                throw rsf;
            }
            try {
                if (rowSet.absolute(1) && this.changes != null) {
                    String name = null;
                    Iterator iterator = this.changes.iterator();
                    while (iterator.hasNext()) {
                        name = (String)iterator.next();
                        Object value = this.convertToRowSetObject(rowSet, name, this.getPropertyValue(name));
                        value = this.writeRowSet(name, value, rowSet.getObject(name));
                        rowSet.updateObject(name, value);
                    }
                    rowSet.updateRow();
                    break block9;
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"There is no next RowSet row against which to apply any changes.");
                }
                return;
            }
            catch (Exception e) {
                if (e instanceof RowSetFormException) {
                    throw (RowSetFormException)e;
                }
                String msg = "An exception occurred updating the values of a RowSet from a RowSetForm of type \"" + ((Object)((Object)this)).getClass().getName() + "\".";
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)msg, (Throwable)e);
                }
                RowSetFormException rsf = new RowSetFormException(msg, e);
                rsf.setLocalizedMessage(Bundle.getErrorString((String)"RowSetForm_updateError", (Object[])new Object[]{e}));
                throw rsf;
            }
        }
    }

    private Object convertToRowSetObject(RowSet rowSet, String name, Object value) throws SQLException, RowSetFormException {
        if (value == null) {
            return null;
        }
        ResultSetMetaData rsmd = rowSet.getMetaData();
        int colCount = rsmd.getColumnCount();
        int colPos = 1;
        boolean found = false;
        while (colPos <= colCount) {
            if (rsmd.getColumnName(colPos).equalsIgnoreCase(name)) {
                found = true;
                break;
            }
            ++colPos;
        }
        if (!found) {
            throw new RowSetFormException("Could not update column \"" + name + "\" the column name was not found in the meta data");
        }
        if (rsmd.getColumnType(colPos) == 2005) {
            Object rsValue = rowSet.getObject(name);
            if (rsValue instanceof Clob || rsValue == null) {
                Clob c = null;
                c = c == null ? new RowSetClob() : (Clob)rsValue;
                c.truncate(0L);
                c.setString(0L, value != null ? value.toString() : null);
                return c;
            }
            if (rsValue instanceof String) {
                return value.toString();
            }
            throw new RowSetFormException("Found a JDBC column named \"" + name + "\" whose JDBC type is a CLOB but whose value is an object of type \"" + value.getClass().getName());
        }
        return value;
    }

    public void applyValuesToForm(RowSet rowSet) throws RowSetFormException {
        if (rowSet == null) {
            return;
        }
        if (!(rowSet instanceof WLCachedRowSet)) {
            RowSetFormException rsf = new RowSetFormException("The RowSetForm can not handle a RowSet of type \"" + rowSet.getClass().getName() + "\"; the RowSet must be an instance of weblogic.jdbc.rowset.WLCachedRowSet");
            rsf.setLocalizedMessage(Bundle.getErrorString((String)"RowSetForm_invalidRowSetType", (Object[])new Object[]{rowSet.getClass().getName()}));
            throw rsf;
        }
        if (((WLCachedRowSet)rowSet).size() == 0) {
            return;
        }
        try {
            Map row = ((WLCachedRowSet)rowSet).getRows()[0];
            ResultSetMetaData rsmd = rowSet.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int i = 1;
            while (i <= columnCount) {
                String columnName = rsmd.getColumnName(i);
                Object obj = null;
                if (rsmd.getColumnType(i) == 2005) {
                    obj = row.get(columnName);
                    if (obj instanceof Clob && obj != null) {
                        Clob c = (Clob)obj;
                        obj = c.getSubString(0L, (int)c.length());
                    } else if (obj != null) {
                        throw new RowSetFormException("Found a JDBC column named \"" + columnName + "\" whose JDBC type is a CLOB but whose value is an object of type \"" + obj.getClass().getName());
                    }
                } else {
                    obj = row.get(columnName);
                }
                obj = this.writeForm(columnName, obj);
                this.setPropertyValue(columnName, obj);
                ++i;
            }
        }
        catch (Exception e) {
            if (e instanceof RowSetFormException) {
                throw (RowSetFormException)e;
            }
            String msg = "An exception occurred initializing values in a RowSetForm of type \"" + ((Object)((Object)this)).getClass().getName() + "\" from a RowSet.";
            if (logger.isWarnEnabled()) {
                logger.warn((Object)msg, (Throwable)e);
            }
            RowSetFormException rsf = new RowSetFormException(msg, e);
            rsf.setLocalizedMessage(Bundle.getErrorString((String)"RowSetForm_initializeError", (Object[])new Object[]{((Object)((Object)this)).getClass().getName()}));
            throw rsf;
        }
    }

    public void clearChangedValues() {
        this.changes = null;
    }

    protected final void registerChange(String propertyName) {
        if (this.changes == null) {
            this.changes = new ArrayList();
        }
        this.changes.add(propertyName);
    }

    private final Method findMethod(String name, int type) {
        PropertyDescriptor pd = this.findProperty(name);
        if (pd == null) {
            LocalizedIllegalStateException ise = new LocalizedIllegalStateException("Could not find property named \"" + name + "\"");
            ise.setLocalizedMessage(Bundle.getErrorString((String)"RowSetForm_couldNotFindProperty", (Object[])new Object[]{name}));
            throw ise;
        }
        if (type == 1) {
            return pd.getReadMethod();
        }
        return pd.getWriteMethod();
    }

    private final PropertyDescriptor findProperty(String name) {
        if (this.pds == null) {
            this.pds = cache.getPropertyDescriptors(((Object)((Object)this)).getClass());
        }
        if (this.pds != null) {
            int i = 0;
            while (i < this.pds.length) {
                if (this.pds[i].getName().equalsIgnoreCase(name)) {
                    return this.pds[i];
                }
                ++i;
            }
        }
        return null;
    }

    private Object getPropertyValue(String name) throws Exception {
        Method m;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get property \"" + name + "\""));
        }
        if ((m = this.findMethod(name, 1)) == null) {
            throw new LocalizedIllegalStateException("Could not get value for property \"" + name + "\".  Could not find JavaBean property getter.");
        }
        return m.invoke((Object)this, null);
    }

    private void setPropertyValue(String name, Object value) throws Exception {
        Method m;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("property name: " + name + " type: " + (value != null ? value.getClass().getName() : "null")));
        }
        if ((m = this.findMethod(name, 2)) == null) {
            String msg = "Could not set property \"" + name + "\" on RowSetForm of type \"" + ((Object)((Object)this)).getClass().getName() + "\"; could not find setter.";
            if (logger.isWarnEnabled()) {
                logger.warn((Object)msg);
            }
            return;
        }
        try {
            if (value == null && m.getParameterTypes()[0].isPrimitive()) {
                Object objValue = TypeUtils.convertToObject(null, m.getParameterTypes()[0]);
                m.invoke((Object)this, objValue);
            } else {
                m.invoke((Object)this, value);
            }
        }
        catch (IllegalArgumentException iae) {
            String msg = "Error invoking the method \"" + m.getName() + "\" on an object of type \"" + ((Object)((Object)this)).getClass().getName() + "\"." + "The setter takes a parameter of type \"" + m.getParameterTypes()[0].getName() + "\" and the actual argument is " + (value != null ? "of type \"" + value.getClass().getName() : "null") + ".";
            if (logger.isWarnEnabled()) {
                logger.warn((Object)msg, (Throwable)iae);
            }
            RowSetFormException rsf = new RowSetFormException(msg, iae);
            if (value == null) {
                rsf.setLocalizedMessage(Bundle.getErrorString((String)"RowSetForm_setPropertyError_nullValue", (Object[])new Object[]{m.getName(), ((Object)((Object)this)).getClass().getName(), m.getParameterTypes()[0].getName()}));
            } else {
                rsf.setLocalizedMessage(Bundle.getErrorString((String)"RowSetForm_setPropertyError", (Object[])new Object[]{m.getName(), ((Object)((Object)this)).getClass().getName(), m.getParameterTypes()[0].getName(), value.getClass().getName()}));
            }
            throw rsf;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

