/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.databinding.script.xscript;

import com.bea.wlw.netui.script.IllegalExpressionException;
import com.bea.wlw.netui.script.xscript.ContextResolver;
import com.bea.wlw.netui.script.xscript.IllegalContextStateException;
import com.bea.wlw.netui.script.xscript.context.AbstractReadOnlyScriptable;
import com.bea.wlw.netui.tags.databinding.bundle.BundleContext;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import knex.scripting.javascript.Scriptable;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;
import weblogic.utils.UnsyncStringBuffer;

public class BundleContextResolver
extends ContextResolver {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$databinding$script$xscript$BundleContextResolver == null ? (class$com$bea$wlw$netui$databinding$script$xscript$BundleContextResolver = BundleContextResolver.class$("com.bea.wlw.netui.databinding.script.xscript.BundleContextResolver")) : class$com$bea$wlw$netui$databinding$script$xscript$BundleContextResolver));
    private static final Logger logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$databinding$script$xscript$BundleContextResolver == null ? (class$com$bea$wlw$netui$databinding$script$xscript$BundleContextResolver = BundleContextResolver.class$("com.bea.wlw.netui.databinding.script.xscript.BundleContextResolver")) : class$com$bea$wlw$netui$databinding$script$xscript$BundleContextResolver));
    static /* synthetic */ Class class$com$bea$wlw$netui$databinding$script$xscript$BundleContextResolver;
    static /* synthetic */ Class class$java$util$ResourceBundle;
    static /* synthetic */ Class class$java$lang$String;

    public String getContextName() {
        return "bundle";
    }

    public boolean isWritable() {
        return false;
    }

    public void resolve(Scriptable scope, String expression, Map contexts) {
        PageContext pc = (PageContext)contexts.get("pageContext");
        if (pc == null) {
            IllegalContextStateException ics = new IllegalContextStateException("The PageContext could not be found; can not create the bundle binding context for the expression \"" + expression + "\".");
            ics.setLocalizedMessage(Bundle.getErrorString((String)"XScript_BundleContextResolver_noPageContext", (Object[])new Object[]{expression}));
            logger.info((Object)ics.getMessage());
            throw ics;
        }
        BundleContext bc = null;
        Object obj = pc.getAttribute("_netui_pageContext_bundleContext");
        if (obj != null && obj instanceof BundleContext) {
            bc = (BundleContext)obj;
        } else if (obj != null) {
            IllegalContextStateException ics = new IllegalContextStateException("The PageContext contains an attribute under the BundleContext key of the wrong type \"" + obj.getClass().getName() + "\".");
            ics.setLocalizedMessage(Bundle.getErrorString((String)"XScript_BundleContextResolver_wrongContextType", (Object[])new Object[]{obj.getClass().getName()}));
            logger.warn((Object)ics.getMessage());
            throw ics;
        }
        scope.put("bundle", scope, (Object)new ScriptableBundleContext(scope, pc, bc));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ScriptableBundle
    extends AbstractReadOnlyScriptable {
        private BundleContext.BundleNode bundle = null;
        private String propertiesName = null;

        ScriptableBundle(Scriptable parent, String propertiesName, BundleContext.BundleNode bundle) {
            super(parent);
            this.bundle = bundle;
            this.propertiesName = propertiesName;
        }

        public Class getPropertyType(String property) {
            return class$java$lang$String == null ? (class$java$lang$String = BundleContextResolver.class$("java.lang.String")) : class$java$lang$String;
        }

        public String getClassName() {
            return "ScriptableBundle";
        }

        public boolean has(String name, Scriptable start) {
            return this.bundle.getString(name) != null;
        }

        public Object[] getIds() {
            Enumeration enumeration = this.bundle.getKeys();
            ArrayList list = new ArrayList();
            while (enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
            return list.toArray();
        }

        public final Object get(String name, Scriptable start) {
            String result = this.bundle.getString(name);
            if (result == null) {
                IllegalExpressionException iee = new IllegalExpressionException("The bundle property name \"" + name + "\" could not be found in the properties bundle \"" + this.propertiesName + "\".");
                iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_BundleContextResolver_noSuchMessage", (Object[])new Object[]{name, this.propertiesName}));
                throw iee;
            }
            return result;
        }
    }

    public static class ScriptableBundleContext
    extends AbstractReadOnlyScriptable {
        private BundleContext bundleContext = null;
        private PageContext pageContext = null;

        public ScriptableBundleContext(Scriptable parent, PageContext pageContext, BundleContext bundleContext) {
            super(parent);
            this.bundleContext = bundleContext;
            this.pageContext = pageContext;
        }

        public Class getPropertyType(String property) {
            return class$java$util$ResourceBundle == null ? (class$java$util$ResourceBundle = BundleContextResolver.class$("java.util.ResourceBundle")) : class$java$util$ResourceBundle;
        }

        public String getClassName() {
            return "ScriptableBundleContext";
        }

        public boolean has(String name, Scriptable start) {
            if (this.bundleContext == null) {
                return false;
            }
            return this.bundleContext.containsBundle(name);
        }

        public Object[] getIds() {
            MessageResourcesConfig[] configs;
            ModuleConfig config;
            ArrayList list = new ArrayList();
            if (this.bundleContext != null) {
                Iterator iterator = this.bundleContext.getBundleNames();
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
            }
            if ((config = (ModuleConfig)this.pageContext.getRequest().getAttribute("org.apache.struts.action.MODULE")) != null && (configs = config.findMessageResourcesConfigs()) != null) {
                int i = 0;
                while (i < configs.length) {
                    list.add(configs[i].getKey() + config.getPrefix());
                    ++i;
                }
            }
            return list.toArray();
        }

        public final Object get(String name, Scriptable start) {
            MessageResourcesConfig[] mrs;
            MessageResources resources;
            if (this.bundleContext != null && this.bundleContext.containsBundle(name)) {
                try {
                    return new ScriptableBundle(this.getParentScope(), name, this.bundleContext.getBundle(name));
                }
                catch (Exception e) {
                    IllegalContextStateException ics = new IllegalContextStateException("Unable to load bundle named \"" + name + "\"; cause: " + e.getMessage(), (Throwable)e);
                    ics.setLocalizedMessage(Bundle.getErrorString((String)"XScript_BundleContextResolver_cantLoadProperties", (Object[])new Object[]{name}));
                    logger.warn((Object)ics.getMessage());
                    throw ics;
                }
            }
            if (name.equals("default")) {
                resources = (MessageResources)this.pageContext.getAttribute("org.apache.struts.action.MESSAGE", 2);
                if (resources != null) {
                    BundleContext.BundleNode bundleNode = BundleContext.createBundleNode(name, resources, RequestUtils.retrieveUserLocale((PageContext)this.pageContext, null));
                    return new ScriptableBundle(this.getParentScope(), name, bundleNode);
                }
            } else if (this.pageContext.getAttribute(name, 4) != null && (resources = (MessageResources)this.pageContext.getAttribute(name, 4)) != null) {
                BundleContext.BundleNode bundleNode = BundleContext.createBundleNode(name, resources, RequestUtils.retrieveUserLocale((PageContext)this.pageContext, null));
                return new ScriptableBundle(this.getParentScope(), name, bundleNode);
            }
            UnsyncStringBuffer nameList = new UnsyncStringBuffer(32);
            nameList.append("[");
            if (this.bundleContext != null) {
                Iterator iterator = this.bundleContext.getBundleNames();
                int i = 0;
                while (iterator.hasNext()) {
                    if (i > 0) {
                        nameList.append(", ");
                    }
                    nameList.append(iterator.next().toString());
                    ++i;
                }
            }
            nameList.append("]");
            UnsyncStringBuffer strutsNameList = new UnsyncStringBuffer(32);
            strutsNameList.append("[");
            ModuleConfig config = (ModuleConfig)this.pageContext.getRequest().getAttribute("org.apache.struts.action.MODULE");
            if (config != null && (mrs = config.findMessageResourcesConfigs()) != null) {
                int i = 0;
                while (i < mrs.length) {
                    if (i > 0) {
                        strutsNameList.append(", ");
                    }
                    if (mrs[i].getKey().equals("org.apache.struts.action.MESSAGE")) {
                        strutsNameList.append("default");
                    } else {
                        strutsNameList.append(mrs[i].getKey() + config.getPrefix());
                    }
                    ++i;
                }
            }
            strutsNameList.append("]");
            IllegalExpressionException iee = new IllegalExpressionException("The bundle named \"" + name + "\" was not found in the list of registered bundles with names " + nameList.toString() + " or implicit bundle names " + strutsNameList.toString() + ".");
            iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_BundleContextResolver_bundleNotFound", (Object[])new Object[]{name, nameList.toString(), strutsNameList.toString()}));
            throw iee;
        }
    }
}

