/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.databinding.grid.column;

import com.bea.wlw.netui.pageflow.scoping.ScopedRequest;
import com.bea.wlw.netui.pageflow.scoping.ScopedServletUtils;
import com.bea.wlw.netui.pageflow.util.PageflowTagUtils;
import com.bea.wlw.netui.pageflow.util.URLRewriter;
import com.bea.wlw.netui.pageflow.util.URLRewriterService;
import com.bea.wlw.netui.tags.databinding.SortFilterService;
import com.bea.wlw.netui.tags.databinding.grid.GridContext;
import com.bea.wlw.netui.tags.databinding.grid.column.FormattableColumn;
import com.bea.wlw.netui.tags.databinding.grid.datacontext.DataContext;
import com.bea.wlw.netui.tags.databinding.grid.datacontext.EmptyDataContext;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import weblogic.utils.UnsyncStringBuffer;

public abstract class SortFilterColumn
extends FormattableColumn {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$tags$databinding$grid$column$SortFilterColumn == null ? (class$com$bea$wlw$netui$tags$databinding$grid$column$SortFilterColumn = SortFilterColumn.class$("com.bea.wlw.netui.tags.databinding.grid.column.SortFilterColumn")) : class$com$bea$wlw$netui$tags$databinding$grid$column$SortFilterColumn));
    private static final Logger logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$tags$databinding$grid$column$SortFilterColumn == null ? (class$com$bea$wlw$netui$tags$databinding$grid$column$SortFilterColumn = SortFilterColumn.class$("com.bea.wlw.netui.tags.databinding.grid.column.SortFilterColumn")) : class$com$bea$wlw$netui$tags$databinding$grid$column$SortFilterColumn));
    private static final String L10N_FILTER_WINDOW_PROPERTIES = "/com/bea/wlw/netui/databinding/grid/filter/filter-window.properties";
    private static final String defaultFilterPageUri = Bundle.getString((String)"filter.page.default.uri");
    private static final Properties l10nProps = SortFilterColumn.readL10NFilterInfo();
    private String sortAction = null;
    private String filterAction = null;
    private Boolean sortable = null;
    private Boolean filterable = null;
    private String name = null;
    private String title = null;
    private String titleText = null;
    static /* synthetic */ Class class$com$bea$wlw$netui$tags$databinding$grid$column$SortFilterColumn;

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setFilterable(boolean filterable) {
        this.filterable = filterable ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isFilterable() {
        return this.filterable != null ? this.filterable : false;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isSortable() {
        return this.sortable != null ? this.sortable : false;
    }

    public void setSortAction(String sortAction) {
        this.sortAction = sortAction;
    }

    public String getSortAction() {
        return this.sortAction;
    }

    public void setFilterAction(String filterAction) {
        this.filterAction = filterAction;
    }

    public String getFilterAction() {
        return this.filterAction;
    }

    protected void localRelease() {
        super.localRelease();
        this.sortAction = null;
        this.filterAction = null;
        this.sortable = null;
        this.filterable = null;
        this.name = null;
        this.title = null;
        this.titleText = null;
    }

    public String renderHeaderCell() throws JspException {
        DataContext dc = this.getGridContext().getDataContext();
        UnsyncStringBuffer buf = new UnsyncStringBuffer(256);
        if (dc instanceof EmptyDataContext) {
            buf.append(this.renderHeaderCellTag());
            buf.append(this.titleText);
            buf.append(this.renderCloseCellTag());
            return buf.toString();
        }
        buf.append(this.renderHeaderCellTag());
        int jdbcType = dc.getColumnType(this.getName());
        if (this.canSort() && SortFilterColumn.checkValidSortType(jdbcType)) {
            String sortMarkup = this.renderSortMarkup(this.getGridContext().getName(), this.getName(), this.titleText, jdbcType);
            buf.append(sortMarkup);
        } else {
            buf.append(this.titleText);
        }
        if (this.canFilter()) {
            String filterMarkup = this.renderFilterMarkup(this.getGridContext(), this.getName(), this.titleText, jdbcType);
            buf.append(filterMarkup);
        }
        buf.append(this.renderCloseCellTag());
        return buf.toString();
    }

    public boolean canFilter() {
        if (this.filterable == null) {
            return this.getColumns().isFilterable();
        }
        return this.filterable;
    }

    public boolean canSort() {
        if (this.sortable == null) {
            return this.getColumns().isSortable();
        }
        return this.sortable;
    }

    public String computeFilterAction() {
        if (!this.canFilter()) {
            return null;
        }
        if (this.filterAction != null) {
            return this.filterAction;
        }
        return this.getColumns().getFilterAction();
    }

    public String computeSortAction() {
        if (!this.canSort()) {
            return null;
        }
        if (this.sortAction != null) {
            return this.sortAction;
        }
        return this.getColumns().getSortAction();
    }

    protected void verifyAttributes() throws JspException {
        String msg;
        if (this.canFilter() && this.computeFilterAction() == null) {
            msg = Bundle.getErrorString((String)"Tags_SortFilterColumn_requiresFilterAction");
            if ((msg = this.registerTagError(msg)) != null) {
                throw new JspException(msg);
            }
        }
        if (this.canSort() && this.computeSortAction() == null) {
            msg = Bundle.getErrorString((String)"Tags_SortFilterColumn_requiresSortAction");
            if ((msg = this.registerTagError(msg)) != null) {
                throw new JspException(msg);
            }
        }
    }

    protected String getTitleText() {
        return this.titleText;
    }

    protected final String calculateURL(String destination, Map queryParams) throws JspException {
        String url;
        block3: {
            url = null;
            try {
                url = PageflowTagUtils.computeURL((PageContext)this.pageContext, null, (String)destination, null, null, (Map)queryParams, null, (boolean)true);
                String type = URLRewriter.ACTION_UNSECURE;
                if (URLRewriterService.needsSecure((ServletRequest)this.pageContext.getRequest(), (ServletContext)this.pageContext.getServletContext(), (String)url, (boolean)true)) {
                    type = URLRewriter.ACTION_SECURE;
                }
                url = URLRewriterService.rewriteURL((ServletContext)this.pageContext.getServletContext(), (ServletRequest)this.pageContext.getRequest(), (ServletResponse)this.pageContext.getResponse(), (String)url, (String)type);
            }
            catch (MalformedURLException e) {
                String msg = Bundle.getErrorString((String)"Tags_SortFilterColumn_malformedURL", (Object[])new Object[]{e.getMessage()});
                msg = this.registerTagError(msg);
                if (msg == null) break block3;
                throw new JspException(msg);
            }
        }
        return url;
    }

    protected final String renderFilterMarkup(GridContext gridContext, String realColumnName, String readableColumnName, int columnType) throws JspException {
        int qmark;
        if (!SortFilterColumn.checkValidFilterType(columnType)) {
            return "";
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        SortFilterService svc = SortFilterService.getInstance(request);
        String encoding = this.pageContext.getResponse().getCharacterEncoding();
        String filterSupportRoot = request.getContextPath() + SortFilterColumn.lookupString("grid.support.uri");
        String filterURL = filterSupportRoot + this.getFilterWindowURI(encoding);
        String filterImage = null;
        filterImage = svc.isFiltered(gridContext.getName(), realColumnName) ? SortFilterColumn.lookupString("filtered.img.uri") : SortFilterColumn.lookupString("unfiltered.img.uri");
        filterImage = this.createImagePath(request, filterImage);
        String dest = null;
        if (this.computeFilterAction() != null) {
            dest = PageflowTagUtils.createActionURL((PageContext)this.pageContext, (String)this.computeFilterAction());
        }
        String url = this.calculateURL(dest, SortFilterService.getInstance(request).getQueryParamsMapWithPage(this.getGridContext().getName(), 0));
        if (SortFilterColumn.debug.ON) {
            debug.out("filter URL: " + url);
        }
        String currentURL = "";
        if (url != null && url.length() > 0 && (qmark = url.indexOf("?")) > -1 && !url.endsWith("?")) {
            dest = url.substring(0, qmark);
            currentURL = url.substring(qmark);
        }
        if (SortFilterColumn.debug.ON) {
            debug.out("dest: " + dest);
            debug.out("currentURL: " + currentURL);
        }
        String prefix = "";
        ScopedRequest sr = ScopedServletUtils.unwrapRequest((ServletRequest)this.pageContext.getRequest());
        if (sr != null) {
            prefix = sr.getScopeKey().toString();
        }
        String encodedRealColumnName = null;
        String gridName = null;
        String jdbcTypeString = null;
        try {
            encodedRealColumnName = URLEncoder.encode(realColumnName.toUpperCase(), encoding);
            gridName = URLEncoder.encode(gridContext.getName(), encoding);
            jdbcTypeString = URLEncoder.encode("" + columnType, encoding);
            dest = URLEncoder.encode(dest, encoding);
            prefix = URLEncoder.encode(prefix, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            logger.warn((Object)"Error encoding query parameters", (Throwable)uee);
        }
        String str = SortFilterColumn.lookupString("filter.anchor", new Object[]{readableColumnName, encodedRealColumnName, currentURL != null ? currentURL : "?", gridName, filterURL, jdbcTypeString, dest, prefix, filterImage});
        if (SortFilterColumn.debug.ON) {
            debug.out("filterMarkup: " + str);
        }
        return str;
    }

    protected final String renderSortMarkup(String gridName, String columnName, String columnTitle, int columnType) throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        SortFilterService svc = SortFilterService.getInstance(request);
        String gridSupportRoot = request.getContextPath() + SortFilterColumn.lookupString("grid.support.uri");
        boolean isSorted = svc.isSorted(gridName, columnName);
        String dest = null;
        if (this.computeSortAction() != null) {
            dest = PageflowTagUtils.createActionURL((PageContext)this.pageContext, (String)this.computeSortAction());
        }
        String url = this.calculateURL(dest, svc.getQueryParamsMapWithSort(gridName, columnName));
        if (SortFilterColumn.debug.ON) {
            debug.out("sort URL: " + url);
        }
        String html = null;
        if (isSorted) {
            String imageName = null;
            int direction = svc.getSortDirection(gridName, columnName);
            if (direction == 1) {
                imageName = SortFilterColumn.lookupString("sorted.asc.img");
            } else if (direction == 2) {
                imageName = SortFilterColumn.lookupString("sorted.desc.img");
            }
            imageName = this.createImagePath(request, imageName);
            html = SortFilterColumn.lookupString("sorted.anchor", new Object[]{url, columnTitle, imageName});
        } else {
            html = SortFilterColumn.lookupString("unsorted.anchor", new Object[]{url, columnTitle});
        }
        if (SortFilterColumn.debug.ON) {
            debug.out("sortMarkup: " + html);
        }
        return html;
    }

    protected void prepare() {
        super.prepare();
        Object val = this.evaluateExpression(this.getTitle(), "title");
        if (this.hasErrors()) {
            this.titleText = "";
        }
        this.titleText = val != null ? val.toString() : "";
    }

    private final String createImagePath(HttpServletRequest request, String imageName) {
        String imagePath = request.getContextPath();
        String imageRoot = this.getGridContext().getImageRoot();
        if (!imageRoot.startsWith("\\") && !imageRoot.startsWith("/")) {
            imageRoot = "/" + imageRoot;
        }
        return imagePath + imageRoot + imageName;
    }

    private static final boolean checkValidSortType(int type) {
        if (type == -2 || type == -3 || type == -4 || type == 2004 || type == 2003 || type == 2001 || type == 2002 || type == 2006 || type == 2000 || type == 2005) {
            logger.warn((Object)("Attempt to sort an unsortable column of type \"" + type + "\""));
            String msg = Bundle.getErrorString((String)"Tags_SortFilterColumn_unsortableColumnType", (Object[])new Object[]{new Integer(type)});
            System.err.println(msg);
            return false;
        }
        return true;
    }

    private static final boolean checkValidFilterType(int type) {
        if (type == -2 || type == -3 || type == -4 || type == 2004 || type == 2003 || type == 2001 || type == 2002 || type == 2006 || type == 2000 || type == 2005) {
            logger.warn((Object)("Attempt to filter an unfilterable column of type \"" + type + "\""));
            String msg = Bundle.getErrorString((String)"Tags_SortFilterColumn_unfilterableColumnType", (Object[])new Object[]{new Integer(type)});
            System.err.println(msg);
            return false;
        }
        return true;
    }

    private static final String lookupString(String key, Object[] args) {
        if (args == null) {
            return Bundle.getString((String)key);
        }
        return Bundle.getString((String)key, (Object[])args);
    }

    private static final String lookupString(String key) {
        return SortFilterColumn.lookupString(key, null);
    }

    private String getFilterWindowURI(String encoding) {
        if (SortFilterColumn.debug.ON) {
            debug.out("create filter URI -- encoding: " + encoding + " l10nProps size: " + (l10nProps != null ? "" + l10nProps.keySet().size() : "null"));
        }
        if (l10nProps != null) {
            if (SortFilterColumn.debug.ON) {
                debug.out("encoding value: " + l10nProps.get(encoding));
            }
            String uri = defaultFilterPageUri;
            String filterName = encoding.toLowerCase() + "-" + defaultFilterPageUri;
            if (l10nProps.get(filterName) != null) {
                uri = (String)l10nProps.get(filterName);
            }
            if (SortFilterColumn.debug.ON) {
                debug.out("chosen filter window URI: " + uri);
            }
            return uri;
        }
        return defaultFilterPageUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static final Properties readL10NFilterInfo() {
        Properties props;
        block16: {
            InputStream is;
            block14: {
                props = null;
                is = null;
                is = (class$com$bea$wlw$netui$tags$databinding$grid$column$SortFilterColumn == null ? (class$com$bea$wlw$netui$tags$databinding$grid$column$SortFilterColumn = SortFilterColumn.class$("com.bea.wlw.netui.tags.databinding.grid.column.SortFilterColumn")) : class$com$bea$wlw$netui$tags$databinding$grid$column$SortFilterColumn).getClassLoader().getResourceAsStream(L10N_FILTER_WINDOW_PROPERTIES);
                if (is != null) break block14;
                Properties properties = null;
                Object var4_4 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                return properties;
            }
            props = new Properties();
            props.load(is);
            Object var4_5 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block16;
            }
            catch (Exception ignore) {}
            break block16;
            {
                catch (Exception e) {
                    logger.warn((Object)"Error occurred reading filter window l10n file \"/com/bea/wlw/netui/databinding/grid/filter/filter-window.properties\"", (Throwable)e);
                    Object var4_6 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block16;
                    }
                    catch (Exception ignore) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

