/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.parsers.DOMBuilderImpl;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.XMLChar;
import org.apache.xml.serialize.DOMWriterImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMBuilder;
import org.w3c.dom.ls.DOMWriter;

public class CoreDOMImplementationImpl
implements DOMImplementation {
    private static final int SIZE = 2;
    private RevalidationHandler[] validators = new RevalidationHandler[2];
    private int freeValidatorIndex = -1;
    private int currentSize = 2;
    static CoreDOMImplementationImpl singleton = new CoreDOMImplementationImpl();

    public static DOMImplementation getDOMImplementation() {
        return singleton;
    }

    public boolean hasFeature(String feature, String version) {
        boolean anyVersion = version == null || version.length() == 0;
        return feature.equalsIgnoreCase("Core") && (anyVersion || version.equals("1.0") || version.equals("2.0")) || feature.equalsIgnoreCase("XML") && (anyVersion || version.equals("1.0") || version.equals("2.0")) || feature.equalsIgnoreCase("LS-Load") && (anyVersion || version.equals("3.0"));
    }

    public DocumentType createDocumentType(String qualifiedName, String publicID, String systemID) {
        this.checkQName(qualifiedName);
        return new DocumentTypeImpl(null, qualifiedName, publicID, systemID);
    }

    final void checkQName(String qname) {
        int i;
        int index = qname.indexOf(58);
        int lastIndex = qname.lastIndexOf(58);
        int length = qname.length();
        if (index == 0 || index == length - 1 || lastIndex != index) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
            throw new DOMException(14, msg);
        }
        int start = 0;
        if (index > 0) {
            if (!XMLChar.isNCNameStart(qname.charAt(start))) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, msg);
            }
            i = 1;
            while (i < index) {
                if (!XMLChar.isNCName(qname.charAt(i))) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                    throw new DOMException(5, msg);
                }
                ++i;
            }
            start = index + 1;
        }
        if (!XMLChar.isNCNameStart(qname.charAt(start))) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        i = start + 1;
        while (i < length) {
            if (!XMLChar.isNCName(qname.charAt(i))) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, msg);
            }
            ++i;
        }
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        if (doctype != null && doctype.getOwnerDocument() != null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        CoreDocumentImpl doc = new CoreDocumentImpl(doctype);
        Element e = doc.createElementNS(namespaceURI, qualifiedName);
        doc.appendChild(e);
        return doc;
    }

    public DOMImplementation getInterface(String feature) {
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
        throw new DOMException(9, msg);
    }

    public DOMBuilder createDOMBuilder(short mode, String schemaType) throws DOMException {
        if (mode == 2) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, msg);
        }
        if (schemaType != null && schemaType.equals("http://www.w3.org/TR/REC-xml")) {
            return new DOMBuilderImpl("org.apache.xerces.parsers.DTDConfiguration", schemaType);
        }
        return new DOMBuilderImpl("org.apache.xerces.parsers.StandardParserConfiguration", schemaType);
    }

    public DOMWriter createDOMWriter() {
        return new DOMWriterImpl();
    }

    synchronized RevalidationHandler getValidator(String schemaType) {
        if (this.freeValidatorIndex < 0) {
            return (RevalidationHandler)ObjectFactory.newInstance("org.apache.xerces.impl.xs.XMLSchemaValidator", ObjectFactory.findClassLoader(), true);
        }
        RevalidationHandler val = this.validators[this.freeValidatorIndex];
        this.validators[this.freeValidatorIndex--] = null;
        return val;
    }

    synchronized void releaseValidator(String schemaType, RevalidationHandler validator) {
        ++this.freeValidatorIndex;
        if (this.validators.length == this.freeValidatorIndex) {
            this.currentSize += 2;
            RevalidationHandler[] newarray = new RevalidationHandler[this.currentSize];
            System.arraycopy(this.validators, 0, newarray, 0, this.validators.length);
            this.validators = newarray;
        }
        this.validators[this.freeValidatorIndex] = validator;
    }
}

