/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.identity.IDValue;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.ValueStore;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.NamespaceContext;

public class Field {
    protected XPath fXPath;
    protected IdentityConstraint fIdentityConstraint;
    protected boolean mayMatch = true;

    public Field(XPath xpath, IdentityConstraint identityConstraint) {
        this.fXPath = xpath;
        this.fIdentityConstraint = identityConstraint;
    }

    public void setMayMatch(boolean b) {
        this.mayMatch = b;
    }

    public boolean mayMatch() {
        return this.mayMatch;
    }

    public org.apache.xerces.impl.xpath.XPath getXPath() {
        return this.fXPath;
    }

    public IdentityConstraint getIdentityConstraint() {
        return this.fIdentityConstraint;
    }

    public XPathMatcher createMatcher(ValueStore store) {
        return new Matcher(this.fXPath, store);
    }

    public String toString() {
        return this.fXPath.toString();
    }

    protected class Matcher
    extends XPathMatcher {
        protected ValueStore fStore;

        public Matcher(XPath xpath, ValueStore store) {
            super(xpath);
            this.fStore = store;
        }

        protected void matched(String content, XSSimpleType val, boolean isNil) {
            super.matched(content, val, isNil);
            if (isNil && Field.this.fIdentityConstraint.getCategory() == 1) {
                String code = "KeyMatchesNillable";
                this.fStore.reportError(code, new Object[]{Field.this.fIdentityConstraint.getElementName()});
            }
            this.fStore.addValue(Field.this, new IDValue(content, val));
            Field.this.mayMatch = false;
        }

        protected void handleContent(XSElementDecl eDecl, String value) {
            XSTypeDefinition type;
            XSSimpleType val = null;
            if (eDecl != null && (type = eDecl.fType) != null) {
                if (type.getTypeCategory() == 13) {
                    XSComplexTypeDecl ctype = (XSComplexTypeDecl)type;
                    val = (XSSimpleType)ctype.getSimpleType();
                } else {
                    val = (XSSimpleType)type;
                }
            }
            if (val == null) {
                String code = "cvc-id.3";
                String name = eDecl == null ? "null" : eDecl.getName();
                this.fStore.reportError(code, new Object[]{Field.this.fIdentityConstraint.getName(), name});
                return;
            }
            this.fMatchedString = value;
            if (eDecl != null) {
                this.matched(this.fMatchedString, val, eDecl.getNillable());
            } else {
                this.matched(this.fMatchedString, val, false);
            }
        }
    }

    public static class XPath
    extends org.apache.xerces.impl.xpath.XPath {
        public XPath(String xpath, SymbolTable symbolTable, NamespaceContext context) throws XPathException {
            super(xpath.trim().startsWith("/") || xpath.trim().startsWith(".") ? xpath : "./" + xpath, symbolTable, context);
        }
    }
}

