/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Vector;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

abstract class XSDAbstractTraverser {
    protected static final String NO_NAME = "(no name)";
    protected static final int NOT_ALL_CONTEXT = 0;
    protected static final int PROCESSING_ALL_EL = 1;
    protected static final int GROUP_REF_WITH_ALL = 2;
    protected static final int CHILD_OF_GROUP = 4;
    protected static final int PROCESSING_ALL_GP = 8;
    protected XSDHandler fSchemaHandler = null;
    protected SymbolTable fSymbolTable = null;
    protected XSAttributeChecker fAttrChecker = null;
    ValidationState fValidationState = new ValidationState();
    private static final XSSimpleType fQNameDV = (XSSimpleType)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("QName");
    private StringBuffer fPattern = new StringBuffer();
    private final XSFacets xsFacets = new XSFacets();

    XSDAbstractTraverser(XSDHandler handler, XSAttributeChecker attrChecker) {
        this.fSchemaHandler = handler;
        this.fAttrChecker = attrChecker;
    }

    void reset(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fValidationState.setExtraChecking(false);
        this.fValidationState.setSymbolTable(symbolTable);
    }

    void traverseAnnotationDecl(Element annotationDecl, Object[] parentAttrs, boolean isGlobal, XSDocumentInfo schemaDoc) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(annotationDecl, isGlobal, schemaDoc);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        Element child = DOMUtil.getFirstChildElement(annotationDecl);
        while (child != null) {
            String name = DOMUtil.getLocalName(child);
            if (!name.equals(SchemaSymbols.ELT_APPINFO) && !name.equals(SchemaSymbols.ELT_DOCUMENTATION)) {
                this.reportSchemaError("src-annotation", null, child);
            }
            attrValues = this.fAttrChecker.checkAttributes(child, true, schemaDoc);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            child = DOMUtil.getNextSiblingElement(child);
        }
    }

    FacetInfo traverseFacets(Element content, XSSimpleType baseValidator, XSDocumentInfo schemaDoc) {
        int facetsPresent = 0;
        short facetsFixed = 0;
        boolean hasQName = this.containsQName(baseValidator);
        Vector<String> enumData = new Vector<String>();
        Vector<NamespaceSupport> enumNSDecls = hasQName ? new Vector<NamespaceSupport>() : null;
        int currentFacet = 0;
        while (content != null) {
            Element child;
            Object[] attrs = null;
            String facet = DOMUtil.getLocalName(content);
            if (facet.equals(SchemaSymbols.ELT_ENUMERATION)) {
                Element child2;
                attrs = this.fAttrChecker.checkAttributes(content, false, schemaDoc, hasQName);
                String enumVal = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                NamespaceSupport nsDecls = (NamespaceSupport)attrs[XSAttributeChecker.ATTIDX_ENUMNSDECLS];
                if (baseValidator.getVariety() == 1 && baseValidator.getPrimitiveKind() == 19) {
                    schemaDoc.fValidationContext.setNamespaceSupport(nsDecls);
                    try {
                        QName temp = (QName)fQNameDV.validate(enumVal, (ValidationContext)schemaDoc.fValidationContext, null);
                        this.fSchemaHandler.getGlobalDecl(schemaDoc, 6, temp, content);
                    }
                    catch (InvalidDatatypeValueException ex) {
                        this.reportSchemaError(ex.getKey(), ex.getArgs(), content);
                    }
                    schemaDoc.fValidationContext.setNamespaceSupport(schemaDoc.fNamespaceSupport);
                }
                enumData.addElement(enumVal);
                if (hasQName) {
                    enumNSDecls.addElement(nsDecls);
                }
                if ((child2 = DOMUtil.getFirstChildElement(content)) != null) {
                    if (DOMUtil.getLocalName(child2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.traverseAnnotationDecl(child2, attrs, false, schemaDoc);
                        child2 = DOMUtil.getNextSiblingElement(child2);
                    }
                    if (child2 != null && DOMUtil.getLocalName(child2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.reportSchemaError("s4s-elt-must-match", new Object[]{"enumeration", "(annotation?)"}, child2);
                    }
                }
            } else if (facet.equals(SchemaSymbols.ELT_PATTERN)) {
                attrs = this.fAttrChecker.checkAttributes(content, false, schemaDoc);
                if (this.fPattern.length() == 0) {
                    this.fPattern.append((String)attrs[XSAttributeChecker.ATTIDX_VALUE]);
                } else {
                    this.fPattern.append("|");
                    this.fPattern.append((String)attrs[XSAttributeChecker.ATTIDX_VALUE]);
                    child = DOMUtil.getFirstChildElement(content);
                    if (child != null) {
                        if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                            this.traverseAnnotationDecl(child, attrs, false, schemaDoc);
                            child = DOMUtil.getNextSiblingElement(child);
                        }
                        if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                            Object[] args = new Object[]{"Pattern facet has more than one annotation."};
                            this.reportSchemaError("s4s-elt-must-match", new Object[]{"pattern", "(annotation?)"}, child);
                        }
                    }
                }
            } else {
                if (facet.equals(SchemaSymbols.ELT_MINLENGTH)) {
                    currentFacet = 2;
                } else if (facet.equals(SchemaSymbols.ELT_MAXLENGTH)) {
                    currentFacet = 4;
                } else if (facet.equals(SchemaSymbols.ELT_MAXEXCLUSIVE)) {
                    currentFacet = 64;
                } else if (facet.equals(SchemaSymbols.ELT_MAXINCLUSIVE)) {
                    currentFacet = 32;
                } else if (facet.equals(SchemaSymbols.ELT_MINEXCLUSIVE)) {
                    currentFacet = 128;
                } else if (facet.equals(SchemaSymbols.ELT_MININCLUSIVE)) {
                    currentFacet = 256;
                } else if (facet.equals(SchemaSymbols.ELT_TOTALDIGITS)) {
                    currentFacet = 512;
                } else if (facet.equals(SchemaSymbols.ELT_FRACTIONDIGITS)) {
                    currentFacet = 1024;
                } else if (facet.equals(SchemaSymbols.ELT_WHITESPACE)) {
                    currentFacet = 16;
                } else {
                    if (!facet.equals(SchemaSymbols.ELT_LENGTH)) break;
                    currentFacet = 1;
                }
                attrs = this.fAttrChecker.checkAttributes(content, false, schemaDoc);
                if ((facetsPresent & currentFacet) != 0) {
                    this.reportSchemaError("src-single-facet-value", new Object[]{"The facet '" + facet + "' is defined more than once."}, content);
                } else if (attrs[XSAttributeChecker.ATTIDX_VALUE] != null) {
                    facetsPresent = (short)(facetsPresent | currentFacet);
                    if (((Boolean)attrs[XSAttributeChecker.ATTIDX_FIXED]).booleanValue()) {
                        facetsFixed = (short)(facetsFixed | currentFacet);
                    }
                    switch (currentFacet) {
                        case 2: {
                            this.xsFacets.minLength = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 4: {
                            this.xsFacets.maxLength = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 64: {
                            this.xsFacets.maxExclusive = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 32: {
                            this.xsFacets.maxInclusive = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 128: {
                            this.xsFacets.minExclusive = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 256: {
                            this.xsFacets.minInclusive = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 512: {
                            this.xsFacets.totalDigits = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 1024: {
                            this.xsFacets.fractionDigits = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 16: {
                            this.xsFacets.whiteSpace = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).shortValue();
                            break;
                        }
                        case 1: {
                            this.xsFacets.length = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                        }
                    }
                }
                child = DOMUtil.getFirstChildElement(content);
                if (child != null) {
                    if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.traverseAnnotationDecl(child, attrs, false, schemaDoc);
                        child = DOMUtil.getNextSiblingElement(child);
                    }
                    if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.reportSchemaError("s4s-elt-must-match", new Object[]{facet, "(annotation?)"}, child);
                    }
                }
            }
            this.fAttrChecker.returnAttrArray(attrs, schemaDoc);
            content = DOMUtil.getNextSiblingElement(content);
        }
        if (enumData.size() > 0) {
            facetsPresent = (short)(facetsPresent | 0x800);
            this.xsFacets.enumeration = enumData;
            this.xsFacets.enumNSDecls = enumNSDecls;
        }
        if (this.fPattern.length() != 0) {
            facetsPresent = (short)(facetsPresent | 8);
            this.xsFacets.pattern = this.fPattern.toString();
        }
        this.fPattern.setLength(0);
        FacetInfo fi = new FacetInfo();
        fi.facetdata = this.xsFacets;
        fi.nodeAfterFacets = content;
        fi.fPresentFacets = (short)facetsPresent;
        fi.fFixedFacets = facetsFixed;
        return fi;
    }

    private boolean containsQName(XSSimpleType type) {
        if (type.getVariety() == 1) {
            short primitive = type.getPrimitiveKind();
            return primitive == 18 || primitive == 19;
        }
        if (type.getVariety() == 2) {
            return this.containsQName((XSSimpleType)type.getItemType());
        }
        if (type.getVariety() == 3) {
            XSObjectList members = type.getMemberTypes();
            int i = 0;
            while (i < members.getLength()) {
                if (this.containsQName((XSSimpleType)members.item(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    Element traverseAttrsAndAttrGrps(Element firstAttr, XSAttributeGroupDecl attrGrp, XSDocumentInfo schemaDoc, SchemaGrammar grammar, XSComplexTypeDecl enclosingCT) {
        String childName;
        Element child = null;
        XSAttributeGroupDecl tempAttrGrp = null;
        XSAttributeUseImpl tempAttrUse = null;
        child = firstAttr;
        while (child != null) {
            childName = DOMUtil.getLocalName(child);
            if (childName.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                tempAttrUse = this.fSchemaHandler.fAttributeTraverser.traverseLocal(child, schemaDoc, grammar, enclosingCT);
                if (tempAttrUse == null) break;
                if (attrGrp.getAttributeUse(tempAttrUse.fAttrDecl.getNamespace(), tempAttrUse.fAttrDecl.getName()) == null) {
                    String idName = attrGrp.addAttributeUse(tempAttrUse);
                    if (idName != null) {
                        String code = enclosingCT == null ? "ag-props-correct.3" : "ct-props-correct.5";
                        String name = enclosingCT == null ? attrGrp.fName : enclosingCT.getName();
                        this.reportSchemaError(code, new Object[]{name, tempAttrUse.fAttrDecl.getName(), idName}, child);
                    }
                } else {
                    String code = enclosingCT == null ? "ag-props-correct.2" : "ct-props-correct.4";
                    String name = enclosingCT == null ? attrGrp.fName : enclosingCT.getName();
                    this.reportSchemaError(code, new Object[]{name, tempAttrUse.fAttrDecl.getName()}, child);
                }
            } else {
                if (!childName.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP) || (tempAttrGrp = this.fSchemaHandler.fAttributeGroupTraverser.traverseLocal(child, schemaDoc, grammar)) == null) break;
                XSObjectList attrUseS = tempAttrGrp.getAttributeUses();
                XSAttributeUseImpl existingAttrUse = null;
                int attrCount = attrUseS.getLength();
                int i = 0;
                while (i < attrCount) {
                    XSAttributeUseImpl oneAttrUse = (XSAttributeUseImpl)attrUseS.item(i);
                    existingAttrUse = attrGrp.getAttributeUse(oneAttrUse.fAttrDecl.getNamespace(), oneAttrUse.fAttrDecl.getName());
                    if (existingAttrUse == null) {
                        String idName = attrGrp.addAttributeUse(oneAttrUse);
                        if (idName != null) {
                            this.reportSchemaError("cvc-complex-type.5.3", new Object[]{oneAttrUse.fAttrDecl.getName(), idName}, child);
                        }
                    } else {
                        this.reportSchemaError("ct-props-correct.4", new Object[]{"Duplicate attribute " + existingAttrUse.fAttrDecl.getName() + " found "}, child);
                    }
                    ++i;
                }
                if (tempAttrGrp.fAttributeWC != null) {
                    if (attrGrp.fAttributeWC == null) {
                        attrGrp.fAttributeWC = tempAttrGrp.fAttributeWC;
                    } else {
                        attrGrp.fAttributeWC = attrGrp.fAttributeWC.performIntersectionWith(tempAttrGrp.fAttributeWC, attrGrp.fAttributeWC.fProcessContents);
                        if (attrGrp.fAttributeWC == null) {
                            this.reportSchemaError("src-wildcard", new Object[]{"intersection of wildcards is not expressible"}, child);
                        }
                    }
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        if (child != null && (childName = DOMUtil.getLocalName(child)).equals(SchemaSymbols.ELT_ANYATTRIBUTE)) {
            XSWildcardDecl tempAttrWC = this.fSchemaHandler.fWildCardTraverser.traverseAnyAttribute(child, schemaDoc, grammar);
            if (attrGrp.fAttributeWC == null) {
                attrGrp.fAttributeWC = tempAttrWC;
            } else {
                attrGrp.fAttributeWC = tempAttrWC.performIntersectionWith(attrGrp.fAttributeWC, tempAttrWC.fProcessContents);
                if (attrGrp.fAttributeWC == null) {
                    this.reportSchemaError("src-wildcard", new Object[]{"intersection of wildcards is not expressible"}, child);
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        return child;
    }

    void reportSchemaError(String key, Object[] args, Element ele) {
        this.fSchemaHandler.reportSchemaError(key, args, ele);
    }

    void checkNotationType(String refName, XSTypeDefinition typeDecl, Element elem) {
        if (typeDecl.getTypeCategory() == 14 && ((XSSimpleType)typeDecl).getVariety() == 1 && ((XSSimpleType)typeDecl).getPrimitiveKind() == 19 && (((XSSimpleType)typeDecl).getDefinedFacets() & 0x800) == 0) {
            this.reportSchemaError("enumeration-required-notation", new Object[]{refName}, elem);
        }
    }

    protected XSParticleDecl checkOccurrences(XSParticleDecl particle, String particleName, Element parent, int allContextFlags, long defaultVals) {
        boolean isGroupChild;
        int min = particle.fMinOccurs;
        int max = particle.fMaxOccurs;
        boolean defaultMin = (defaultVals & (long)(1 << XSAttributeChecker.ATTIDX_MINOCCURS)) != 0L;
        boolean defaultMax = (defaultVals & (long)(1 << XSAttributeChecker.ATTIDX_MAXOCCURS)) != 0L;
        boolean processingAllEl = (allContextFlags & 1) != 0;
        boolean processingAllGP = (allContextFlags & 8) != 0;
        boolean groupRefWithAll = (allContextFlags & 2) != 0;
        boolean bl = isGroupChild = (allContextFlags & 4) != 0;
        if (isGroupChild) {
            Object[] args;
            if (!defaultMin) {
                args = new Object[]{particleName, "minOccurs"};
                this.reportSchemaError("s4s-att-not-allowed", args, parent);
                min = 1;
            }
            if (!defaultMax) {
                args = new Object[]{particleName, "maxOccurs"};
                this.reportSchemaError("s4s-att-not-allowed", args, parent);
                max = 1;
            }
        }
        if (min == 0 && max == 0) {
            particle.fType = 0;
            return null;
        }
        if (processingAllEl) {
            if (max != 1) {
                this.reportSchemaError("cos-all-limited.2", null, parent);
                max = 1;
                if (min > 1) {
                    min = 1;
                }
            }
        } else if ((processingAllGP || groupRefWithAll) && max != 1) {
            this.reportSchemaError("cos-all-limited.1.2", null, parent);
            if (min > 1) {
                min = 1;
            }
            max = 1;
        }
        particle.fMaxOccurs = min;
        particle.fMaxOccurs = max;
        return particle;
    }

    class FacetInfo {
        XSFacets facetdata;
        Element nodeAfterFacets;
        short fPresentFacets;
        short fFixedFacets;

        FacetInfo() {
        }
    }
}

