/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorHandlerWrapper
implements XMLErrorHandler {
    protected ErrorHandler fErrorHandler;

    public ErrorHandlerWrapper() {
    }

    public ErrorHandlerWrapper(ErrorHandler errorHandler) {
        this.setErrorHandler(errorHandler);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public void warning(String domain, String key, XMLParseException exception) throws XNIException {
        SAXParseException saxException = ErrorHandlerWrapper.createSAXParseException(exception);
        try {
            this.fErrorHandler.warning(saxException);
        }
        catch (SAXParseException e) {
            throw ErrorHandlerWrapper.createXMLParseException(e);
        }
        catch (SAXException e) {
            throw ErrorHandlerWrapper.createXNIException(e);
        }
    }

    public void error(String domain, String key, XMLParseException exception) throws XNIException {
        SAXParseException saxException = ErrorHandlerWrapper.createSAXParseException(exception);
        try {
            this.fErrorHandler.error(saxException);
        }
        catch (SAXParseException e) {
            throw ErrorHandlerWrapper.createXMLParseException(e);
        }
        catch (SAXException e) {
            throw ErrorHandlerWrapper.createXNIException(e);
        }
    }

    public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
        SAXParseException saxException = ErrorHandlerWrapper.createSAXParseException(exception);
        try {
            this.fErrorHandler.fatalError(saxException);
        }
        catch (SAXParseException e) {
            throw ErrorHandlerWrapper.createXMLParseException(e);
        }
        catch (SAXException e) {
            throw ErrorHandlerWrapper.createXNIException(e);
        }
    }

    protected static SAXParseException createSAXParseException(XMLParseException exception) {
        return new SAXParseException(exception.getMessage(), exception.getPublicId(), exception.getExpandedSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getException());
    }

    protected static XMLParseException createXMLParseException(SAXParseException exception) {
        final String fPublicId = exception.getPublicId();
        final String fExpandedSystemId = exception.getSystemId();
        final int fLineNumber = exception.getLineNumber();
        final int fColumnNumber = exception.getColumnNumber();
        XMLLocator location = new XMLLocator(){

            public void setPublicId(String id) {
            }

            public String getPublicId() {
                return fPublicId;
            }

            public void setExpandedSystemId(String id) {
            }

            public String getExpandedSystemId() {
                return fExpandedSystemId;
            }

            public void setBaseSystemId(String id) {
            }

            public String getBaseSystemId() {
                return null;
            }

            public void setLiteralSystemId(String id) {
            }

            public String getLiteralSystemId() {
                return null;
            }

            public int getColumnNumber() {
                return fColumnNumber;
            }

            public void setColumnNumber(int col) {
            }

            public int getLineNumber() {
                return fLineNumber;
            }

            public void setLineNumber(int line) {
            }
        };
        return new XMLParseException(location, exception.getMessage(), exception.getException());
    }

    protected static XNIException createXNIException(SAXException exception) {
        return new XNIException(exception.getMessage(), exception.getException());
    }
}

