/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected SymbolTable fSymbolTable;
    protected boolean fDOML1 = false;
    protected int fNamespaceCounter = 1;
    protected static final String PREFIX = "NS";
    protected boolean fNamespaces = false;
    private boolean fPreserveSpace;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
    }

    public XMLSerializer(OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
    }

    public XMLSerializer(Writer writer, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputStream output, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(output);
    }

    public void setOutputFormat(OutputFormat format) {
        super.setOutputFormat(format != null ? format : new OutputFormat("xml", null, false));
    }

    public void setNamespaces(boolean namespaces) {
        this.fNamespaces = namespaces;
        this.fNSBinder = new NamespaceSupport();
        this.fLocalNSBinder = new NamespaceSupport();
        this.fSymbolTable = new SymbolTable();
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
        boolean addNSAttr = false;
        try {
            String value;
            String name;
            String prefix;
            if (this._printer == null) {
                String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(msg);
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(localName == null || localName.length() == 0 ? rawName : localName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                    state.inCData = false;
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            attrs = this.extractNamespaces(attrs);
            if (rawName == null || rawName.length() == 0) {
                if (localName == null) {
                    String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoName", null);
                    throw new SAXException(msg);
                }
                rawName = namespaceURI != null && !namespaceURI.equals("") ? ((prefix = this.getPrefix(namespaceURI)) != null && prefix.length() > 0 ? prefix + ":" + localName : localName) : localName;
                addNSAttr = true;
            }
            this._printer.printText('<');
            this._printer.printText(rawName);
            this._printer.indent();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    this._printer.printSpace();
                    name = attrs.getQName(i);
                    if (name != null && name.length() == 0) {
                        name = attrs.getLocalName(i);
                        String attrURI = attrs.getURI(i);
                        if (!(attrURI == null || attrURI.length() == 0 || namespaceURI != null && namespaceURI.length() != 0 && attrURI.equals(namespaceURI) || (prefix = this.getPrefix(attrURI)) == null || prefix.length() <= 0)) {
                            name = prefix + ":" + name;
                        }
                    }
                    if ((value = attrs.getValue(i)) == null) {
                        value = "";
                    }
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                    if (name.equals("xml:space")) {
                        preserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++i;
                }
            }
            if (this._prefixes != null) {
                Enumeration enumeration = this._prefixes.keys();
                while (enumeration.hasMoreElements()) {
                    this._printer.printSpace();
                    value = (String)enumeration.nextElement();
                    name = (String)this._prefixes.get(value);
                    if (name.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(value);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                }
            }
            state = this.enterElementState(namespaceURI, localName, rawName, preserveSpace);
            name = localName == null || localName.length() == 0 ? rawName : namespaceURI + "^" + localName;
            state.doCData = this._format.isCDataElement(name);
            state.unescaped = this._format.isNonEscapingElement(name);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        try {
            this.endElementIO(namespaceURI, localName, rawName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElementIO(String namespaceURI, String localName, String rawName) throws IOException {
        this._printer.unindent();
        ElementState state = this.getElementState();
        if (state.empty) {
            this._printer.printText("/>");
        } else {
            if (state.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !state.preserveSpace && (state.afterElement || state.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(state.rawName);
            this._printer.printText('>');
        }
        state = this.leaveElementState();
        state.afterElement = true;
        state.afterComment = false;
        state.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    public void startElement(String tagName, AttributeList attrs) throws SAXException {
        try {
            if (this._printer == null) {
                String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(msg);
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(tagName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                    state.inCData = false;
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            this._printer.printText('<');
            this._printer.printText(tagName);
            this._printer.indent();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    this._printer.printSpace();
                    String name = attrs.getName(i);
                    String value = attrs.getValue(i);
                    if (value != null) {
                        this._printer.printText(name);
                        this._printer.printText("=\"");
                        this.printEscaped(value);
                        this._printer.printText('\"');
                    }
                    if (name.equals("xml:space")) {
                        preserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++i;
                }
            }
            state = this.enterElementState(null, null, tagName, preserveSpace);
            state.doCData = this._format.isCDataElement(tagName);
            state.unescaped = this._format.isNonEscapingElement(tagName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElement(String tagName) throws SAXException {
        this.endElement(null, null, tagName);
    }

    protected void startDocument(String rootTagName) throws IOException {
        String dtd = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer buffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    buffer.append(this._format.getVersion());
                } else {
                    buffer.append("1.0");
                }
                buffer.append('\"');
                String format_encoding = this._format.getEncoding();
                if (format_encoding != null) {
                    buffer.append(" encoding=\"");
                    buffer.append(format_encoding);
                    buffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    buffer.append(" standalone=\"yes\"");
                }
                buffer.append("?>");
                this._printer.printText(buffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(rootTagName);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            int i = 0;
                            while (i < 18 + rootTagName.length()) {
                                this._printer.printText(" ");
                                ++i;
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (dtd != null && dtd.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(dtd, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (dtd != null && dtd.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(rootTagName);
                    this._printer.printText(" [");
                    this.printText(dtd, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    protected void serializeElement(Element elem) throws IOException {
        String value;
        String name;
        Attr attr;
        int i;
        if (this.fNamespaces) {
            this.fLocalNSBinder.reset();
            this.fLocalNSBinder.pushContext();
            this.fNSBinder.pushContext();
        }
        String tagName = elem.getTagName();
        ElementState state = this.getElementState();
        if (this.isDocumentState()) {
            boolean bl = this.fDOML1 = elem.getLocalName() == null;
            if (!this._started) {
                this.startDocument(tagName);
            }
        } else {
            if (state.empty) {
                this._printer.printText('>');
            }
            if (state.inCData) {
                this._printer.printText("]]>");
                state.inCData = false;
            }
            if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                this._printer.breakLine();
            }
        }
        this.fPreserveSpace = state.preserveSpace;
        int length = 0;
        NamedNodeMap attrMap = null;
        if (elem.hasAttributes()) {
            attrMap = elem.getAttributes();
            length = attrMap.getLength();
        }
        if (!this.fNamespaces) {
            this._printer.printText('<');
            this._printer.printText(tagName);
            this._printer.indent();
            i = 0;
            while (i < length) {
                attr = (Attr)attrMap.item(i);
                name = attr.getName();
                value = attr.getValue();
                if (value == null) {
                    value = "";
                }
                if (attr.getSpecified()) {
                    this._printer.printSpace();
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                }
                if (name.equals("xml:space")) {
                    this.fPreserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
                }
                ++i;
            }
        } else {
            String prefix;
            String uri;
            i = 0;
            while (i < length) {
                attr = (Attr)attrMap.item(i);
                uri = attr.getNamespaceURI();
                if (uri != null && uri.equals(NamespaceContext.XMLNS_URI)) {
                    value = attr.getNodeValue();
                    if (value == null) {
                        value = XMLSymbols.EMPTY_STRING;
                    }
                    if (value.equals(NamespaceContext.XMLNS_URI)) {
                        if (this.fDOMErrorHandler != null) {
                            this.modifyDOMError("No prefix other than 'xmlns' can be bound to 'http://www.w3.org/2000/xmlns/' namespace name", (short)1, attr);
                            boolean continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                            if (!continueProcess) {
                                throw new RuntimeException("Stopped at user request");
                            }
                        }
                    } else {
                        prefix = attr.getPrefix();
                        prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                        String localpart = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (prefix == XMLSymbols.PREFIX_XMLNS) {
                            if ((value = this.fSymbolTable.addSymbol(value)).length() != 0) {
                                this.fNSBinder.declarePrefix(localpart, value);
                            }
                        } else {
                            value = this.fSymbolTable.addSymbol(value);
                            this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, value);
                        }
                    }
                }
                ++i;
            }
            uri = elem.getNamespaceURI();
            prefix = elem.getPrefix();
            if (uri != null && prefix != null && uri.length() == 0 && prefix.length() != 0) {
                prefix = null;
                this._printer.printText('<');
                this._printer.printText(elem.getLocalName());
                this._printer.indent();
            } else {
                this._printer.printText('<');
                this._printer.printText(tagName);
                this._printer.indent();
            }
            if (uri != null) {
                uri = this.fSymbolTable.addSymbol(uri);
                String string = prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                if (this.fNSBinder.getURI(prefix) != uri) {
                    this.printNamespaceAttr(prefix, uri);
                    this.fLocalNSBinder.declarePrefix(prefix, uri);
                }
            } else {
                int colon = tagName.indexOf(58);
                if (colon > -1) {
                    if (this.fDOMErrorHandler != null) {
                        String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ElementQName", new Object[]{tagName});
                        this.modifyDOMError(msg, (short)1, elem);
                        boolean continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                        if (!continueProcess) {
                            throw new RuntimeException("Process stoped at user request");
                        }
                    }
                } else {
                    uri = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                    if (uri != null && uri.length() > 0) {
                        this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                        this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    }
                }
            }
            i = 0;
            while (i < length) {
                attr = (Attr)attrMap.item(i);
                value = attr.getValue();
                name = attr.getNodeName();
                uri = attr.getNamespaceURI();
                if (uri != null && uri.length() == 0) {
                    uri = null;
                    name = attr.getLocalName();
                }
                if (value == null) {
                    value = XMLSymbols.EMPTY_STRING;
                }
                if (uri != null) {
                    prefix = attr.getPrefix();
                    prefix = prefix == null ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                    String localpart = this.fSymbolTable.addSymbol(attr.getLocalName());
                    if (uri != null && uri.equals(NamespaceContext.XMLNS_URI)) {
                        String localUri;
                        prefix = attr.getPrefix();
                        prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                        localpart = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (prefix == XMLSymbols.PREFIX_XMLNS) {
                            localUri = this.fLocalNSBinder.getURI(localpart);
                            if ((value = this.fSymbolTable.addSymbol(value)).length() != 0) {
                                if (localUri != null) {
                                    this.fNSBinder.declarePrefix(localpart, localUri);
                                } else {
                                    this.printNamespaceAttr(localpart, value);
                                }
                            }
                        } else {
                            uri = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                            localUri = this.fLocalNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                            value = this.fSymbolTable.addSymbol(value);
                            if (localUri != null) {
                                this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, value);
                            } else {
                                this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, value);
                            }
                        }
                    } else {
                        uri = this.fSymbolTable.addSymbol(uri);
                        String declaredURI = this.fNSBinder.getURI(prefix);
                        if (prefix == XMLSymbols.EMPTY_STRING || declaredURI != uri) {
                            name = attr.getNodeName();
                            String declaredPrefix = this.fLocalNSBinder.getPrefix(uri);
                            if (declaredPrefix == null) {
                                declaredPrefix = this.fNSBinder.getPrefix(uri);
                            }
                            if (declaredPrefix != null && declaredPrefix != XMLSymbols.EMPTY_STRING) {
                                prefix = declaredPrefix;
                                name = prefix + ":" + localpart;
                            } else {
                                if (prefix == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(prefix) != null) {
                                    prefix = this.fSymbolTable.addSymbol(PREFIX + this.fNamespaceCounter++);
                                    while (this.fLocalNSBinder.getURI(prefix) != null) {
                                        prefix = this.fSymbolTable.addSymbol(PREFIX + this.fNamespaceCounter++);
                                    }
                                    name = prefix + ":" + localpart;
                                }
                                this.printNamespaceAttr(prefix, uri);
                                value = this.fSymbolTable.addSymbol(value);
                                this.fLocalNSBinder.declarePrefix(prefix, value);
                                this.fNSBinder.declarePrefix(prefix, uri);
                            }
                        }
                        this.printAttribute(name, value == null ? XMLSymbols.EMPTY_STRING : value, attr.getSpecified());
                    }
                } else {
                    int colon = name.indexOf(58);
                    if (colon > -1) {
                        if (this.fDOMErrorHandler != null) {
                            this.modifyDOMError("DOM Level 1 Node: " + name, (short)1, attr);
                            boolean continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                            if (!continueProcess) {
                                throw new RuntimeException("Stopped at user request");
                            }
                        }
                        this.printAttribute(name, value, attr.getSpecified());
                    } else {
                        this.printAttribute(name, value, attr.getSpecified());
                    }
                }
                ++i;
            }
        }
        if (elem.hasChildNodes()) {
            state = this.enterElementState(null, null, tagName, this.fPreserveSpace);
            state.doCData = this._format.isCDataElement(tagName);
            state.unescaped = this._format.isNonEscapingElement(tagName);
            Node child = elem.getFirstChild();
            while (child != null) {
                this.serializeNode(child);
                child = child.getNextSibling();
            }
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this.endElementIO(null, null, tagName);
        } else {
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this._printer.unindent();
            this._printer.printText("/>");
            state.afterElement = true;
            state.afterComment = false;
            state.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    private void printNamespaceAttr(String prefix, String uri) throws IOException {
        this._printer.printSpace();
        if (prefix == XMLSymbols.EMPTY_STRING) {
            this._printer.printText(XMLSymbols.PREFIX_XMLNS);
        } else {
            this._printer.printText("xmlns:" + prefix);
        }
        this._printer.printText("=\"");
        this.printEscaped(uri);
        this._printer.printText('\"');
    }

    private void printAttribute(String name, String value, boolean isSpecified) throws IOException {
        if (isSpecified || this.fFeatures != null && !((Boolean)this.fFeatures.get("discard-default-content")).booleanValue()) {
            this._printer.printSpace();
            this._printer.printText(name);
            this._printer.printText("=\"");
            this.printEscaped(value);
            this._printer.printText('\"');
        }
        if (name.equals("xml:space")) {
            this.fPreserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
        }
    }

    protected String getEntityRef(int ch) {
        switch (ch) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attrs) throws SAXException {
        if (attrs == null) {
            return null;
        }
        int length = attrs.getLength();
        AttributesImpl attrsOnly = new AttributesImpl(attrs);
        int i = length - 1;
        while (i >= 0) {
            String rawName = attrsOnly.getQName(i);
            if (rawName.startsWith("xmlns")) {
                if (rawName.length() == 5) {
                    this.startPrefixMapping("", attrs.getValue(i));
                    attrsOnly.removeAttribute(i);
                } else if (rawName.charAt(5) == ':') {
                    this.startPrefixMapping(rawName.substring(6), attrs.getValue(i));
                    attrsOnly.removeAttribute(i);
                }
            }
            --i;
        }
        return attrsOnly;
    }

    protected void printEscaped(String source) throws IOException {
        int length = source.length();
        int i = 0;
        while (i < length) {
            char ch = source.charAt(i);
            if (!XMLChar.isValid(ch)) {
                if (++i < length) {
                    this.surrogates(ch, source.charAt(i));
                } else {
                    this.fatalError("The character '" + (char)ch + "' is an invalid XML character");
                }
            } else {
                this.printXMLChar(ch);
            }
            ++i;
        }
    }

    protected void printXMLChar(int ch) throws IOException {
        if (ch == 60) {
            this._printer.printText("&lt;");
        } else if (ch == 38) {
            this._printer.printText("&amp;");
        } else if (ch == 34) {
            this._printer.printText("&quot;");
        } else if (ch >= 32 && this._encodingInfo.isPrintable((char)ch) || ch == 10 || ch == 13 || ch == 9) {
            this._printer.printText((char)ch);
        } else {
            this._printer.printText("&#x");
            this._printer.printText(Integer.toHexString(ch));
            this._printer.printText(';');
        }
    }

    protected void printText(String text, boolean preserveSpace, boolean unescaped) throws IOException {
        int length = text.length();
        if (preserveSpace) {
            int index = 0;
            while (index < length) {
                char ch = text.charAt(index);
                if (!XMLChar.isValid(ch)) {
                    if (++index < length) {
                        this.surrogates(ch, text.charAt(index));
                    } else {
                        this.fatalError("The character '" + ch + "' is an invalid XML character");
                    }
                } else if (unescaped) {
                    this._printer.printText(ch);
                } else {
                    this.printXMLChar(ch);
                }
                ++index;
            }
        } else {
            int index = 0;
            while (index < length) {
                char ch = text.charAt(index);
                if (!XMLChar.isValid(ch)) {
                    if (++index < length) {
                        this.surrogates(ch, text.charAt(index));
                    } else {
                        this.fatalError("The character '" + ch + "' is an invalid XML character");
                    }
                } else if (XMLChar.isSpace(ch)) {
                    this._printer.printSpace();
                } else if (unescaped) {
                    this._printer.printText(ch);
                } else {
                    this.printXMLChar(ch);
                }
                ++index;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void printText(char[] chars, int start, int length, boolean preserveSpace, boolean unescaped) throws IOException {
        block9: {
            if (!preserveSpace) ** GOTO lbl32
            while (length-- > 0) {
                ch = chars[start];
                ++start;
                if (!XMLChar.isValid(ch)) {
                    if (++start < length) {
                        this.surrogates(ch, chars[start]);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                ch = chars[start];
                ++start;
                if (!XMLChar.isValid(ch)) {
                    if (++start < length) {
                        this.surrogates(ch, chars[start]);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (XMLChar.isSpace(ch)) {
                    this._printer.printSpace();
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
lbl32:
                // 6 sources

                ** while (length-- > 0)
            }
        }
    }

    public boolean reset() {
        super.reset();
        return true;
    }
}

