/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.script.xscript;

import com.bea.wlw.netui.script.xscript.ScriptParsingException;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.ArrayList;
import java.util.List;

final class ScriptParser {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$script$xscript$ScriptParser == null ? (class$com$bea$wlw$netui$script$xscript$ScriptParser = ScriptParser.class$("com.bea.wlw.netui.script.xscript.ScriptParser")) : class$com$bea$wlw$netui$script$xscript$ScriptParser));
    private static final Logger logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$script$xscript$ScriptParser == null ? (class$com$bea$wlw$netui$script$xscript$ScriptParser = ScriptParser.class$("com.bea.wlw.netui.script.xscript.ScriptParser")) : class$com$bea$wlw$netui$script$xscript$ScriptParser));
    private static final int ERROR = -1;
    private static final int START = 0;
    private static final int ID = 1;
    private static final int DOT = 2;
    private static final int START_MAP = 3;
    private static final int ARY_ID = 4;
    private static final int START_MAP_ID = 5;
    private static final int MAP_ID = 6;
    private static final int END_MAP_ID = 7;
    private static final int END_MAP = 8;
    private static final int START_RVALUE = 9;
    private static final int RVALUE = 10;
    private static final int XML_EXPR = 26;
    private static final int NONE = 0;
    private static final int SINGLE = 1;
    private static final int DOUBLE = 2;
    static /* synthetic */ Class class$com$bea$wlw$netui$script$xscript$ScriptParser;

    ScriptParser() {
    }

    static ParsedExpression parse(String expression) {
        QuoteState quote = new QuoteState();
        Identifier id = new Identifier();
        StringBuffer buf = new StringBuffer();
        ParsedExpression pe = new ParsedExpression(expression);
        if (ScriptParser.debug.ON) {
            debug.out("parse: \"" + expression + "\"");
        }
        int state = 0;
        String cs = expression;
        int len = cs.length();
        int i = 0;
        while (i < len) {
            char c = cs.charAt(i);
            int oldState = state;
            if ((state = ScriptParser.nextToken(state, c, cs, i, quote)) == 1) {
                buf.append(c);
            } else {
                if (state == 26) {
                    pe.setXMLExpression(true);
                    return pe;
                }
                if (state == 2) {
                    if (buf.length() > 0) {
                        id.id = buf.toString();
                        pe.addIdentifier(id);
                    }
                    buf = new StringBuffer();
                    id = new Identifier();
                } else if (state == 3) {
                    if (buf.length() > 0) {
                        id.id = buf.toString();
                        pe.addIdentifier(id);
                        buf = new StringBuffer();
                        id = new Identifier();
                    }
                    id.type = 1;
                } else if (state == 4) {
                    id.type = 2;
                    buf.append(c);
                } else if (state == 6) {
                    buf.append(c);
                } else if (state == 8) {
                    id.id = buf.toString();
                    pe.addIdentifier(id);
                    id = new Identifier();
                    buf = new StringBuffer();
                } else if (state == 9) {
                    if (buf.length() > 0) {
                        id.id = buf.toString();
                        pe.addIdentifier(id);
                    }
                    id = new Identifier();
                    id.type = 3;
                    buf = new StringBuffer();
                } else if (state == 10) {
                    buf.append(c);
                } else if (state == -1) {
                    String msg = "The expression \"" + expression + "\" completed parsing \"" + expression.substring(0, i) + "\" and encountered a parse error at '" + c + "'";
                    logger.warn((Object)msg);
                    ScriptParsingException spe = new ScriptParsingException(msg, expression);
                    spe.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ScriptParser_parsingException", (Object[])new Object[]{expression, expression.substring(0, i), new Character(c)}));
                    throw spe;
                }
            }
            ++i;
        }
        if (state != 0 && state != 10 && state != 8 && state != 1) {
            int loc = cs.length() - 1;
            char err = cs.charAt(loc);
            String msg = "The expression \"" + expression + "\" completed parsing \"" + expression.substring(0, loc) + "\" and encountered a parse error at '" + err + "' with end state " + ScriptParser.stateToString(state) + ".";
            logger.warn((Object)msg);
            ScriptParsingException spe = new ScriptParsingException(msg, expression);
            spe.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ScriptParser_endStateParsingException", (Object[])new Object[]{expression, expression.substring(0, loc), new Character(err), ScriptParser.stateToString(state)}));
            throw spe;
        }
        if (buf.length() > 0) {
            id.id = buf.toString();
            pe.addIdentifier(id);
        }
        return pe;
    }

    private static int nextToken(int currState, char c, CharSequence cs, int loc, QuoteState quote) {
        int state = -1;
        if (currState == 0) {
            if (Character.isJavaIdentifierStart(c)) {
                return 1;
            }
        } else if (currState == 1) {
            if (Character.isJavaIdentifierPart(c)) {
                return 1;
            }
            if (c == '[') {
                return 3;
            }
            if (c == '.') {
                return 2;
            }
            if (c == '=') {
                return 9;
            }
        } else if (currState == 3) {
            if (Character.isDigit(c)) {
                return 4;
            }
            if (c == '\"' && quote.state == 0) {
                if (ScriptParser.debug.ON) {
                    debug.out("DOUBLE");
                }
                quote.state = 2;
                return 5;
            }
            if (c == '\'' && quote.state == 0) {
                if (ScriptParser.debug.ON) {
                    debug.out("SINGLE");
                }
                quote.state = 1;
                return 5;
            }
            if (ScriptParser.debug.ON) {
                debug.out("ERROR: c=" + c + " quote=" + quote.state);
            }
        } else if (currState == 4) {
            if (Character.isDigit(c)) {
                return 4;
            }
            if (c == ']') {
                return 8;
            }
        } else {
            if (currState == 5) {
                if (c == '\"' && quote.state == 2) {
                    if (ScriptParser.debug.ON) {
                        debug.out("END DOUBLE QUOTE");
                    }
                    quote.state = 0;
                    return 7;
                }
                if (c == '\'' && quote.state == 1) {
                    if (ScriptParser.debug.ON) {
                        debug.out("END SINGLE QUOTE");
                    }
                    quote.state = 0;
                    return 7;
                }
                return 6;
            }
            if (currState == 6) {
                if (c == '\"' && cs.charAt(loc - 1) != '\\' && quote.state == 2) {
                    if (ScriptParser.debug.ON) {
                        debug.out("END DOUBLE QUOTE");
                    }
                    quote.state = 0;
                    return 7;
                }
                if (c == '\'' && cs.charAt(loc - 1) != '\\' && quote.state == 1) {
                    if (ScriptParser.debug.ON) {
                        debug.out("END SINGLE QUOTE");
                    }
                    quote.state = 0;
                    return 7;
                }
                return 6;
            }
            if (currState == 7) {
                if (c == ']') {
                    return 8;
                }
            } else if (currState == 8) {
                if (c == '[') {
                    return 3;
                }
                if (c == '.') {
                    return 2;
                }
                if (c == '=') {
                    return 9;
                }
            } else if (currState == 2) {
                if (Character.isJavaIdentifierStart(c)) {
                    return 1;
                }
                if (c == '.' || c == '@' || c == '*' || c == '(') {
                    return 26;
                }
            } else if (currState == 9 || currState == 10) {
                return 10;
            }
        }
        return -1;
    }

    private static String stateToString(int state) {
        switch (state) {
            case -1: {
                return "ERROR";
            }
            case 0: {
                return "START";
            }
            case 1: {
                return "ID";
            }
            case 2: {
                return "DOT";
            }
            case 3: {
                return "START_MAP";
            }
            case 4: {
                return "ARY_ID";
            }
            case 5: {
                return "START_MAP_ID";
            }
            case 6: {
                return "MAP_ID";
            }
            case 7: {
                return "END_MAP_ID";
            }
            case 8: {
                return "END_MAP";
            }
            case 9: {
                return "START_RVALUE";
            }
            case 10: {
                return "RVALUE";
            }
            case 26: {
                return "XML_EXPR";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Identifier {
        public static final int ID = 0;
        public static final int MAP_ID = 1;
        public static final int ARY_ID = 2;
        public static final int RVALUE = 3;
        public int type = 0;
        public String id = null;

        Identifier() {
        }

        public String toString() {
            return this.id;
        }

        public String toDebugString() {
            StringBuffer buf = new StringBuffer();
            buf.append("" + this.typeToString(this.type));
            buf.append(": ");
            buf.append(this.id);
            return buf.toString();
        }

        private String typeToString(int type) {
            switch (type) {
                case 0: {
                    return "ID";
                }
                case 1: {
                    return "MAP_ID";
                }
                case 2: {
                    return "ARY_ID";
                }
                case 3: {
                    return "RVALUE";
                }
                case 26: {
                    return "XML_EXPR";
                }
            }
            return "UNKNOWN";
        }
    }

    static class ParsedExpression {
        private List ids = null;
        private String expression = null;
        private String origExpression = null;
        private boolean xmlExpr = false;

        ParsedExpression(String expression) {
            this.origExpression = expression;
        }

        void setXMLExpression(boolean xmlExpr) {
            this.xmlExpr = xmlExpr;
        }

        boolean isXMLExpression() {
            return this.xmlExpr;
        }

        String getExpression() {
            if (this.isXMLExpression()) {
                return this.origExpression;
            }
            if (this.ids == null) {
                return "";
            }
            if (this.expression == null) {
                this.expression = this.fixup();
            }
            return this.expression;
        }

        void addIdentifier(Identifier id) {
            if (this.ids == null) {
                this.ids = new ArrayList();
            }
            this.ids.add(id);
        }

        List getIdentifiers() {
            return this.ids;
        }

        String getContext() {
            if (this.ids == null) {
                return "";
            }
            return ((Identifier)this.ids.get(0)).toString();
        }

        String changeContext(String newContext) {
            return this._getExpression(0, this.ids.size(), false, true, newContext);
        }

        private String fixup() {
            return this._getExpression(0, this.ids.size(), true, false, null);
        }

        String getBranchExpression() {
            return this._getExpression(0, this.ids.size() - 1, false, false, null);
        }

        private String _getExpression(int start, int end, boolean fixup, boolean changeContext, String newContext) {
            StringBuffer buf = new StringBuffer();
            int i = start;
            while (i < end) {
                Identifier id = (Identifier)this.ids.get(i);
                if (id.type == 0) {
                    if (i == 0) {
                        if (changeContext) {
                            buf.append(newContext);
                        } else {
                            buf.append(id.id);
                        }
                    } else {
                        buf.append("[\"");
                        buf.append(id.id);
                        buf.append("\"]");
                    }
                } else if (id.type == 1) {
                    buf.append("[\"");
                    buf.append(id.id);
                    buf.append("\"]");
                } else if (id.type == 2) {
                    buf.append("[");
                    buf.append(id.id);
                    buf.append("]");
                } else if (id.type == 3) {
                    buf.append("=");
                    buf.append(id.id);
                }
                ++i;
            }
            return buf.toString();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.ids.size()) {
                Identifier id = (Identifier)this.ids.get(i);
                if (id.type == 0) {
                    if (i > 0) {
                        buf.append(".");
                    }
                    buf.append(id.id);
                } else if (id.type == 1) {
                    buf.append("[\"");
                    buf.append(id.id);
                    buf.append("\"]");
                } else if (id.type == 2) {
                    buf.append("[");
                    buf.append(id.id);
                    buf.append("]");
                } else if (id.type == 3) {
                    buf.append("=");
                    buf.append(id.id);
                }
                ++i;
            }
            return buf.toString();
        }
    }

    private static class QuoteState {
        int state = 0;

        private QuoteState() {
        }
    }
}

