/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.util.iterator;

import XMLRuntime.XML;
import XMLRuntime.XMLList;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.iterator.IteratorFactory;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class XScriptXMLIterator {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$util$iterator$XScriptXMLIterator == null ? (class$com$bea$wlw$netui$util$iterator$XScriptXMLIterator = XScriptXMLIterator.class$("com.bea.wlw.netui.util.iterator.XScriptXMLIterator")) : class$com$bea$wlw$netui$util$iterator$XScriptXMLIterator));
    static /* synthetic */ Class class$com$bea$wlw$netui$util$iterator$XScriptXMLIterator;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class XMLListIterator
    implements Iterator {
        private XMLList xmlList = null;
        private int totalElements = 0;
        private int currentElement = 0;

        public XMLListIterator(XMLList xmlList) {
            if (xmlList != null) {
                this.xmlList = xmlList;
                this.totalElements = xmlList.length();
                if (debug.ON) {
                    debug.out("total elements: " + this.totalElements);
                }
            }
        }

        public boolean hasNext() {
            return this.currentElement < this.totalElements;
        }

        public Object next() {
            if (this.currentElement >= this.totalElements) {
                throw new NoSuchElementException(Bundle.getErrorString((String)"IteratorFactory_Iterator_noSuchElement"));
            }
            XML xml = null;
            xml = this.xmlList.item(this.currentElement);
            ++this.currentElement;
            return xml;
        }

        public void remove() {
            throw new UnsupportedOperationException(Bundle.getErrorString((String)"IteratorFactory_Iterator_removeUnsupported", (Object[])new Object[]{this.getClass().getName()}));
        }
    }

    public static class XMLIterator
    implements Iterator {
        private XML xml = null;
        private int totalElements = 0;
        private int currentElement = 0;

        public XMLIterator(XML xml) {
            if (xml != null) {
                this.xml = xml;
                this.totalElements = xml.childElementCount();
            }
        }

        public boolean hasNext() {
            return this.currentElement < this.totalElements;
        }

        public Object next() {
            if (this.currentElement >= this.totalElements) {
                throw new NoSuchElementException(Bundle.getErrorString((String)"IteratorFactory_Iterator_noSuchElement"));
            }
            Object element = null;
            element = this.xml.child(this.currentElement);
            ++this.currentElement;
            return element;
        }

        public void remove() {
            throw new UnsupportedOperationException(Bundle.getErrorString((String)"IteratorFactory_Iterator_removeUnsupported", (Object[])new Object[]{this.getClass().getName()}));
        }
    }

    static class XMLListIteratorPlant
    extends IteratorFactory.IteratorPlant {
        XMLListIteratorPlant() {
        }

        Iterator createIterator(Object value) {
            if (value instanceof XMLList) {
                return new XMLListIterator((XMLList)value);
            }
            return null;
        }
    }

    static class XMLIteratorPlant
    extends IteratorFactory.IteratorPlant {
        XMLIteratorPlant() {
        }

        Iterator createIterator(Object value) {
            if (value instanceof XML) {
                return new XMLIterator((XML)value);
            }
            return null;
        }
    }
}

