/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.apache.lucene;

import com.bea.control.ControlContext;
import com.bea.control.ControlException;
import com.bea.control.ControlSource;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.queryParser.ParseException;
import org.controlhaus.apache.lucene.LuceneControl;
import org.controlhaus.apache.lucene.pojo.LuceneField;
import org.controlhaus.apache.lucene.pojo.LuceneHit;
import org.controlhaus.apache.lucene.pojo.LucenePojo;

public class LuceneControlImpl
implements LuceneControl,
ControlSource {
    static final long serialVersionUID = 1L;
    ControlContext context;

    public void index(LuceneField[] fields) {
        String indexPath = this.context.getControlAttribute("jc:luceneProperties", "indexPath");
        LucenePojo pojo = new LucenePojo(new File(indexPath));
        try {
            pojo.index(fields);
            return;
        }
        catch (IOException ex) {
            throw new ControlException("Problem indexing data into Lucene index", (Throwable)ex);
        }
    }

    public LuceneHit[] search(String query, String searchFieldName, String[] returnFieldNames) {
        LuceneHit[] result = null;
        String indexPath = this.context.getControlAttribute("jc:luceneProperties", "indexPath");
        LucenePojo pojo = new LucenePojo(new File(indexPath));
        try {
            result = pojo.search(query, searchFieldName, returnFieldNames);
        }
        catch (IOException ex) {
            throw new ControlException("Problem querying Lucene index with query '" + query + "'", (Throwable)ex);
        }
        catch (ParseException ex) {
            throw new ControlException("Problem parsing search query '" + query + "'", (Throwable)ex);
        }
        return result;
    }
}

