/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.apache.lucene.pojo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.controlhaus.apache.lucene.pojo.LuceneField;
import org.controlhaus.apache.lucene.pojo.LuceneHit;

public class LucenePojo {
    private final File index;

    public LucenePojo(File index) {
        this.index = index;
    }

    public void index(LuceneField[] fields) throws IOException {
        IndexWriter writer = new IndexWriter(this.index, (Analyzer)new StandardAnalyzer(), !this.index.exists());
        Document document = new Document();
        int i = 0;
        while (i < fields.length) {
            document.add(Field.Text((String)fields[i].getName(), (String)fields[i].getValue()));
            ++i;
        }
        writer.addDocument(document);
        writer.optimize();
        writer.close();
    }

    public LuceneHit[] search(String query, String searchFieldName, String[] returnFieldNames) throws IOException, ParseException {
        IndexSearcher searcher = new IndexSearcher(this.index.getAbsolutePath());
        StandardAnalyzer analyzer = new StandardAnalyzer();
        Query q = QueryParser.parse((String)query, (String)searchFieldName, (Analyzer)analyzer);
        Hits hits = searcher.search(q);
        ArrayList<LuceneHit> result = new ArrayList<LuceneHit>();
        int i = 0;
        while (i < hits.length()) {
            Document doc = hits.doc(i);
            LuceneHit hit = new LuceneHit(hits.score(i));
            this.addFields(returnFieldNames, doc, hit);
            result.add(hit);
            ++i;
        }
        LuceneHit[] array = new LuceneHit[result.size()];
        return result.toArray(array);
    }

    private void addFields(String[] returnFieldNames, Document doc, LuceneHit hit) {
        int j = 0;
        while (j < returnFieldNames.length) {
            Field field = doc.getField(returnFieldNames[j]);
            hit.addField(new LuceneField(field.name(), field.stringValue()));
            ++j;
        }
    }
}

