/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.pageflow.FlowControllerFactory;
import org.apache.beehive.netui.pageflow.GlobalApp;
import org.apache.beehive.netui.pageflow.PageFlowRequestProcessor;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.handler.ForwardRedirectHandler;
import org.apache.beehive.netui.pageflow.internal.ContextCache;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.internal.RequestValues;
import org.apache.beehive.netui.util.Bundle;
import org.apache.beehive.netui.util.DiscoveryUtils;
import org.apache.beehive.netui.util.ServletUtils;
import org.apache.beehive.netui.util.config.ConfigUtil;
import org.apache.beehive.netui.util.config.bean.ModuleConfigLocators;
import org.apache.beehive.netui.util.config.bean.PageflowConfig;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.commons.digester.Digester;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.DynaActionFormClass;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.ModuleConfigFactory;
import org.apache.struts.config.impl.ModuleConfigImpl;
import org.apache.struts.util.RequestUtils;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoRegisterActionServlet
extends ActionServlet {
    public static String MODULE_CONFIG_LOCATOR_CLASS_ATTR = "moduleConfigLocators";
    private Map<String, ModuleConfig> _registeredModules = new ConcurrentHashMap<String, ModuleConfig>();
    private transient Digester _cachedConfigDigester = null;
    private Map _configParams = null;
    private ModuleConfigLocator[] _moduleConfigLocators = null;
    private ContextCache _contextCache;
    private static final Logger _log = Logger.getInstance(AutoRegisterActionServlet.class);
    private static final ModuleConfig NONEXISTANT_MODULE_CONFIG = new NonexistantModuleConfig();

    public void init(ServletConfig servletConfig) throws ServletException {
        this._contextCache = ContextCache.get(servletConfig.getServletContext());
        this.setupModuleConfigLocators(servletConfig);
        super.init(servletConfig);
    }

    private void setupModuleConfigLocators(ServletConfig servletConfig) {
        String configLocatorList;
        int i;
        ModuleConfigLocators mcLocators;
        ModuleConfigLocator[] defaultLocators = this.getDefaultModuleConfigLocators();
        ArrayList<ModuleConfigLocator> locators = new ArrayList<ModuleConfigLocator>();
        for (int i2 = 0; i2 < defaultLocators.length; ++i2) {
            locators.add(defaultLocators[i2]);
        }
        PageflowConfig pfConfig = ConfigUtil.getConfig().getPageflowConfig();
        if (pfConfig != null && (mcLocators = pfConfig.getModuleConfigLocators()) != null) {
            ModuleConfigLocators.ModuleConfigLocator[] array = mcLocators.getModuleConfigLocatorArray();
            for (i = 0; i < array.length; ++i) {
                AutoRegisterActionServlet.addModuleConfigLocator(array[i].getLocatorClass().trim(), locators);
            }
        }
        if ((configLocatorList = servletConfig.getInitParameter(MODULE_CONFIG_LOCATOR_CLASS_ATTR)) != null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Found module-config-locators list in context-parameter " + MODULE_CONFIG_LOCATOR_CLASS_ATTR + ", which is deprecated.  Please use the <module-config-locators> element in " + "/WEB-INF/netui-config.xml" + " instead."));
            }
            String[] configLocatorClassNames = configLocatorList.split(",");
            for (i = 0; i < configLocatorClassNames.length; ++i) {
                AutoRegisterActionServlet.addModuleConfigLocator(configLocatorClassNames[i].trim(), locators);
            }
        }
        this._moduleConfigLocators = locators.toArray(new ModuleConfigLocator[locators.size()]);
    }

    private static void addModuleConfigLocator(String locatorClassName, ArrayList<ModuleConfigLocator> locators) {
        try {
            Class locatorClass = DiscoveryUtils.loadImplementorClass((String)locatorClassName, ModuleConfigLocator.class);
            if (locatorClass != null) {
                ModuleConfigLocator locator = (ModuleConfigLocator)locatorClass.newInstance();
                locators.add(locator);
            }
        }
        catch (IllegalAccessException e) {
            _log.error((Object)("Could not create an instance of specified module-config-locator " + locatorClassName), (Throwable)e);
        }
        catch (InstantiationException e) {
            _log.error((Object)("Could not create an instance of specified module-config-locator " + locatorClassName), (Throwable)e);
        }
    }

    protected ModuleConfigLocator[] getDefaultModuleConfigLocators() {
        return new ModuleConfigLocator[0];
    }

    public ModuleConfigLocator[] getModuleConfigLocators() {
        return this._moduleConfigLocators;
    }

    public String getModuleConfPath(String modulePath) {
        if (this._moduleConfigLocators != null) {
            for (int i = 0; i < this._moduleConfigLocators.length; ++i) {
                ModuleConfigLocator locator = this._moduleConfigLocators[i];
                String moduleConfigPath = locator.getModuleConfigPath(modulePath);
                try {
                    if (this.getConfigResource(moduleConfigPath) != null) {
                        return moduleConfigPath;
                    }
                    continue;
                }
                catch (MalformedURLException e) {
                    _log.error((Object)("ModuleConfigLocator " + locator.getClass().getName() + " returned an invalid path: " + moduleConfigPath + '.'), (Throwable)e);
                }
            }
        }
        return null;
    }

    private boolean isAutoLoadModulePath(String modulePath, String prefix) {
        if (this._moduleConfigLocators != null) {
            for (int i = 0; i < this._moduleConfigLocators.length; ++i) {
                ModuleConfigLocator locator = this._moduleConfigLocators[i];
                if (!modulePath.equals(locator.getModuleConfigPath(prefix))) continue;
                return true;
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("serializing ActionServlet " + (Object)((Object)this)));
        }
        if (this._configParams != null) {
            stream.writeObject(this._configParams);
        } else {
            ServletConfig servletConfig = this.getServletConfig();
            assert (servletConfig != null);
            HashMap<String, String> params = new HashMap<String, String>();
            Enumeration e = servletConfig.getInitParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                params.put(name, servletConfig.getInitParameter(name));
            }
            stream.writeObject(params);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("deserializing ActionServlet " + (Object)((Object)this)));
        }
        this._configParams = (Map)stream.readObject();
    }

    public String getInitParameter(String s) {
        if (this.getServletConfig() == null) {
            assert (this._configParams != null);
            return (String)this._configParams.get(s);
        }
        return super.getInitParameter(s);
    }

    public Enumeration getInitParameterNames() {
        if (this.getServletConfig() == null) {
            assert (this._configParams != null);
            return Collections.enumeration(this._configParams.keySet());
        }
        return super.getInitParameterNames();
    }

    protected ModuleConfig initModuleConfig(String prefix, String paths) throws ServletException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Initializing module path '" + prefix + "' configuration from '" + paths + '\''));
        }
        ModuleConfig moduleConfig = null;
        InputStream input = null;
        try {
            ModuleConfigFactory factoryObject = ModuleConfigFactory.createFactory();
            moduleConfig = factoryObject.createModuleConfig(prefix);
            String mapping = this.getServletConfig().getInitParameter("mapping");
            if (mapping != null) {
                moduleConfig.setActionMappingClass(mapping);
            }
            Digester digester = this.initConfigDigester();
            while (paths.length() > 0) {
                String path;
                digester.push((Object)moduleConfig);
                int comma = paths.indexOf(44);
                if (comma >= 0) {
                    path = paths.substring(0, comma).trim();
                    paths = paths.substring(comma + 1);
                } else {
                    path = paths.trim();
                    paths = "";
                }
                if (path.length() < 1) {
                    break;
                }
                URL url = this.getConfigResource(path);
                if (url != null) {
                    InputSource is = new InputSource(url.toExternalForm());
                    input = this.getConfigResourceAsStream(path);
                    is.setByteStream(input);
                    try {
                        digester.parse(is);
                        this.getServletContext().setAttribute("org.apache.struts.action.MODULE" + prefix, (Object)moduleConfig);
                    }
                    catch (Exception e) {
                        _log.error((Object)Bundle.getString((String)"PageFlow_Struts_ModuleParseError", (Object)path), (Throwable)e);
                    }
                    input.close();
                    continue;
                }
                if (prefix.equals("") && this.isAutoLoadModulePath(path, prefix)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("There is no root module at " + path + "; initializing a default module."));
                    }
                    moduleConfig.setControllerConfig((ControllerConfig)new MissingRootModuleControllerConfig());
                    continue;
                }
                _log.error((Object)Bundle.getString((String)"PageFlow_Struts_MissingModuleConfig", (Object)path));
            }
        }
        catch (Throwable t) {
            _log.error((Object)this.internal.getMessage("configParse", (Object)paths), t);
            throw new UnavailableException(this.internal.getMessage("configParse", (Object)paths));
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        FormBeanConfig[] fbs = moduleConfig.findFormBeanConfigs();
        for (int i = 0; i < fbs.length; ++i) {
            if (!fbs[i].getDynamic()) continue;
            DynaActionFormClass.createDynaActionFormClass((FormBeanConfig)fbs[i]);
        }
        if (prefix.length() < 1) {
            this.defaultControllerConfig(moduleConfig);
            this.defaultMessageResourcesConfig(moduleConfig);
        }
        return moduleConfig;
    }

    protected URL getConfigResource(String path) throws MalformedURLException {
        URL resource = this.getServletContext().getResource(path);
        if (resource != null) {
            return resource;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return Thread.currentThread().getContextClassLoader().getResource(path);
    }

    protected InputStream getConfigResourceAsStream(String path) {
        InputStream stream = this.getServletContext().getResourceAsStream(path);
        if (stream != null) {
            return stream;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    protected synchronized ModuleConfig registerModule(String modulePath, String configFilePath) throws ServletException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Dynamically registering module " + modulePath + ", config XML " + configFilePath));
        }
        if (_log.isInfoEnabled()) {
            StringBuilder msg = new StringBuilder("Dynamically registering module ").append(modulePath);
            _log.info((Object)msg.append(", config XML ").append(configFilePath).toString());
        }
        if (this._cachedConfigDigester == null) {
            this._cachedConfigDigester = this.initConfigDigester();
        }
        this.configDigester = this._cachedConfigDigester;
        ModuleConfig ac = this.initModuleConfig(modulePath, configFilePath);
        this.initModuleMessageResources(ac);
        this.initModuleDataSources(ac);
        this.initModulePlugIns(ac);
        ac.freeze();
        this.configDigester = null;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Finished registering module " + modulePath + ", config XML " + configFilePath));
        }
        return ac;
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletContext servletContext = this.getServletContext();
        this._contextCache.getReloadableClassHandler().reinit(request);
        String modulePath = PageFlowUtils.getModulePathForRelativeURI(InternalUtils.getDecodedServletPath(request));
        ModuleConfig registeredApp = this.getModuleConfig(modulePath, (ServletRequest)request, (ServletResponse)response);
        if (registeredApp != null) {
            RequestUtils.selectModule((String)modulePath, (HttpServletRequest)request, (ServletContext)servletContext);
            ModuleConfig appConfig = this.getModuleConfig(request);
            if (appConfig != null) {
                RequestProcessor requestProcessor = this.getRequestProcessor(appConfig);
                requestProcessor.init((ActionServlet)this, appConfig);
                requestProcessor.process(request, response);
            }
        } else {
            ModuleConfig moduleConfig = null;
            if (InternalUtils.getModuleConfig(RequestUtils.getModuleName((HttpServletRequest)request, (ServletContext)servletContext), servletContext) != null) {
                RequestUtils.selectModule((HttpServletRequest)request, (ServletContext)servletContext);
                moduleConfig = this.getModuleConfig(request);
            }
            if (moduleConfig != null) {
                this.getRequestProcessor(moduleConfig).process(request, response);
            } else {
                String relativeURI = InternalUtils.getDecodedServletPath(request);
                GlobalApp ga = FlowControllerFactory.getGlobalApp(request, response, servletContext);
                if (ga != null) {
                    StringBuilder sfActionURI = new StringBuilder(ga.getModulePath());
                    sfActionURI.append('/');
                    sfActionURI.append(ServletUtils.getBaseName((String)relativeURI));
                    RequestValues.setOriginalServletPath((ServletRequest)request, relativeURI);
                    ForwardRedirectHandler frh = this._contextCache.getForwardRedirectHandler();
                    frh.forward(sfActionURI.toString(), request, response);
                    return;
                }
                if (_log.isErrorEnabled()) {
                    StringBuilder msg = new StringBuilder("No module configuration registered for ");
                    msg.append(relativeURI).append(" (module path ").append(modulePath).append(").");
                    _log.error((Object)msg.toString());
                }
                InternalUtils.sendDevTimeError("PageFlow_NoModuleConf", null, 404, request, response, servletContext, relativeURI, modulePath);
            }
        }
    }

    protected Digester initConfigDigester() throws ServletException {
        this._cachedConfigDigester = super.initConfigDigester();
        return this._cachedConfigDigester;
    }

    public void destroy() {
        this._registeredModules.clear();
        super.destroy();
    }

    void ensureModuleSelected(String modulePath, HttpServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.getModuleConfig(modulePath, (ServletRequest)request, response) != null) {
            RequestUtils.selectModule((String)modulePath, (HttpServletRequest)request, (ServletContext)this.getServletContext());
        }
    }

    protected ModuleConfig getModuleConfig(String modulePath, ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this.ensureModuleRegistered(modulePath, request);
        ModuleConfig mc = this._registeredModules.get(modulePath);
        if (mc.getPrefix() == null) {
            assert (mc instanceof NonexistantModuleConfig) : mc.getClass().getName();
            mc = null;
        }
        return mc;
    }

    public ModuleConfig ensureModuleRegistered(String modulePath, ServletRequest request) throws IOException, ServletException {
        ModuleConfig ac = this._registeredModules.get(modulePath);
        if (ac == null) {
            String moduleConfPath;
            ac = (ModuleConfig)this.getServletContext().getAttribute("org.apache.struts.action.MODULE" + modulePath);
            if (ac == null && (moduleConfPath = this.getModuleConfPath(modulePath)) != null) {
                ac = this.registerModule(modulePath, moduleConfPath);
            }
            if (ac == null) {
                this._registeredModules.put(modulePath, NONEXISTANT_MODULE_CONFIG);
            } else {
                this._registeredModules.put(modulePath, ac);
            }
        }
        return ac;
    }

    private void defaultControllerConfig(ModuleConfig config) {
        String value = null;
        ControllerConfig cc = config.getControllerConfig();
        value = this.getServletConfig().getInitParameter("bufferSize");
        if (value != null) {
            cc.setBufferSize(Integer.parseInt(value));
        }
        if ((value = this.getServletConfig().getInitParameter("content")) != null) {
            cc.setContentType(value);
        }
        if ((value = this.getServletConfig().getInitParameter("locale")) != null) {
            if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) {
                cc.setLocale(true);
            } else {
                cc.setLocale(false);
            }
        }
        if ((value = this.getServletConfig().getInitParameter("maxFileSize")) != null) {
            cc.setMaxFileSize(value);
        }
        if ((value = this.getServletConfig().getInitParameter("nocache")) != null) {
            if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) {
                cc.setNocache(true);
            } else {
                cc.setNocache(false);
            }
        }
        if ((value = this.getServletConfig().getInitParameter("multipartClass")) != null) {
            cc.setMultipartClass(value);
        }
        if ((value = this.getServletConfig().getInitParameter("tempDir")) != null) {
            cc.setTempDir(value);
        }
    }

    private void defaultMessageResourcesConfig(ModuleConfig config) {
        String value = null;
        MessageResourcesConfig mrc = config.findMessageResourcesConfig("org.apache.struts.action.MESSAGE");
        if (mrc == null) {
            mrc = new MessageResourcesConfig();
            mrc.setKey("org.apache.struts.action.MESSAGE");
            config.addMessageResourcesConfig(mrc);
        }
        if ((value = this.getServletConfig().getInitParameter("application")) != null) {
            mrc.setParameter(value);
        }
        if ((value = this.getServletConfig().getInitParameter("factory")) != null) {
            mrc.setFactory(value);
        }
        if ((value = this.getServletConfig().getInitParameter("null")) != null) {
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
                mrc.setNull(true);
            } else {
                mrc.setNull(false);
            }
        }
    }

    public void clearRegisteredModules() {
        ServletContext servletContext = this.getServletContext();
        for (String modulePrefix : this._registeredModules.keySet()) {
            servletContext.removeAttribute("org.apache.struts.action.MODULE" + modulePrefix);
        }
        this._registeredModules.clear();
    }

    private static class NonexistantModuleConfig
    extends ModuleConfigImpl {
        public NonexistantModuleConfig() {
            super((String)null);
        }
    }

    static class MissingRootModuleControllerConfig
    extends ControllerConfig {
        public MissingRootModuleControllerConfig() {
            this.setProcessorClass(PageFlowRequestProcessor.class.getName());
        }
    }

    public static interface ModuleConfigLocator {
        public String getModuleConfigPath(String var1);
    }
}

