/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.pageflow.AutoRegisterActionServlet;
import org.apache.beehive.netui.pageflow.GlobalApp;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.PageFlowStack;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.SharedFlowController;
import org.apache.beehive.netui.pageflow.config.PageFlowControllerConfig;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.util.config.ConfigUtil;
import org.apache.beehive.netui.util.config.bean.PageflowConfig;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.ModuleConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowControllerFactory {
    private static final Logger _log = Logger.getInstance(FlowControllerFactory.class);

    public static PageFlowController getPageFlowForRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        return FlowControllerFactory.getPageFlowForRelativeURI(request, response, InternalUtils.getDecodedServletPath(request), servletContext);
    }

    public static PageFlowController getPageFlowForURI(HttpServletRequest request, HttpServletResponse response, String uri, ServletContext servletContext) {
        return FlowControllerFactory.getPageFlowForRelativeURI(request, response, PageFlowUtils.getRelativeURI(request, uri, null), servletContext);
    }

    public static PageFlowController getPageFlowForRelativeURI(HttpServletRequest request, HttpServletResponse response, String relativeURI, ServletContext servletContext) {
        PageFlowController cur = PageFlowUtils.getCurrentPageFlow(request);
        String parentDir = PageFlowUtils.getModulePathForRelativeURI(relativeURI);
        if (cur == null || !PageFlowUtils.getModulePathForRelativeURI(cur.getURI()).equals(parentDir)) {
            String jpfClassName = InternalUtils.getFlowControllerClassName(parentDir, (ServletRequest)request, servletContext);
            return jpfClassName != null ? FlowControllerFactory.getPageFlow(jpfClassName, request, response, servletContext) : null;
        }
        cur.reinitialize(request, response, servletContext);
        return cur;
    }

    public static Map<String, SharedFlowController> getSharedFlowsForRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        String relativeURI = InternalUtils.getDecodedServletPath(request);
        return FlowControllerFactory.getSharedFlowsForRelativeURI(request, response, relativeURI, servletContext);
    }

    public static Map<String, SharedFlowController> getSharedFlowsForRelativeURI(HttpServletRequest request, HttpServletResponse response, String relativeURI, ServletContext servletContext) {
        Map<String, String> sharedFlowTypes;
        ControllerConfig cc;
        String parentDir = PageFlowUtils.getModulePathForRelativeURI(relativeURI);
        ModuleConfig mc = InternalUtils.ensureModuleConfig(parentDir, (ServletRequest)request, servletContext);
        if (mc != null && (cc = mc.getControllerConfig()) instanceof PageFlowControllerConfig && (sharedFlowTypes = ((PageFlowControllerConfig)cc).getSharedFlowTypes()) != null && sharedFlowTypes.size() > 0) {
            LinkedHashMap<String, SharedFlowController> sharedFlows = new LinkedHashMap<String, SharedFlowController>();
            for (Map.Entry<String, String> entry : sharedFlowTypes.entrySet()) {
                String name = entry.getKey();
                String className = entry.getValue();
                SharedFlowController sf = PageFlowUtils.getSharedFlow(className, request);
                if (sf != null) {
                    sf.reinitialize(request, response, servletContext);
                } else {
                    try {
                        sf = FlowControllerFactory.getSharedFlow(className, request, response, servletContext);
                    }
                    catch (ClassNotFoundException e) {
                        _log.error((Object)("Requested shared flow class " + className + " not found."));
                    }
                }
                if (sf == null || sf instanceof GlobalApp) continue;
                sharedFlows.put(name, sf);
            }
            return sharedFlows;
        }
        GlobalApp ga = PageFlowUtils.getGlobalApp(request);
        if (ga != null) {
            ga.reinitialize(request, response, servletContext);
        } else {
            FlowControllerFactory.getGlobalApp(request, response, servletContext);
        }
        return null;
    }

    public static PageFlowController getPageFlow(String jpfClassName, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        try {
            Class jpfClass = InternalUtils.getReloadableClass(jpfClassName, request, servletContext);
            return FlowControllerFactory.getPageFlow(jpfClass, request, response, servletContext);
        }
        catch (ClassNotFoundException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)("Requested page flow class " + jpfClassName + " not found."));
            }
            return null;
        }
    }

    public static GlobalApp getGlobalApp(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        GlobalApp current = PageFlowUtils.getGlobalApp(request);
        if (current != null) {
            return current;
        }
        try {
            SharedFlowController sf = FlowControllerFactory.getSharedFlow("global.Global", request, response, servletContext);
            if (!(sf instanceof GlobalApp)) {
                _log.error((Object)("Class global.Global is not an instance of " + GlobalApp.class.getName()));
                return null;
            }
            return (GlobalApp)sf;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static SharedFlowController getSharedFlow(String sharedFlowClassName, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ClassNotFoundException {
        Class sfClass = InternalUtils.getReloadableClass(sharedFlowClassName, request, servletContext);
        return FlowControllerFactory.getSharedFlow(sfClass, request, response, servletContext);
    }

    private static ModuleConfig ensureModule(String modulePath, HttpServletRequest request, ServletContext servletContext) {
        ActionServlet as;
        ModuleConfig mc = InternalUtils.getModuleConfig(modulePath, servletContext);
        if (mc == null && (as = InternalUtils.getActionServlet(servletContext)) instanceof AutoRegisterActionServlet) {
            AutoRegisterActionServlet das = (AutoRegisterActionServlet)as;
            try {
                mc = das.ensureModuleRegistered(modulePath, (ServletRequest)request);
            }
            catch (IOException e) {
                _log.error((Object)("Could not register Struts module for path " + modulePath), (Throwable)e);
            }
            catch (ServletException e) {
                _log.error((Object)("Could not register Struts module for path " + modulePath), e.getRootCause());
            }
        }
        return mc;
    }

    public static PageFlowController getPageFlow(Class jpfClass, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        if (!PageFlowController.class.isAssignableFrom(jpfClass)) {
            return null;
        }
        try {
            int lastIndexOfJpfClass;
            PageflowConfig options;
            PageFlowController retVal = null;
            String modulePath = InternalUtils.inferModulePathFromClassName(jpfClass.getName());
            ModuleConfig mc = FlowControllerFactory.ensureModule(modulePath, request, servletContext);
            if (mc == null) {
                _log.error((Object)("Struts module " + modulePath + " not found for " + jpfClass.getName() + "; cannot create page flow."));
                return null;
            }
            if (InternalUtils.isLongLived(mc)) {
                retVal = PageFlowUtils.getLongLivedPageFlow(modulePath, request);
                if (_log.isDebugEnabled() && retVal != null) {
                    _log.debug((Object)("Using long lived PageFlowController of type " + jpfClass.getName()));
                }
            }
            boolean createdNew = false;
            boolean isNestable = InternalUtils.isNestable(mc);
            PageFlowStack pfStack = PageFlowStack.get(request, false);
            if (isNestable && pfStack != null && ((options = ConfigUtil.getConfig().getPageflowConfig()) == null || !options.getEnableRenesting()) && (lastIndexOfJpfClass = pfStack.lastIndexOf(request, jpfClass)) != -1) {
                retVal = pfStack.popUntil(request, lastIndexOfJpfClass);
                retVal.persistInSession(request, response);
                return retVal;
            }
            if (retVal == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Creating PageFlowController of type " + jpfClass.getName()));
                }
                retVal = (PageFlowController)jpfClass.newInstance();
                createdNew = true;
            }
            if (isNestable) {
                retVal.create(request, response, servletContext);
                PageFlowController current = PageFlowUtils.getCurrentPageFlow(request);
                if (current != null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Pushing PageFlowController " + current + " onto the nesting stack"));
                    }
                    if (pfStack == null) {
                        pfStack = PageFlowStack.get(request, true);
                    }
                    pfStack.push(current, request);
                }
                retVal.persistInSession(request, response);
            } else if (pfStack != null) {
                PageFlowController onStackAlready;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Destroying the PageFlowController stack.");
                }
                if ((onStackAlready = pfStack.popUntil(request, retVal.getClass())) != null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Found a page flow of type " + retVal.getClass() + " in the stack; " + "using that instance and stopping destruction of the nesting stack."));
                    }
                    retVal = onStackAlready;
                    retVal.persistInSession(request, response);
                } else {
                    retVal.reinitialize(request, response, servletContext);
                    retVal.persistInSession(request, response);
                    retVal.create(request, response, servletContext);
                }
            } else {
                retVal.reinitialize(request, response, servletContext);
                retVal.persistInSession(request, response);
                if (createdNew) {
                    retVal.create(request, response, servletContext);
                }
            }
            return retVal;
        }
        catch (InstantiationException e) {
            _log.error((Object)("Could not instantiate PageFlowController of type " + jpfClass.getName()), (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            _log.error((Object)("Could not instantiate PageFlowController of type " + jpfClass.getName()), (Throwable)e);
            return null;
        }
    }

    public static SharedFlowController getSharedFlow(Class sfClass, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        assert (SharedFlowController.class.isAssignableFrom(sfClass)) : sfClass.getName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Creating SharedFlowController of type " + sfClass.getName()));
        }
        try {
            SharedFlowController retVal = (SharedFlowController)sfClass.newInstance();
            retVal.create(request, response, servletContext);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Storing " + retVal + " in the session..."));
            }
            retVal.persistInSession(request, response);
            return retVal;
        }
        catch (InstantiationException e) {
            _log.error((Object)("Could not instantiate SharedFlowController of type " + sfClass.getName()), (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            _log.error((Object)("Could not instantiate SharedFlowController of type " + sfClass.getName()), (Throwable)e);
            return null;
        }
    }
}

