/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.beehive.netui.pageflow.FlowController;
import org.apache.beehive.netui.pageflow.IllegalActionOutputException;
import org.apache.beehive.netui.pageflow.IllegalOutputFormTypeException;
import org.apache.beehive.netui.pageflow.IllegalRedirectOutputFormException;
import org.apache.beehive.netui.pageflow.MismatchedActionOutputException;
import org.apache.beehive.netui.pageflow.MissingActionOutputException;
import org.apache.beehive.netui.pageflow.PageFlowException;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.UnresolvableForwardException;
import org.apache.beehive.netui.pageflow.config.PageFlowActionForward;
import org.apache.beehive.netui.pageflow.handler.ReloadableClassHandler;
import org.apache.beehive.netui.pageflow.internal.ContextCache;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.internal.ServerAdapterManager;
import org.apache.beehive.netui.util.FileUtils;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ModuleConfig;

public class Forward
extends ActionForward {
    public static final int RETURN_TO_NONE = 0;
    public static final int RETURN_TO_CURRENT_PAGE = 1;
    public static final int RETURN_TO_PREVIOUS_PAGE = 2;
    public static final int RETURN_TO_PREVIOUS_ACTION = 3;
    static final int RETURN_TO_PAGE_INTERNAL = -1;
    static final int RETURN_TO_ACTION_INTERNAL = -2;
    public static final int RETURN_TO_PAGE = -1;
    public static final int RETURN_TO_ACTION = -2;
    private static final Logger _log = Logger.getInstance(Forward.class);
    private static final String RETURN_TO_CURRENT_PAGE_STR = "currentPage";
    private static final String RETURN_TO_PREVIOUS_PAGE_STR = "previousPage";
    private static final String RETURN_TO_PAGE_LEGACY_STR = "page";
    private static final String RETURN_TO_PREVIOUS_ACTION_STR = "previousAction";
    private static final String RETURN_TO_ACTION_LEGACY_STR = "action";
    private static final Map<String, Class> PRIMITIVE_TYPES = new HashMap<String, Class>();
    private List _outputForms;
    private String _path;
    private boolean _isNestedReturn = false;
    private boolean _init = false;
    private transient ActionMapping _mapping = null;
    private transient FlowController _flowController = null;
    private transient ServletContext _servletContext = null;
    private String _mappingPath;
    private StringBuilder _queryString;
    private boolean _explicitPath = false;
    private String _returnFormType = null;
    private boolean _userSetRedirect = false;
    private Map _actionOutputs = null;
    private int _returnToType;
    private boolean _hasExplicitRedirectValue = false;
    private boolean _restoreQueryString = false;
    private boolean _externalRedirect = false;
    private ModuleConfig _altModuleConfig;

    protected Forward(Forward init) {
        this._outputForms = init._outputForms;
        this._init = init._init;
        this._mapping = init._mapping;
        this._mappingPath = init._mappingPath;
        this._queryString = init._queryString;
        this._explicitPath = init._explicitPath;
        this._flowController = init._flowController;
        this._servletContext = init._servletContext;
        this._returnFormType = init._returnFormType;
        this._userSetRedirect = init._userSetRedirect;
        this._actionOutputs = init._actionOutputs;
        this._returnToType = init._returnToType;
        this._restoreQueryString = init._restoreQueryString;
        this._externalRedirect = init._externalRedirect;
    }

    protected Forward(HttpServletRequest request) {
        this.setPath(PageFlowUtils.getRelativeURI(request, null));
        this.setContextRelative(true);
        this._explicitPath = true;
    }

    public Forward(String forwardName) {
        this.setName(forwardName);
    }

    public Forward(String forwardName, Object outputFormBean) {
        this(forwardName);
        if (outputFormBean != null) {
            this.addOutputForm(outputFormBean);
        }
    }

    public Forward(String forwardName, String actionOutputName, Object actionOutputValue) {
        this(forwardName);
        this.addActionOutput(actionOutputName, actionOutputValue);
    }

    public Forward(URI path) {
        this(path, false);
    }

    public Forward(URI path, boolean redirect) {
        this.setPath(path.toString());
        super.setRedirect(redirect || path.isAbsolute());
        this.setContextRelative(path.getPath().startsWith("/"));
        this._explicitPath = true;
    }

    public Forward(URL path) {
        this.setPath(path.toString());
        super.setRedirect(true);
        this._explicitPath = true;
    }

    protected Forward(ActionForward initFwd, ServletContext servletContext) {
        this._servletContext = servletContext;
        this.setName(initFwd.getName());
        this.initFrom(initFwd);
    }

    public void setRedirect(boolean redirect) {
        super.setRedirect(redirect);
        this._userSetRedirect = true;
    }

    public boolean isRedirect() {
        return super.getRedirect();
    }

    public final void addOutputForm(Object formBean) {
        assert (formBean != null) : "The output form bean may not me null.";
        if (formBean == null) {
            throw new IllegalArgumentException("The output form bean may not be null.");
        }
        if (this._outputForms == null) {
            this._outputForms = new ArrayList();
        }
        if (this._init && this.getRedirect()) {
            String actionPath = this._mappingPath != null ? this._mappingPath : "";
            String descrip = this.getName() != null ? this.getName() : this.getPath();
            IllegalRedirectOutputFormException ex = new IllegalRedirectOutputFormException(descrip, actionPath, this._flowController, formBean.getClass().getName());
            InternalUtils.throwPageFlowException(ex);
        }
        this._outputForms.add(InternalUtils.wrapFormBean(formBean));
    }

    public final ActionForm[] getOutputForms() {
        if (this._outputForms == null) {
            return new ActionForm[0];
        }
        return this._outputForms.toArray(new ActionForm[0]);
    }

    final ActionForm getFirstOutputForm(HttpServletRequest request) {
        if (this._outputForms == null || this._outputForms.size() == 0) {
            if (this._returnFormType != null) {
                try {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Creating form bean of type " + this._returnFormType));
                    }
                    ServletContext servletContext = InternalUtils.getServletContext(request);
                    ReloadableClassHandler rch = ContextCache.get(servletContext).getReloadableClassHandler();
                    Object formBean = rch.newInstance(this._returnFormType);
                    ActionForm wrappedFormBean = InternalUtils.wrapFormBean(formBean);
                    this.addOutputForm(wrappedFormBean);
                    return wrappedFormBean;
                }
                catch (Exception e) {
                    _log.error((Object)("Could not create form bean instance of " + this._returnFormType), (Throwable)e);
                }
            }
            return null;
        }
        return (ActionForm)this._outputForms.get(0);
    }

    public boolean doesResolve() {
        if (this._explicitPath) {
            return true;
        }
        assert (this._mapping != null || this._altModuleConfig != null) : "PageFlow.Forward.doesResolve() called outside of request";
        return this.findForward(this.getName()) != null;
    }

    protected ActionForward findForward(String forwardName) {
        ActionForward fwd;
        ActionForward actionForward = fwd = this._mapping != null ? this._mapping.findForward(forwardName) : null;
        if (fwd != null) {
            return fwd;
        }
        if (this._altModuleConfig != null) {
            return (ActionForward)this._altModuleConfig.findForwardConfig(forwardName);
        }
        return null;
    }

    void setAltModuleConfig(ModuleConfig mc) {
        this._altModuleConfig = mc;
    }

    private final void init() {
        if (!this._init) {
            PageFlowException ex;
            if (this._mappingPath == null && this._altModuleConfig == null) {
                throw new IllegalStateException("Forward is not initialized.  Use initialize().");
            }
            ActionForward fwd = this.findForward(this.getName());
            if (fwd == null) {
                ex = new UnresolvableForwardException(this.getName(), this._mappingPath, this._flowController);
                InternalUtils.throwPageFlowException(ex);
            }
            this.initFrom(fwd);
            if (this.getRedirect()) {
                if (this._actionOutputs != null && !this._actionOutputs.isEmpty()) {
                    ex = new IllegalActionOutputException(this.getName(), this._mappingPath, this._flowController, (String)this._actionOutputs.keySet().iterator().next());
                    InternalUtils.throwPageFlowException(ex);
                }
                if (this._outputForms != null && !this._outputForms.isEmpty()) {
                    ex = new IllegalRedirectOutputFormException(this.getName(), this._mappingPath, this._flowController, this._outputForms.get(0).getClass().getName());
                    InternalUtils.throwPageFlowException(ex);
                }
            }
        }
    }

    private void initFrom(ActionForward fwd) {
        this._path = fwd.getPath();
        if (!this._userSetRedirect) {
            this.setRedirect(fwd.getRedirect());
        }
        this.setContextRelative(fwd.getContextRelative());
        if (this._queryString != null) {
            this._path = this._path + this._queryString.toString();
        }
        if (fwd instanceof PageFlowActionForward) {
            Object outputForm;
            Class<?> returnFormClass;
            PageFlowActionForward fc;
            block30: {
                String retFormMember;
                block29: {
                    fc = (PageFlowActionForward)fwd;
                    this._isNestedReturn = fc.isNestedReturn();
                    this._returnFormType = fc.getReturnFormType();
                    this._hasExplicitRedirectValue = fc.hasExplicitRedirectValue();
                    this._restoreQueryString = fc.isRestoreQueryString();
                    this._externalRedirect = fc.isExternalRedirect();
                    returnFormClass = null;
                    if (this._returnFormType != null) {
                        try {
                            returnFormClass = Class.forName(this._returnFormType);
                        }
                        catch (ClassNotFoundException e) {
                            if ($assertionsDisabled) break block29;
                            throw new AssertionError((Object)e);
                        }
                    }
                }
                if (fc.isReturnToPage() || fc.isReturnToAction()) {
                    String path = fc.getPath();
                    if (path.equals(RETURN_TO_PREVIOUS_PAGE_STR)) {
                        this._returnToType = 2;
                    } else if (path.equals(RETURN_TO_CURRENT_PAGE_STR)) {
                        this._returnToType = 1;
                    } else if (path.equals(RETURN_TO_PAGE_LEGACY_STR)) {
                        this._returnToType = -1;
                    } else if (path.equals(RETURN_TO_PREVIOUS_ACTION_STR)) {
                        this._returnToType = 3;
                    } else if (path.equals(RETURN_TO_ACTION_LEGACY_STR)) {
                        this._returnToType = -2;
                    } else {
                        assert (false) : "invalid return-to type for forward " + fc.getName() + ": " + path;
                        this._returnToType = 1;
                    }
                }
                if ((retFormMember = fc.getReturnFormMember()) != null) {
                    try {
                        assert (this._flowController != null);
                        Field field = this._flowController.getClass().getDeclaredField(retFormMember);
                        returnFormClass = field.getType();
                        field.setAccessible(true);
                        ActionForm form = InternalUtils.wrapFormBean(field.get(this._flowController));
                        if (form != null) {
                            if (_log.isDebugEnabled()) {
                                _log.debug((Object)("using member " + retFormMember + " for Forward " + this.getName()));
                            }
                            this.addOutputForm(form);
                        } else if (_log.isInfoEnabled()) {
                            _log.info((Object)("returnFormMember " + retFormMember + " was null."));
                        }
                    }
                    catch (NoSuchFieldException e) {
                        assert (false) : "could not find field " + retFormMember;
                    }
                    catch (IllegalAccessException e) {
                        if ($assertionsDisabled) break block30;
                        throw new AssertionError();
                    }
                }
            }
            if (returnFormClass != null && this._outputForms != null && this._outputForms.size() > 0 && !returnFormClass.isInstance(outputForm = InternalUtils.unwrapFormBean((ActionForm)this._outputForms.get(0)))) {
                IllegalOutputFormTypeException ex = new IllegalOutputFormTypeException(this.getName(), this._mappingPath, this._flowController, outputForm.getClass().getName(), returnFormClass.getName());
                InternalUtils.throwPageFlowException(ex);
            }
            this.checkActionOutputs(fc);
        }
        this._init = true;
    }

    private void checkActionOutputs(PageFlowActionForward fc) {
        PageFlowActionForward.ActionOutput[] actionOutputs = fc.getActionOutputs();
        boolean isInProductionMode = ServerAdapterManager.getServerAdapter(this._servletContext).isInProductionMode();
        for (int i = 0; i < actionOutputs.length; ++i) {
            Object actualActionOutput;
            PageFlowActionForward.ActionOutput actionOutput = actionOutputs[i];
            if (!(actionOutput.getNullable() || this._actionOutputs != null && this._actionOutputs.get(actionOutput.getName()) != null)) {
                MissingActionOutputException ex = new MissingActionOutputException(this._mappingPath, this._flowController, actionOutput.getName(), this.getName());
                InternalUtils.throwPageFlowException(ex);
            }
            if (isInProductionMode || this._actionOutputs == null || (actualActionOutput = this._actionOutputs.get(actionOutput.getName())) == null) continue;
            String expectedTypeName = actionOutput.getType();
            int expectedArrayDims = 0;
            while (expectedTypeName.endsWith("[]")) {
                ++expectedArrayDims;
                expectedTypeName = expectedTypeName.substring(0, expectedTypeName.length() - 2);
            }
            Class<?> expectedType = PRIMITIVE_TYPES.get(expectedTypeName);
            if (expectedType == null) {
                try {
                    expectedType = Class.forName(expectedTypeName);
                }
                catch (ClassNotFoundException e) {
                    _log.error((Object)("Could not load expected action output type " + expectedTypeName + " for action output '" + actionOutput.getName() + "' on forward '" + fc.getName() + "'; skipping type check."));
                    continue;
                }
            }
            Class<?> actualType = actualActionOutput.getClass();
            int actualArrayDims = 0;
            StringBuilder arraySuffix = new StringBuilder();
            while (actualType.isArray() && actualArrayDims <= expectedArrayDims) {
                ++actualArrayDims;
                arraySuffix.append("[]");
                actualType = actualType.getComponentType();
            }
            if (actualArrayDims == expectedArrayDims && expectedType.isAssignableFrom(actualType)) continue;
            MismatchedActionOutputException ex = new MismatchedActionOutputException(this._mappingPath, this._flowController, actionOutput.getName(), this.getName(), expectedTypeName, actualType.getName() + arraySuffix);
            InternalUtils.throwPageFlowException(ex);
        }
    }

    public void initialize(ActionMapping mapping, FlowController flowController) {
        this._mapping = mapping;
        this._mappingPath = mapping != null ? mapping.getPath() : null;
        this._flowController = flowController;
        this._servletContext = flowController.getServletContext();
    }

    public void initialize(ActionMapping mapping, FlowController flowController, HttpServletRequest request) {
        this._mapping = mapping;
        this._mappingPath = mapping != null ? mapping.getPath() : null;
        this._flowController = flowController;
        this._servletContext = flowController.getServletContext();
    }

    public void setPath(String path) {
        this._path = path;
        this._init = true;
    }

    boolean isExplicitPath() {
        return this._explicitPath;
    }

    boolean hasExplicitRedirectValue() {
        return this._hasExplicitRedirectValue;
    }

    public String getPath() {
        this.init();
        return this._path;
    }

    public boolean isNestedReturn() {
        this.init();
        return this._isNestedReturn;
    }

    public boolean isReturnToPage() {
        this.init();
        return this._returnToType == 2 || this._returnToType == 1 || this._returnToType == -1;
    }

    public boolean isReturnToAction() {
        this.init();
        return this._returnToType == 3 || this._returnToType == -2;
    }

    public boolean isExternalRedirect() {
        return this._externalRedirect;
    }

    public void setExternalRedirect(boolean externalRedirect) {
        this._externalRedirect = externalRedirect;
    }

    boolean restoreQueryString() {
        this.init();
        return this._restoreQueryString;
    }

    boolean shouldPopPageFlow() {
        this.init();
        return this._isNestedReturn;
    }

    public boolean forwardsToPageFlow() {
        return FileUtils.osSensitiveEndsWith((String)this.getPath(), (String)".jpf");
    }

    public void setQueryString(String queryString) {
        this._queryString = queryString == null ? null : (queryString.startsWith("?") ? new StringBuilder(queryString) : new StringBuilder("?").append(queryString));
    }

    public String getQueryString() {
        return this._queryString != null ? this._queryString.toString() : null;
    }

    public void addQueryParam(String name, String value) {
        if (this._queryString == null) {
            this._queryString = new StringBuilder("?");
        } else {
            this._queryString.append('&');
        }
        this._queryString.append(name);
        if (value != null) {
            this._queryString.append('=').append(value);
        }
    }

    public final void addQueryParam(String name) {
        this.addQueryParam(name, null);
    }

    public void addPageInput(String name, Object value) {
        this.addActionOutput(name, value);
    }

    public void addActionOutput(String name, Object value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("An action output name may not be null or empty.");
        }
        if (this._actionOutputs == null) {
            this._actionOutputs = new HashMap();
        }
        if (this._init && this.getRedirect()) {
            String actionPath = this._mappingPath != null ? this._mappingPath : "";
            String descrip = this.getName() != null ? this.getName() : this.getPath();
            IllegalActionOutputException ex = new IllegalActionOutputException(descrip, actionPath, this._flowController, name);
            InternalUtils.throwPageFlowException(ex);
        }
        this._actionOutputs.put(name, value);
    }

    public Map getPageInputs() {
        return this.getActionOutputs();
    }

    public Map getActionOutputs() {
        return this._actionOutputs;
    }

    public int getReturnToType() {
        return this._returnToType;
    }

    public String getReturnToTypeAsString() {
        switch (this._returnToType) {
            case 1: {
                return RETURN_TO_CURRENT_PAGE_STR;
            }
            case 2: {
                return RETURN_TO_PREVIOUS_PAGE_STR;
            }
            case -1: {
                return RETURN_TO_PAGE_LEGACY_STR;
            }
            case 3: {
                return RETURN_TO_PREVIOUS_ACTION_STR;
            }
            case -2: {
                return RETURN_TO_ACTION_LEGACY_STR;
            }
        }
        return null;
    }

    void reinitialize(FlowController fc) {
        this._flowController = fc;
        this._servletContext = fc.getServletContext();
        if (this._mapping == null && this._mappingPath != null) {
            ModuleConfig mc = fc.getModuleConfig();
            assert (mc != null) : "no ModuleConfig found for " + fc.getClass().getName();
            this._mapping = (ActionMapping)mc.findActionConfig(this._mappingPath);
        }
    }

    static {
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
    }
}

