/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.pageflow.EmptyNestingStackException;
import org.apache.beehive.netui.pageflow.FlowController;
import org.apache.beehive.netui.pageflow.Forward;
import org.apache.beehive.netui.pageflow.NoCurrentPageFlowException;
import org.apache.beehive.netui.pageflow.NoPreviousActionException;
import org.apache.beehive.netui.pageflow.NoPreviousPageException;
import org.apache.beehive.netui.pageflow.PageFlowConstants;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.PageFlowStack;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.PreviousActionInfo;
import org.apache.beehive.netui.pageflow.PreviousPageInfo;
import org.apache.beehive.netui.pageflow.UnresolvableForwardException;
import org.apache.beehive.netui.pageflow.interceptor.ActionInterceptor;
import org.apache.beehive.netui.pageflow.interceptor.ActionInterceptorChain;
import org.apache.beehive.netui.pageflow.interceptor.InterceptorForward;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.internal.RequestValues;
import org.apache.beehive.netui.pageflow.internal.ViewRenderer;
import org.apache.beehive.netui.script.common.ImplicitObjectUtil;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ModuleConfig;

class ForwardHandler
implements PageFlowConstants {
    private static final Logger _log = Logger.getInstance(ForwardHandler.class);

    ForwardHandler() {
    }

    static ActionForward forwardTo(ActionForward fwd, ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, String actionName, ModuleConfig altModuleConfig, ActionForm form, ServletContext servletContext, FlowController flowController) {
        boolean isSpecialForward = false;
        boolean isReturnToCurrentPage = false;
        if (fwd != null && "_auto".equals(fwd.getName())) {
            return ForwardHandler.doAutoViewRender(mapping, request, response, servletContext, flowController, form);
        }
        if (fwd != null && fwd instanceof Forward) {
            Forward pageFlowFwd = (Forward)fwd;
            pageFlowFwd.initialize(mapping, flowController, request);
            pageFlowFwd.setAltModuleConfig(altModuleConfig);
            if (!pageFlowFwd.doesResolve()) {
                UnresolvableForwardException ex = new UnresolvableForwardException(pageFlowFwd.getName(), actionName, flowController);
                InternalUtils.throwPageFlowException(ex, request);
            }
            if (pageFlowFwd.isReturnToPage()) {
                PreviousPageInfo prevPageInfo;
                isSpecialForward = true;
                PageFlowController curJpf = PageFlowUtils.getCurrentPageFlow(request);
                if (curJpf == null) {
                    NoCurrentPageFlowException ex = new NoCurrentPageFlowException(actionName, pageFlowFwd);
                    InternalUtils.throwPageFlowException(ex, request);
                    assert (false);
                }
                switch (pageFlowFwd.getReturnToType()) {
                    case 1: {
                        prevPageInfo = curJpf.getCurrentPageInfo();
                        isReturnToCurrentPage = true;
                        break;
                    }
                    case 2: {
                        prevPageInfo = curJpf.getPreviousPageInfo();
                        break;
                    }
                    case -1: {
                        prevPageInfo = flowController.getPreviousPageInfoLegacy(curJpf, request);
                        break;
                    }
                    default: {
                        assert (false) : pageFlowFwd.getReturnToType();
                        prevPageInfo = curJpf.getCurrentPageInfo();
                    }
                }
                fwd = ForwardHandler.doReturnToPage(request, prevPageInfo, curJpf, form, actionName, pageFlowFwd, flowController);
                if (prevPageInfo != null) {
                    mapping = prevPageInfo.getMapping();
                    if (form == null) {
                        form = prevPageInfo.getForm();
                    }
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("return-to-page: " + (fwd != null ? fwd.getPath() : "[null]")));
                }
            } else if (pageFlowFwd.isReturnToAction()) {
                isSpecialForward = true;
                fwd = ForwardHandler.doReturnToAction(request, actionName, pageFlowFwd);
            }
            if (pageFlowFwd.shouldPopPageFlow()) {
                isSpecialForward = true;
                fwd = ForwardHandler.doNestingReturn(pageFlowFwd, request, response, mapping, flowController, form);
            }
            PageFlowUtils.setOutputForms(mapping, pageFlowFwd, request);
            InternalUtils.addActionOutputs(pageFlowFwd.getActionOutputs(), (ServletRequest)request, true);
        }
        if (fwd != null) {
            if (_log.isDebugEnabled()) {
                if (fwd.getRedirect()) {
                    _log.debug((Object)("Redirecting to " + fwd.getPath()));
                } else {
                    _log.debug((Object)("Forwarding to " + fwd.getPath()));
                }
            }
        } else {
            _log.debug((Object)"null ActionForward -- not doing any forward or redirect.");
        }
        if (!isReturnToCurrentPage) {
            flowController.savePreviousPageInfo(fwd, form, mapping, request, servletContext, isSpecialForward);
        }
        return fwd;
    }

    private static ActionForward doAutoViewRender(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, FlowController flowController, ActionForm form) {
        ViewRenderer vr = RequestValues.getViewRenderer((ServletRequest)request);
        if (vr != null) {
            _log.debug((Object)("null ActionForward -- delegating to ViewRenderer " + vr + " to handle response."));
            try {
                vr.renderView((ServletRequest)request, (ServletResponse)response, servletContext);
            }
            catch (Throwable th) {
                try {
                    return flowController.handleException(th, mapping, form, request, response);
                }
                catch (Exception e) {
                    _log.error((Object)("Exception thrown while handling exception in ViewRenderer " + vr + ": " + e.getMessage()), th);
                }
            }
        } else {
            _log.debug((Object)"No ViewRenderer -- not doing any forward or redirect.");
        }
        return null;
    }

    private static ActionForward doReturnToPage(HttpServletRequest request, PreviousPageInfo prevPageInfo, PageFlowController currentPageFlow, ActionForm currentForm, String actionName, Forward pageFlowFwd, FlowController flowController) {
        if (prevPageInfo == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Attempted return-to-page, but previous page info was missing.");
            }
            NoPreviousPageException ex = new NoPreviousPageException(actionName, pageFlowFwd, currentPageFlow);
            InternalUtils.throwPageFlowException(ex, request);
        }
        ActionForward retFwd = prevPageInfo.getForward();
        ActionMapping prevMapping = prevPageInfo.getMapping();
        if (retFwd instanceof Forward) {
            PageFlowUtils.setOutputForms(prevMapping, (Forward)retFwd, request, false);
            InternalUtils.addActionOutputs(((Forward)retFwd).getActionOutputs(), (ServletRequest)request, false);
        }
        if (prevMapping != null) {
            if (currentForm != null) {
                PageFlowUtils.setOutputForm(prevMapping, currentForm, request, false);
            }
            InternalUtils.setFormInScope(prevMapping.getName(), prevPageInfo.getForm(), prevMapping, request, false);
        }
        if (!retFwd.getContextRelative() && flowController != currentPageFlow) {
            retFwd = new ActionForward(retFwd.getName(), currentPageFlow.getModulePath() + retFwd.getPath(), retFwd.getRedirect(), true);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Return-to-page in PageFlowController " + flowController.getClass().getName() + ": original URI " + retFwd.getPath()));
        }
        if (retFwd != null) {
            if (pageFlowFwd.hasExplicitRedirectValue()) {
                retFwd.setRedirect(pageFlowFwd.getRedirect());
            }
            String fwdPath = retFwd.getPath();
            String newQueryString = pageFlowFwd.getQueryString();
            if (newQueryString != null) {
                int existingQuery = fwdPath.indexOf(63);
                if (existingQuery != -1) {
                    retFwd.setPath(fwdPath.substring(0, existingQuery) + newQueryString);
                } else {
                    retFwd.setPath(fwdPath + newQueryString);
                }
            }
        }
        return retFwd;
    }

    private static ActionForward doReturnToAction(HttpServletRequest request, String actionName, Forward pageFlowFwd) {
        PreviousActionInfo prevActionInfo;
        PageFlowController curJpf = PageFlowUtils.getCurrentPageFlow(request);
        if (curJpf == null) {
            NoCurrentPageFlowException ex = new NoCurrentPageFlowException(actionName, pageFlowFwd);
            InternalUtils.throwPageFlowException(ex, request);
            assert (false);
        }
        if ((prevActionInfo = curJpf.getPreviousActionInfo()) != null) {
            String prevQuery;
            boolean restoreQueryString;
            String query;
            String actionURI = prevActionInfo.getActionURI();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("return-to-action: " + actionURI));
            }
            if (!pageFlowFwd.isRedirect() && prevActionInfo.getForm() != null && pageFlowFwd.getFirstOutputForm(request) == null) {
                pageFlowFwd.addOutputForm(prevActionInfo.getForm());
            }
            if ((query = pageFlowFwd.getQueryString()) == null) {
                query = "";
            }
            if ((restoreQueryString = pageFlowFwd.restoreQueryString()) && (prevQuery = prevActionInfo.getQueryString()) != null) {
                query = query + (query.length() > 0 ? "&" : "?") + prevQuery;
            }
            ActionForward fwd = new ActionForward(actionURI + query, pageFlowFwd.getRedirect());
            fwd.setContextRelative(true);
            return fwd;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Attempted return-to-action, but previous action info was missing.");
        }
        NoPreviousActionException ex = new NoPreviousActionException(actionName, pageFlowFwd, curJpf);
        InternalUtils.throwPageFlowException(ex, request);
        assert (false);
        return null;
    }

    static ActionForward processForward(Forward fwd, ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, ActionForm form, ServletContext servletContext, FlowController flowController) {
        return ForwardHandler.forwardTo(fwd, mapping, request, response, InternalUtils.getActionName(mapping), null, form, servletContext, flowController);
    }

    private static ActionForward doNestingReturn(Forward pageFlowFwd, HttpServletRequest request, HttpServletResponse response, ActionMapping mapping, FlowController flowController, ActionForm form) {
        PageFlowStack pfStack = PageFlowStack.get(request);
        String returnAction = pageFlowFwd.getPath();
        if (pfStack.isEmpty()) {
            PageFlowController curJpf = PageFlowUtils.getCurrentPageFlow(request);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Tried to pop from empty PageFlow stack.  Current = " + curJpf.getClass().getName()));
            }
            if (_log.isWarnEnabled()) {
                StringBuilder msg = new StringBuilder("Tried to pop from empty PageFlow stack.");
                msg.append("  Current page flow is ");
                msg.append(curJpf != null ? curJpf.getClass().getName() : null);
                _log.warn((Object)msg.append('.').toString());
            }
            EmptyNestingStackException ex = new EmptyNestingStackException(returnAction, curJpf);
            InternalUtils.throwPageFlowException(ex, request);
        }
        assert (flowController instanceof PageFlowController) : flowController.getClass().getName();
        ActionForward exceptionFwd = ((PageFlowController)flowController).exitNesting(request, response, mapping, form);
        if (exceptionFwd != null) {
            return exceptionFwd;
        }
        PageFlowStack.PushedPageFlow pushedPageFlowWrapper = pfStack.pop(request);
        PageFlowController poppedPageFlow = pushedPageFlowWrapper.getPageFlow();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Popped PageFlowController " + poppedPageFlow + " from the nesting stack"));
        }
        InternalUtils.setCurrentPageFlow(poppedPageFlow, request);
        ActionInterceptor interceptor = pushedPageFlowWrapper.getInterceptor();
        if (interceptor != null) {
            InterceptorForward interceptorForward = null;
            try {
                interceptorForward = interceptor.doPostIntercept(request, response, poppedPageFlow, pushedPageFlowWrapper.getInterceptedForward(), returnAction);
            }
            catch (Exception e) {
                _log.error((Object)("Exception in " + interceptor.getClass().getName() + ".doPostIntercept"), (Throwable)e);
            }
            if (interceptorForward != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("post-intercept: forwarding to " + interceptorForward.getPath()));
                }
                interceptorForward.rehydrateRequest(request);
                ActionInterceptorChain.setIsReturningFromIntercept(request, true);
                return interceptorForward;
            }
        }
        assert (returnAction.charAt(0) != '/') : returnAction;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Action on popped PageFlowController is " + returnAction));
        }
        StringBuilder returnActionPath = new StringBuilder(poppedPageFlow.getModulePath());
        returnActionPath.append('/').append(returnAction).append(".do");
        ActionForm retForm = pageFlowFwd.getFirstOutputForm(request);
        if (retForm != null) {
            RequestValues.setForwardedFormBean((ServletRequest)request, retForm);
            ImplicitObjectUtil.loadOutputFormBean((ServletRequest)request, InternalUtils.unwrapFormBean(retForm));
        }
        request.setAttribute("_netui:nestedReturning", (Object)Boolean.TRUE);
        ActionForward fwd = new ActionForward(returnActionPath.toString(), false);
        fwd.setContextRelative(true);
        return fwd;
    }
}

