/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.scoping.ScopedRequest;
import org.apache.beehive.netui.pageflow.scoping.ScopedServletUtils;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServletWrapper;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.RequestUtils;

class MultipartRequestUtils {
    private static final Logger _log = Logger.getInstance(MultipartRequestUtils.class);
    private static final String PREHANDLED_MULTIPART_REQUEST_ATTR = "_netui:handledMultipart";

    MultipartRequestUtils() {
    }

    static final Map handleMultipartRequest(HttpServletRequest request, ActionForm bean) throws ServletException {
        String contentType = request.getContentType();
        String method = request.getMethod();
        boolean isMultipart = false;
        Map multipartParameters = null;
        if (contentType != null && contentType.startsWith("multipart/form-data") && method.equalsIgnoreCase("POST")) {
            ActionServletWrapper servlet;
            if (!InternalUtils.isMultipartHandlingEnabled(request)) {
                throw new ServletException("Received a multipart request, but multipart handling is not enabled.");
            }
            if (bean != null) {
                servlet = bean.getServletWrapper();
            } else {
                ServletContext servletContext = InternalUtils.getServletContext(request);
                servlet = new ActionServletWrapper(InternalUtils.getActionServlet(servletContext));
            }
            MultipartRequestHandler multipartHandler = MultipartRequestUtils.getCachedMultipartHandler(request);
            boolean preHandled = false;
            if (multipartHandler == null) {
                multipartHandler = MultipartRequestUtils.getMultipartHandler(request);
            } else {
                preHandled = true;
            }
            if (bean != null) {
                bean.setMultipartRequestHandler(multipartHandler);
            }
            if (multipartHandler != null) {
                Boolean maxLengthExceeded;
                isMultipart = true;
                servlet.setServletFor(multipartHandler);
                multipartHandler.setMapping((ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance"));
                if (!preHandled) {
                    multipartHandler.handleRequest(request);
                }
                if ((maxLengthExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded")) != null && maxLengthExceeded.booleanValue()) {
                    return null;
                }
                multipartParameters = MultipartRequestUtils.getAllParametersForMultipartRequest(request, multipartHandler);
            }
        }
        if (!isMultipart) {
            return null;
        }
        ScopedRequest scopedRequest = ScopedServletUtils.unwrapRequest((ServletRequest)PageFlowUtils.unwrapMultipart(request));
        if (scopedRequest != null) {
            multipartParameters = scopedRequest.filterParameterMap(multipartParameters);
        }
        return multipartParameters;
    }

    static void preHandleMultipartRequest(HttpServletRequest request) throws ServletException {
        MultipartRequestHandler multipartHandler = MultipartRequestUtils.getCachedMultipartHandler(request);
        if (multipartHandler == null && (multipartHandler = MultipartRequestUtils.getMultipartHandler(request)) != null) {
            multipartHandler.handleRequest(request);
            HttpServletRequest outerRequest = ScopedServletUtils.getOuterRequest((HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
            outerRequest.setAttribute(PREHANDLED_MULTIPART_REQUEST_ATTR, (Object)multipartHandler);
        }
    }

    private static final MultipartRequestHandler getMultipartHandler(HttpServletRequest request) throws ServletException {
        ModuleConfig moduleConfig;
        MultipartRequestHandler multipartHandler = null;
        String multipartClass = (String)request.getAttribute("org.apache.struts.action.mapping.multipartclass");
        request.removeAttribute("org.apache.struts.action.mapping.multipartclass");
        if (multipartClass != null) {
            try {
                multipartHandler = (MultipartRequestHandler)RequestUtils.applicationInstance((String)multipartClass);
            }
            catch (ClassNotFoundException cnfe) {
                _log.error((Object)("MultipartRequestHandler class \"" + multipartClass + "\" in mapping class not found, " + "defaulting to global multipart class"));
            }
            catch (InstantiationException ie) {
                _log.error((Object)("InstantiaionException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + ie.getMessage()));
            }
            catch (IllegalAccessException iae) {
                _log.error((Object)("IllegalAccessException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + iae.getMessage()));
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        if ((multipartClass = (moduleConfig = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE")).getControllerConfig().getMultipartClass()) != null) {
            try {
                multipartHandler = (MultipartRequestHandler)RequestUtils.applicationInstance((String)multipartClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ServletException("Cannot find multipart class \"" + multipartClass + "\"" + ", exception: " + cnfe.getMessage());
            }
            catch (InstantiationException ie) {
                throw new ServletException("InstantiaionException when instantiating multipart class \"" + multipartClass + "\", exception: " + ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new ServletException("IllegalAccessException when instantiating multipart class \"" + multipartClass + "\", exception: " + iae.getMessage());
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        return multipartHandler;
    }

    private static final Map getAllParametersForMultipartRequest(HttpServletRequest request, MultipartRequestHandler multipartHandler) {
        String key;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Hashtable elements = multipartHandler.getAllElements();
        Enumeration e = elements.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            parameters.put(key, elements.get(key));
        }
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
            e = request.getParameterNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                parameters.put(key, request.getParameterValues(key));
            }
        } else {
            _log.debug((Object)"Gathering multipart parameters for unwrapped request");
        }
        return parameters;
    }

    static MultipartRequestHandler getCachedMultipartHandler(HttpServletRequest request) {
        HttpServletRequest req = ScopedServletUtils.getOuterRequest((HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
        return (MultipartRequestHandler)req.getAttribute(PREHANDLED_MULTIPART_REQUEST_ATTR);
    }
}

