/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.io.Serializable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.beehive.netui.pageflow.AutoRegisterActionServlet;
import org.apache.beehive.netui.pageflow.PageFlowContextListener;

public class PageFlowActionServlet
extends AutoRegisterActionServlet {
    private static final AutoRegisterActionServlet.ModuleConfigLocator[] DEFAULT_MODULE_CONFIG_LOCATORS = new AutoRegisterActionServlet.ModuleConfigLocator[]{new DefaultModuleConfigLocator(), new LegacyModuleConfigLocator()};

    protected AutoRegisterActionServlet.ModuleConfigLocator[] getDefaultModuleConfigLocators() {
        return DEFAULT_MODULE_CONFIG_LOCATORS;
    }

    public void init(ServletConfig config) throws ServletException {
        ServletContext servletContext = config.getServletContext();
        if (!PageFlowContextListener.isInit(servletContext)) {
            PageFlowContextListener.performInitializations(servletContext);
        }
        super.init(config);
    }

    public String getModuleConfPath(String modulePath) {
        return super.getModuleConfPath(modulePath);
    }

    public void addServletMapping(String servletName, String urlPattern) {
        if (!urlPattern.endsWith(".jpf")) {
            super.addServletMapping(servletName, urlPattern);
        }
    }

    protected static class LegacyModuleConfigLocator
    extends DefaultModuleConfigLocator {
        protected LegacyModuleConfigLocator() {
        }

        protected String getGenDir() {
            return "/WEB-INF";
        }
    }

    public static class DefaultModuleConfigLocator
    implements AutoRegisterActionServlet.ModuleConfigLocator,
    Serializable {
        public String getModuleConfigPath(String moduleName) {
            StringBuilder moduleConfPath = new StringBuilder(this.getGenDir());
            moduleConfPath.append('/').append("jpf-struts-config");
            if (moduleName.length() > 1) {
                moduleConfPath.append(moduleName.replace('/', '-'));
            }
            moduleConfPath.append(".xml");
            return moduleConfPath.toString();
        }

        protected String getGenDir() {
            return "/WEB-INF/.pageflow-struts-generated";
        }
    }
}

