/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.core.urls.URLRewriter;
import org.apache.beehive.netui.core.urls.URLRewriterService;
import org.apache.beehive.netui.pageflow.AutoRegisterActionServlet;
import org.apache.beehive.netui.pageflow.FlowController;
import org.apache.beehive.netui.pageflow.FlowControllerFactory;
import org.apache.beehive.netui.pageflow.PageFlowContextListener;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.ServerAdapter;
import org.apache.beehive.netui.pageflow.SharedFlowController;
import org.apache.beehive.netui.pageflow.internal.DefaultURLRewriter;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.internal.JavaControlUtils;
import org.apache.beehive.netui.pageflow.internal.ServerAdapterManager;
import org.apache.beehive.netui.script.common.ImplicitObjectUtil;
import org.apache.beehive.netui.util.FileUtils;
import org.apache.beehive.netui.util.ServletUtils;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public abstract class PageFlowPageFilter
implements Filter {
    private ServletContext _servletContext;
    private ServerAdapter _serverAdapter;
    private static final Logger _log = Logger.getInstance(PageFlowPageFilter.class);
    private static final String PREVENT_CACHE_ATTR = "_netui:preventCache";

    protected PageFlowPageFilter() {
    }

    PageFlowPageFilter(ServletContext servletContext) {
        this._servletContext = servletContext;
        this._serverAdapter = ServerAdapterManager.getServerAdapter(this._servletContext);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this._servletContext = filterConfig.getServletContext();
        if (!PageFlowContextListener.isInit(this._servletContext)) {
            PageFlowContextListener.performInitializations(this._servletContext);
        }
        this._serverAdapter = ServerAdapterManager.getServerAdapter(this._servletContext);
    }

    protected abstract Set getValidFileExtensions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            Object errStatusCode = request.getAttribute("javax.servlet.error.status_code");
            if (errStatusCode != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Request has error status code " + errStatusCode + ".  Skipping filter."));
                }
                chain.doFilter(request, response);
                return;
            }
            String requestURI = httpRequest.getRequestURI();
            String extension = FileUtils.getFileExtension((String)requestURI);
            Set validFileExtensions = this.getValidFileExtensions();
            if (validFileExtensions != null && !validFileExtensions.contains(extension)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Request " + requestURI + " is not an appropriate URI.  Skipping filter."));
                }
                chain.doFilter(request, response);
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Filtering request " + requestURI));
            }
            if (request.getAttribute(PREVENT_CACHE_ATTR) != null) {
                ServletUtils.preventCache((HttpServletResponse)httpResponse);
            }
            InternalUtils.setServletContext(httpRequest, this._servletContext);
            this._serverAdapter.beginRequest(httpRequest, httpResponse);
            JavaControlUtils.initializeControlContext(httpRequest, httpResponse, this._servletContext);
            URLRewriterService.registerURLRewriter((int)0, (ServletRequest)request, (URLRewriter)new DefaultURLRewriter());
            try {
                ModuleConfig prevModuleConfig = RequestUtils.getRequestModuleConfig((HttpServletRequest)httpRequest);
                MessageResources prevMessageResources = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
                this.initializeModule(httpRequest, httpResponse);
                Map<String, SharedFlowController> sharedFlows = FlowControllerFactory.getSharedFlowsForRequest(httpRequest, httpResponse, this._servletContext);
                ImplicitObjectUtil.loadSharedFlow(request, sharedFlows);
                ImplicitObjectUtil.loadGlobalApp(request, PageFlowUtils.getGlobalApp(httpRequest));
                PageFlowController curJpf = FlowControllerFactory.getPageFlowForRequest(httpRequest, httpResponse, this._servletContext);
                if (curJpf == null) {
                    InternalUtils.setCurrentModule(prevModuleConfig, request);
                    request.setAttribute("org.apache.struts.action.MESSAGE", (Object)prevMessageResources);
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Current PageFlowController is: " + curJpf));
                    _log.debug((Object)"Continuing with filter chain...");
                }
                this.runPage(curJpf, httpRequest, httpResponse, chain);
            }
            finally {
                JavaControlUtils.uninitializeControlContext(httpRequest, httpResponse, this._servletContext);
                this._serverAdapter.endRequest(httpRequest, httpResponse);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPage(PageFlowController curJpf, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (curJpf != null) {
            if (curJpf.incrementRequestCount(request, response, this._servletContext)) {
                try {
                    PageFlowController pageFlowController = curJpf;
                    synchronized (pageFlowController) {
                        FlowController.PerRequestState newState = new FlowController.PerRequestState(request, response, null);
                        FlowController.PerRequestState prevState = curJpf.setPerRequestState(newState);
                        ImplicitObjectUtil.loadImplicitObjects(request, response, this._servletContext, curJpf);
                        curJpf.beforePage();
                        try {
                            chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        }
                        catch (ServletException servletEx) {
                            if (!this.handleException(servletEx, curJpf, request, response)) {
                                throw servletEx;
                            }
                        }
                        catch (IOException ioe) {
                            if (!this.handleException(ioe, curJpf, request, response)) {
                                throw ioe;
                            }
                        }
                        catch (Throwable th) {
                            if (!this.handleException(th, curJpf, request, response)) {
                                throw new ServletException(th);
                            }
                        }
                        finally {
                            curJpf.setPerRequestState(prevState);
                        }
                    }
                }
                finally {
                    curJpf.decrementRequestCount(request);
                }
            }
        } else {
            ImplicitObjectUtil.loadImplicitObjects(request, response, this._servletContext, null);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean handleException(Throwable th, FlowController fc, HttpServletRequest request, HttpServletResponse response) {
        try {
            ActionMapping mapping = InternalUtils.getCurrentActionMapping(request);
            ActionForm form = InternalUtils.getCurrentActionForm(request);
            ActionForward fwd = fc.handleException(th, mapping, form, request, response);
            fc.getRequestProcessor().processActionForward(request, response, fwd);
            return true;
        }
        catch (Throwable t) {
            _log.error((Object)("Exception while handling exception " + th.getClass().getName() + ".  The original exception will be thrown."), th);
            return false;
        }
    }

    private void initializeModule(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        AutoRegisterActionServlet das;
        String curModulePath = PageFlowUtils.getModulePath(request);
        ActionServlet as = InternalUtils.getActionServlet(this._servletContext);
        if (as instanceof AutoRegisterActionServlet) {
            das = (AutoRegisterActionServlet)as;
            das.ensureModuleRegistered(curModulePath, (ServletRequest)request);
        }
        if (InternalUtils.getModuleConfig(curModulePath, this._servletContext) != null) {
            RequestUtils.selectModule((String)curModulePath, (HttpServletRequest)request, (ServletContext)this._servletContext);
        }
        if (RequestUtils.getRequestModuleConfig((HttpServletRequest)request) == null && as instanceof AutoRegisterActionServlet) {
            das = (AutoRegisterActionServlet)as;
            das.ensureModuleSelected(curModulePath, request, (ServletResponse)response);
        }
    }

    static void preventCache(HttpServletRequest request) {
        request.setAttribute(PREVENT_CACHE_ATTR, (Object)Boolean.TRUE);
    }

    public void destroy() {
        this._servletContext = null;
    }
}

