/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.beehive.netui.core.urls.URLRewriter;
import org.apache.beehive.netui.core.urls.URLRewriterService;
import org.apache.beehive.netui.pageflow.ActionNotFoundException;
import org.apache.beehive.netui.pageflow.AutoRegisterActionServlet;
import org.apache.beehive.netui.pageflow.DoubleSubmitException;
import org.apache.beehive.netui.pageflow.FlowController;
import org.apache.beehive.netui.pageflow.FlowControllerFactory;
import org.apache.beehive.netui.pageflow.Forward;
import org.apache.beehive.netui.pageflow.ForwardHandler;
import org.apache.beehive.netui.pageflow.MultipartRequestUtils;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.PageFlowException;
import org.apache.beehive.netui.pageflow.PageFlowJspFilter;
import org.apache.beehive.netui.pageflow.PageFlowPageFilter;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.ProcessPopulate;
import org.apache.beehive.netui.pageflow.ResponseErrorCodeSender;
import org.apache.beehive.netui.pageflow.SecurityProtocol;
import org.apache.beehive.netui.pageflow.ServerAdapter;
import org.apache.beehive.netui.pageflow.SharedFlowController;
import org.apache.beehive.netui.pageflow.UnfulfilledRolesException;
import org.apache.beehive.netui.pageflow.config.PageFlowActionFormBean;
import org.apache.beehive.netui.pageflow.config.PageFlowActionForward;
import org.apache.beehive.netui.pageflow.config.PageFlowActionMapping;
import org.apache.beehive.netui.pageflow.handler.ForwardRedirectHandler;
import org.apache.beehive.netui.pageflow.handler.LoginHandler;
import org.apache.beehive.netui.pageflow.handler.ReloadableClassHandler;
import org.apache.beehive.netui.pageflow.interceptor.ActionInterceptorChain;
import org.apache.beehive.netui.pageflow.interceptor.InterceptorForward;
import org.apache.beehive.netui.pageflow.internal.ContextCache;
import org.apache.beehive.netui.pageflow.internal.DefaultURLRewriter;
import org.apache.beehive.netui.pageflow.internal.FlowControllerAction;
import org.apache.beehive.netui.pageflow.internal.InternalConstants;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.internal.JavaControlUtils;
import org.apache.beehive.netui.pageflow.internal.RequestValues;
import org.apache.beehive.netui.pageflow.internal.ServerAdapterManager;
import org.apache.beehive.netui.pageflow.scoping.ScopedRequest;
import org.apache.beehive.netui.pageflow.scoping.ScopedServletUtils;
import org.apache.beehive.netui.script.common.ImplicitObjectUtil;
import org.apache.beehive.netui.util.DiscoveryUtils;
import org.apache.beehive.netui.util.FileUtils;
import org.apache.beehive.netui.util.ServletUtils;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.action.DynaActionFormClass;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.tiles.TilesRequestProcessor;
import org.apache.struts.tiles.TilesUtil;
import org.apache.struts.tiles.TilesUtilImpl;
import org.apache.struts.tiles.TilesUtilStrutsImpl;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.util.TokenProcessor;

public class PageFlowRequestProcessor
extends TilesRequestProcessor
implements Serializable {
    private static int requestCount = 0;
    private static final Logger _log = Logger.getInstance(PageFlowRequestProcessor.class);
    private static final String ACTION_OVERRIDE_PARAM_PREFIX = "actionOverride:";
    private static final int ACTION_OVERRIDE_PARAM_PREFIX_LEN = "actionOverride:".length();
    private static final String SCHEME_UNSECURE = "http";
    private static final String SCHEME_SECURE = "https";
    private static final String REDIRECT_REQUEST_ATTRS_PREFIX = "_netui:requestAttrs:";
    private static final String REDIRECT_REQUEST_ATTRS_PARAM = "forceRedirect";
    private static final String FORWARDED_BY_BUTTON_OVERRIDE_ATTR = "_netui:buttonForward";
    private static final String PROCESS_POPULATE_ALREADY_CALLED_ATTR = "_netui:processPopulateCalled";
    private static final String MULTIPART_REQUEST_WRAPPER_ATTR = "_netui:multipartWrapper";
    private static final String PAGEFLOW_SCOPED_FORM_NAME_ATTR = "_netui:pageFlowScopedFormName";
    private static final String FLOW_CONTROLLER_ACTION_CLASSNAME = FlowControllerAction.class.getName();
    private Map<String, Class> _formBeanClasses = new HashMap<String, Class>();
    private Map<String, List<ActionMapping>> _overloadedActions = new HashMap<String, List<ActionMapping>>();
    private ServerAdapter _serverAdapter;
    private ConcurrentHashMap<String, Class> _pageServletClasses = new ConcurrentHashMap();
    private PageFlowPageFilter _pageServletFilter;

    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) throws IOException {
        String className = actionMapping.getType();
        if (className != null && className.equals(FLOW_CONTROLLER_ACTION_CLASSNAME)) {
            FlowController fc = RequestValues.getCurrentFlowController((ServletRequest)request);
            assert (fc != null) : "no FlowController for request " + request.getRequestURI();
            assert (fc.getClass().getName().equals(actionMapping.getParameter())) : "current page flow  type " + fc.getClass().getName() + " does not match type specified in " + FLOW_CONTROLLER_ACTION_CLASSNAME + ": " + actionMapping.getParameter();
            FlowControllerAction action = new FlowControllerAction(fc);
            action.setServlet(this.servlet);
            return action;
        }
        return super.processActionCreate(request, response, actionMapping);
    }

    /*
     * Unable to fully structure code
     */
    private ActionForm createActionForm(ActionMapping mapping, HttpServletRequest request) {
        name = mapping.getName();
        if (!PageFlowRequestProcessor.$assertionsDisabled && name == null) {
            throw new AssertionError((Object)mapping.getPath());
        }
        if (name == null) {
            return null;
        }
        config = this.moduleConfig.findFormBeanConfig(name);
        if (config.getDynamic()) {
            try {
                dynaClass = DynaActionFormClass.createDynaActionFormClass((FormBeanConfig)config);
                instance = (ActionForm)dynaClass.newInstance();
                ((DynaActionForm)instance).initialize(mapping);
                if (!PageFlowRequestProcessor._log.isDebugEnabled()) ** GOTO lbl26
                PageFlowRequestProcessor._log.debug((Object)(" Creating new DynaActionForm instance of type '" + config.getType() + '\''));
            }
            catch (Exception e) {
                PageFlowRequestProcessor._log.error((Object)this.servlet.getInternal().getMessage("formBean", (Object)config.getType()), (Throwable)e);
                return null;
            }
        } else {
            try {
                instance = (ActionForm)InternalUtils.newReloadableInstance(config.getType(), request, this.getServletContext());
                if (PageFlowRequestProcessor._log.isDebugEnabled()) {
                    PageFlowRequestProcessor._log.debug((Object)(" Creating new ActionForm instance of type '" + config.getType() + '\''));
                }
            }
            catch (Exception e) {
                PageFlowRequestProcessor._log.error((Object)this.servlet.getInternal().getMessage("formBean", (Object)config.getType()), (Throwable)e);
                return null;
            }
        }
lbl26:
        // 3 sources

        instance.setServlet(this.servlet);
        return instance;
    }

    private Field getPageFlowScopedFormMember(ActionMapping mapping, HttpServletRequest request) {
        if (mapping instanceof PageFlowActionMapping) {
            PageFlowActionMapping pfam = (PageFlowActionMapping)mapping;
            String formMember = pfam.getFormMember();
            try {
                if (formMember != null) {
                    FlowController fc = RequestValues.getCurrentFlowController((ServletRequest)request);
                    Field field = fc.getClass().getDeclaredField(formMember);
                    field.setAccessible(true);
                    return field;
                }
            }
            catch (Exception e) {
                _log.error((Object)("Could not use page flow member " + formMember + " as the form bean."), (Throwable)e);
            }
        }
        return null;
    }

    protected ActionForm processActionForm(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) {
        ActionForm bean;
        Field formMemberField = this.getPageFlowScopedFormMember(mapping, request);
        ActionForm previousForm = RequestValues.getForwardedForm((ServletRequest)request, false);
        if (previousForm != null) {
            if (formMemberField != null) {
                try {
                    FlowController fc = RequestValues.getCurrentFlowController((ServletRequest)request);
                    assert (fc != null) : "no FlowController in request " + request.getRequestURI();
                    formMemberField.set(fc, InternalUtils.unwrapFormBean(previousForm));
                }
                catch (IllegalAccessException e) {
                    _log.error((Object)("Could not access page flow member " + formMemberField.getName() + " as the form bean."), (Throwable)e);
                }
            }
            previousForm.setServlet(this.servlet);
            return previousForm;
        }
        String pageFlowScopedFormName = (String)request.getAttribute(PAGEFLOW_SCOPED_FORM_NAME_ATTR);
        if (pageFlowScopedFormName != null) {
            request.removeAttribute(pageFlowScopedFormName);
            request.removeAttribute(PAGEFLOW_SCOPED_FORM_NAME_ATTR);
        }
        if (formMemberField != null) {
            try {
                FlowController fc = RequestValues.getCurrentFlowController((ServletRequest)request);
                ActionForm form = InternalUtils.wrapFormBean(formMemberField.get(fc));
                if (form == null) {
                    form = this.createActionForm(mapping, request);
                    form.reset(mapping, request);
                    formMemberField.set(fc, InternalUtils.unwrapFormBean(form));
                }
                request.setAttribute(mapping.getAttribute(), (Object)form);
                request.setAttribute(PAGEFLOW_SCOPED_FORM_NAME_ATTR, (Object)mapping.getAttribute());
                return form;
            }
            catch (IllegalAccessException e) {
                _log.error((Object)("Could not access page flow member " + formMemberField.getName() + " as the form bean."), (Throwable)e);
            }
        }
        if ((bean = super.processActionForm(request, response, mapping)) == null) {
            bean = InternalUtils.createActionForm(request, mapping, this.moduleConfig, this.servlet, this.getServletContext());
        }
        return bean;
    }

    protected void processPopulate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws ServletException {
        boolean alreadyCalledInRequest;
        ActionForm previousForm = RequestValues.getForwardedForm((ServletRequest)request, true);
        if (previousForm != null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Populating bean properties from this request");
        }
        if (form != null) {
            form.setServlet(this.servlet);
            form.reset(mapping, request);
        }
        if (mapping.getMultipartClass() != null) {
            request.setAttribute("org.apache.struts.action.mapping.multipartclass", (Object)mapping.getMultipartClass());
        }
        boolean bl = alreadyCalledInRequest = request.getAttribute(PROCESS_POPULATE_ALREADY_CALLED_ATTR) != null;
        if (!alreadyCalledInRequest) {
            request.setAttribute(PROCESS_POPULATE_ALREADY_CALLED_ATTR, (Object)Boolean.TRUE);
        }
        if (!alreadyCalledInRequest || form != null) {
            ProcessPopulate.populate(request, response, form, alreadyCalledInRequest);
        }
    }

    protected boolean processActionOverride(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getAttribute(FORWARDED_BY_BUTTON_OVERRIDE_ATTR) == null) {
            request.setAttribute(FORWARDED_BY_BUTTON_OVERRIDE_ATTR, (Object)Boolean.TRUE);
            HttpServletRequest multipartAwareRequest = this.processMultipart(request);
            Enumeration e = multipartAwareRequest.getParameterNames();
            while (e.hasMoreElements()) {
                String paramName = (String)e.nextElement();
                if (!paramName.startsWith(ACTION_OVERRIDE_PARAM_PREFIX)) continue;
                String actionPath = paramName.substring(ACTION_OVERRIDE_PARAM_PREFIX_LEN);
                ServletContext servletContext = this.getServletContext();
                String qualifiedAction = InternalUtils.qualifyAction(servletContext, actionPath);
                actionPath = InternalUtils.createActionPath(request, qualifiedAction);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("A request parameter overrode the action.  Forwarding to: " + actionPath));
                }
                this.doForward(actionPath, request, response);
                return true;
            }
        }
        return false;
    }

    private void processInternal(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block19: {
            HttpSession session;
            String uri = InternalUtils.getDecodedServletPath(request);
            ServletContext servletContext = this.getServletContext();
            if (ContextCache.get(servletContext).shouldDoSecureForwards() && RequestValues.isForwardedRequest((ServletRequest)request) && this._serverAdapter.doSecurityRedirect(uri, request, response)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("checkSecurity() caused a redirect.  Ending processing for this request (" + uri + ')'));
                }
                return;
            }
            String hash = request.getParameter(REDIRECT_REQUEST_ATTRS_PARAM);
            if (hash != null && (session = request.getSession(false)) != null) {
                String carryoverAttrName = PageFlowRequestProcessor.makeRedirectedRequestAttrsKey(uri, hash);
                Map attrs = (Map)session.getAttribute(carryoverAttrName);
                session.removeAttribute(carryoverAttrName);
                if (attrs != null) {
                    for (Map.Entry entry : attrs.entrySet()) {
                        String attrName = (String)entry.getKey();
                        if (request.getAttribute(attrName) != null) continue;
                        request.setAttribute(attrName, entry.getValue());
                    }
                }
            }
            if (this.processActionOverride(request, response)) {
                return;
            }
            if (this.processPageFlowRequest(request, response, uri)) {
                return;
            }
            String flowControllerClassName = InternalUtils.getFlowControllerClassName(this.moduleConfig);
            if (flowControllerClassName == null && !(this.moduleConfig instanceof AutoRegisterActionServlet.MissingRootModuleControllerConfig)) {
                _log.warn((Object)("Struts module " + this.moduleConfig.getPrefix() + " is configured to use " + this.getClass().getName() + " as the request processor, but the <controller> element does not contain a <set-property>" + " for \"controllerClass\".  Page Flow actions in this module may not be handled correctly."));
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Attempting to instantiate SharedFlowControllers for request " + request.getRequestURI()));
            }
            Map<String, SharedFlowController> sharedFlows = FlowControllerFactory.getSharedFlowsForRequest(request, response, servletContext);
            ImplicitObjectUtil.loadSharedFlow((ServletRequest)request, sharedFlows);
            ImplicitObjectUtil.loadGlobalApp((ServletRequest)request, PageFlowUtils.getGlobalApp(request));
            FlowController currentFlowController = null;
            if (flowControllerClassName != null) {
                try {
                    currentFlowController = InternalUtils.getFlowController(flowControllerClassName, request, response, servletContext);
                    RequestValues.setCurrentFlowController((ServletRequest)request, currentFlowController);
                }
                catch (ClassNotFoundException e) {
                    _log.error((Object)("Could not find FlowController class " + flowControllerClassName), (Throwable)e);
                }
            } else {
                RequestValues.removeCurrentFlowController((ServletRequest)request);
            }
            PageFlowController jpf = PageFlowUtils.getCurrentPageFlow(request);
            ImplicitObjectUtil.loadImplicitObjects(request, response, servletContext, jpf);
            try {
                super.process(request, response);
            }
            catch (ServletException servletEx) {
                if (!this.handleException(servletEx, currentFlowController, request, response)) {
                    throw servletEx;
                }
            }
            catch (IOException ioe) {
                if (!this.handleException(ioe, currentFlowController, request, response)) {
                    throw ioe;
                }
            }
            catch (Throwable th) {
                if (this.handleException(th, currentFlowController, request, response)) break block19;
                throw new ServletException(th);
            }
        }
    }

    private boolean handleException(Throwable th, FlowController fc, HttpServletRequest request, HttpServletResponse response) {
        if (fc != null) {
            try {
                ActionMapping mapping = InternalUtils.getCurrentActionMapping(request);
                ActionForm form = InternalUtils.getCurrentActionForm(request);
                ActionForward fwd = fc.handleException(th, mapping, form, request, response);
                this.processForwardConfig(request, response, (ForwardConfig)fwd);
                return true;
            }
            catch (Throwable t) {
                _log.error((Object)("Exception while handling exception " + th.getClass().getName() + ".  The original exception will be thrown."), th);
                return false;
            }
        }
        return false;
    }

    protected boolean processPageFlowRequest(HttpServletRequest request, HttpServletResponse response, String uri) throws IOException, ServletException {
        if (FileUtils.osSensitiveEndsWith((String)uri, (String)".jpf")) {
            String modulePath = PageFlowUtils.getModulePath(request);
            if (!this.moduleConfig.getPrefix().equals(modulePath)) {
                if (_log.isErrorEnabled()) {
                    StringBuilder msg = new StringBuilder("No module configuration registered for ");
                    msg.append(uri).append(" (module path ").append(modulePath).append(").");
                    _log.error((Object)msg.toString());
                }
                InternalUtils.sendDevTimeError("PageFlow_NoModuleConf", null, 500, request, response, this.getServletContext(), uri, modulePath);
                return true;
            }
            ActionMapping beginMapping = this.getBeginMapping();
            if (beginMapping != null) {
                String desiredType = beginMapping.getParameter();
                desiredType = desiredType.substring(desiredType.lastIndexOf(46) + 1) + ".jpf";
                String requestedType = InternalUtils.getDecodedServletPath(request);
                if (!(requestedType = requestedType.substring(requestedType.lastIndexOf(47) + 1)).equals(desiredType)) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Wrong .jpf requested for this directory: got " + requestedType + ", expected " + desiredType));
                    }
                    if (_log.isErrorEnabled()) {
                        StringBuilder msg = new StringBuilder("Wrong .jpf requested for this directory: got ");
                        msg.append(requestedType).append(", expected ").append(desiredType).append('.');
                        _log.error((Object)msg.toString());
                    }
                    InternalUtils.sendDevTimeError("PageFlow_WrongPath", null, 500, request, response, this.getServletContext(), requestedType, desiredType);
                    return true;
                }
            }
            uri = PageFlowUtils.getBeginActionURI(uri);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Got request for " + request.getRequestURI() + ", forwarding to " + uri));
            }
            this.doForward(uri, request, response);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int localRequestCount = -1;
        if (_log.isTraceEnabled()) {
            localRequestCount = ++requestCount;
            _log.trace((Object)("------------------------------- Start Request #" + localRequestCount + " -----------------------------------"));
        }
        ServletContext servletContext = this.getServletContext();
        ContextCache contextCache = ContextCache.get(servletContext);
        contextCache.getReloadableClassHandler().reinit(request);
        InternalUtils.setServletContext(request, servletContext);
        this._serverAdapter.beginRequest(request, response);
        JavaControlUtils.initializeControlContext(request, response, servletContext);
        URLRewriterService.registerURLRewriter((int)0, (ServletRequest)request, (URLRewriter)new DefaultURLRewriter());
        try {
            this.processInternal(request, response);
        }
        finally {
            JavaControlUtils.uninitializeControlContext(request, response, this.getServletContext());
            this._serverAdapter.endRequest(request, response);
        }
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("-------------------------------- End Request #" + localRequestCount + " ------------------------------------"));
        }
    }

    protected HttpServletRequest processMultipart(HttpServletRequest request) {
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            return request;
        }
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            MultipartRequestWrapper cachedWrapper = (MultipartRequestWrapper)request.getAttribute(MULTIPART_REQUEST_WRAPPER_ATTR);
            if (cachedWrapper != null && cachedWrapper.getRequest() == request) {
                return cachedWrapper;
            }
            try {
                MultipartRequestUtils.preHandleMultipartRequest(request);
            }
            catch (ServletException e) {
                _log.error((Object)"Could not parse multipart request.", e.getRootCause());
                return request;
            }
            RehydratedMultipartRequestWrapper ret = new RehydratedMultipartRequestWrapper(request);
            request.setAttribute(MULTIPART_REQUEST_WRAPPER_ATTR, (Object)ret);
            return ret;
        }
        return request;
    }

    protected ActionMapping getBeginMapping() {
        return (ActionMapping)this.moduleConfig.findActionConfig("/begin");
    }

    private static String makeRedirectedRequestAttrsKey(String webappRelativeURI, String hash) {
        return REDIRECT_REQUEST_ATTRS_PREFIX + hash + webappRelativeURI;
    }

    public ActionForward processException(HttpServletRequest request, HttpServletResponse response, Exception ex, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        return super.processException(request, response, ex, form, mapping);
    }

    private boolean isCorrectFormType(Class formBeanClass, ActionMapping mapping) {
        assert (mapping.getName() != null) : "cannot pass an ActionMapping that has no form bean";
        Class cachedFormBeanClass = this._formBeanClasses.get(mapping.getName());
        return this.isCorrectFormType(formBeanClass, cachedFormBeanClass, mapping);
    }

    private boolean isCorrectFormType(Class formBeanClass, Class actionMappingFormBeanClass, ActionMapping mapping) {
        String desiredType;
        if (actionMappingFormBeanClass != null) {
            return actionMappingFormBeanClass.isAssignableFrom(formBeanClass);
        }
        FormBeanConfig mappingFormBean = this.moduleConfig.findFormBeanConfig(mapping.getName());
        String formClassName = formBeanClass.getName();
        if (mappingFormBean != null && mappingFormBean.getType().equals(formClassName)) {
            return true;
        }
        return mapping instanceof PageFlowActionMapping && formClassName.equals(desiredType = ((PageFlowActionMapping)mapping).getFormClass());
    }

    private ActionMapping checkTransaction(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping, String actionPath) throws IOException {
        if (mapping instanceof PageFlowActionMapping && ((PageFlowActionMapping)mapping).isPreventDoubleSubmit() && !TokenProcessor.getInstance().isTokenValid(request, true)) {
            FlowController currentFC = RequestValues.getCurrentFlowController((ServletRequest)request);
            String actionName = InternalUtils.getActionName(mapping);
            DoubleSubmitException ex = new DoubleSubmitException(actionName, currentFC);
            if (currentFC != null) {
                try {
                    ActionForward fwd = currentFC.handleException(ex, mapping, null, request, response);
                    return new ExceptionHandledActionMapping(actionPath, fwd);
                }
                catch (ServletException servletException) {
                    _log.error((Object)("Exception occurred while handling " + ex.getClass().getName()), (Throwable)servletException);
                }
            }
            ex.sendResponseErrorCode(response);
            return null;
        }
        return mapping;
    }

    public void init(ActionServlet actionServlet, ModuleConfig mc) throws ServletException {
        super.init(actionServlet, mc);
        this.cacheOverloadedActionMappings();
        this.cacheFormClasses();
        this._serverAdapter = ServerAdapterManager.getServerAdapter(this.getServletContext());
        this._pageServletFilter = new PageServletFilter();
    }

    private void cacheOverloadedActionMappings() {
        ActionConfig[] actionConfigs = this.moduleConfig.findActionConfigs();
        for (int i = 0; i < actionConfigs.length; ++i) {
            ActionConfig actionConfig = actionConfigs[i];
            if (!(actionConfig instanceof PageFlowActionMapping)) continue;
            PageFlowActionMapping mapping = (PageFlowActionMapping)actionConfig;
            String unqualifiedActionPath = ((PageFlowActionMapping)actionConfig).getUnqualifiedActionPath();
            if (unqualifiedActionPath == null) continue;
            List<ActionMapping> overloaded = this._overloadedActions.get(unqualifiedActionPath);
            if (overloaded == null) {
                overloaded = new ArrayList<ActionMapping>();
                this._overloadedActions.put(unqualifiedActionPath, overloaded);
            }
            overloaded.add(mapping);
        }
    }

    private void cacheFormClasses() {
        FormBeanConfig[] formBeans = this.moduleConfig.findFormBeanConfigs();
        ReloadableClassHandler rch = ContextCache.get(this.getServletContext()).getReloadableClassHandler();
        for (int i = 0; i < formBeans.length; ++i) {
            FormBeanConfig formBeanConfig = formBeans[i];
            String formType = null;
            if (formBeanConfig instanceof PageFlowActionFormBean) {
                formType = ((PageFlowActionFormBean)formBeanConfig).getActualType();
            }
            if (formType == null) {
                formType = formBeanConfig.getType();
            }
            try {
                Class formBeanClass = rch.loadClass(formType);
                this._formBeanClasses.put(formBeanConfig.getName(), formBeanClass);
                continue;
            }
            catch (ClassNotFoundException e) {
                _log.error((Object)("Could not load class " + formType + " referenced from form bean config " + formBeanConfig.getName() + " in Struts module " + this.moduleConfig));
            }
        }
    }

    protected void initDefinitionsMapping() throws ServletException {
        this.definitionsFactory = null;
        TilesUtilImpl tilesUtil = TilesUtil.getTilesUtil();
        if (tilesUtil instanceof TilesUtilStrutsImpl) {
            this.definitionsFactory = ((TilesUtilStrutsImpl)tilesUtil).getDefinitionsFactory(this.getServletContext(), this.moduleConfig);
            if (this.definitionsFactory == null && log.isDebugEnabled()) {
                log.debug((Object)("Definition Factory not found for module: '" + this.moduleConfig.getPrefix()));
            }
        }
    }

    public ActionMapping processMapping(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        ActionMapping mapping;
        int i;
        FlowController fc = RequestValues.getCurrentFlowController((ServletRequest)request);
        Object forwardedForm = InternalUtils.unwrapFormBean(RequestValues.getForwardedForm((ServletRequest)request, false));
        if (fc != null && !this.processSharedFlowMapping(request, response, path, fc)) {
            return null;
        }
        Class<?> forwardedFormClass = null;
        if (forwardedForm != null) {
            forwardedFormClass = forwardedForm.getClass();
            List<ActionMapping> possibleMatches = this._overloadedActions.get(path);
            ActionMapping bestMatch = null;
            for (i = 0; possibleMatches != null && i < possibleMatches.size(); ++i) {
                ActionMapping possibleMatch = possibleMatches.get(i);
                assert (possibleMatch instanceof PageFlowActionMapping) : possibleMatch.getClass();
                Class cachedFormBeanClass = this._formBeanClasses.get(possibleMatch.getName());
                if (forwardedFormClass.equals(cachedFormBeanClass)) {
                    bestMatch = possibleMatch;
                    break;
                }
                if (bestMatch != null || !this.isCorrectFormType(forwardedFormClass, possibleMatch)) continue;
                bestMatch = possibleMatch;
            }
            if (bestMatch != null) {
                request.setAttribute("org.apache.struts.action.mapping.instance", bestMatch);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Found form-specific action mapping " + bestMatch.getPath() + " for " + path + ", form " + forwardedFormClass.getName()));
                }
                return this.checkTransaction(request, response, bestMatch, path);
            }
        }
        if ((mapping = (ActionMapping)this.moduleConfig.findActionConfig(path)) != null) {
            boolean wrongForm = false;
            if (forwardedForm != null) {
                boolean mappingHasNoFormBean = mapping.getName() == null;
                boolean bl = wrongForm = mappingHasNoFormBean || !this.isCorrectFormType(forwardedFormClass, mapping);
            }
            if (!wrongForm) {
                request.setAttribute("org.apache.struts.action.mapping.instance", (Object)mapping);
                return this.checkTransaction(request, response, mapping, path);
            }
        }
        ActionConfig[] configs = this.moduleConfig.findActionConfigs();
        for (i = 0; i < configs.length; ++i) {
            if (!configs[i].getUnknown()) continue;
            mapping = (ActionMapping)configs[i];
            request.setAttribute("org.apache.struts.action.mapping.instance", (Object)mapping);
            return this.checkTransaction(request, response, mapping, path);
        }
        String errorServletPath = RequestValues.getOriginalServletPath((ServletRequest)request);
        if (errorServletPath == null && InternalUtils.getModuleConfig("/-global", this.getServletContext()) != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Trying Global.app for unhandled action " + path));
            }
            errorServletPath = InternalUtils.getDecodedServletPath(request);
            RequestValues.setOriginalServletPath((ServletRequest)request, errorServletPath);
            String globalAppURI = "/-global" + path + ".do";
            try {
                this.doForward(globalAppURI, request, response);
            }
            catch (ServletException e) {
                _log.error((Object)("Could not forward to Global.app URI " + globalAppURI));
            }
            return null;
        }
        errorServletPath = InternalUtils.getDecodedServletPath(request);
        return this.processUnresolvedAction(path, errorServletPath, request, response, forwardedForm);
    }

    protected boolean processSharedFlowMapping(HttpServletRequest request, HttpServletResponse response, String actionPath, FlowController currentFlowController) throws IOException {
        int dot;
        if (currentFlowController.isPageFlow() && (dot = actionPath.indexOf(46)) != -1) {
            Map<String, SharedFlowController> sharedFlows = PageFlowUtils.getSharedFlows(request);
            if (sharedFlows == null) {
                return true;
            }
            if (dot == actionPath.length() - 1) {
                return true;
            }
            assert (actionPath.startsWith("/")) : actionPath;
            String sharedFlowName = actionPath.substring(1, dot);
            SharedFlowController sf = sharedFlows.get(sharedFlowName);
            if (sf != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Forwarding to shared flow " + sf.getURI() + " to handle action \"" + actionPath + "\"."));
                }
                RequestValues.setOriginalServletPath((ServletRequest)request, InternalUtils.getDecodedServletPath(request));
                int lastSlash = actionPath.lastIndexOf(47);
                assert (lastSlash != -1) : actionPath;
                StringBuilder uri = new StringBuilder(sf.getModulePath());
                uri.append('/');
                uri.append(actionPath.substring(dot + 1));
                uri.append(".do");
                try {
                    this.doForward(uri.toString(), request, response);
                    return false;
                }
                catch (ServletException e) {
                    _log.error((Object)("Could not forward to shared flow URI " + uri), (Throwable)e);
                }
            }
        }
        return true;
    }

    protected ActionMapping processUnresolvedAction(String actionPath, String originalServletPath, HttpServletRequest request, HttpServletResponse response, Object returningForm) throws IOException {
        block6: {
            FlowController fc;
            if (_log.isInfoEnabled()) {
                StringBuilder msg = new StringBuilder("Action \"").append(actionPath);
                _log.info((Object)msg.append("\" was also unhandled by Global.app.").toString());
            }
            if ((fc = PageFlowUtils.getCurrentPageFlow(request)) == null) {
                fc = RequestValues.getCurrentFlowController((ServletRequest)request);
            }
            try {
                if (fc != null) {
                    ActionNotFoundException ex = new ActionNotFoundException(actionPath, fc, returningForm);
                    InternalUtils.setCurrentModule(fc.getModuleConfig(), (ServletRequest)request);
                    ActionForward result = fc.handleException(ex, null, null, request, response);
                    return new ExceptionHandledActionMapping(actionPath, result);
                }
            }
            catch (ServletException e) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Object)e);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Couldn't handle an ActionNotFoundException -- delegating to Struts");
        }
        return super.processMapping(request, response, actionPath);
    }

    protected boolean processRoles(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        String[] roles = mapping.getRoleNames();
        if (roles == null || roles.length < 1) {
            return true;
        }
        for (int i = 0; i < roles.length; ++i) {
            if (!ContextCache.get(this.getServletContext()).getLoginHandler().isUserInRole(roles[i], request)) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(" User " + request.getRemoteUser() + " has role '" + roles[i] + "', granting access"));
            }
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(" User '" + request.getRemoteUser() + "' does not have any required role, denying access"));
        }
        LoginHandler loginHandler = ContextCache.get(this.getServletContext()).getLoginHandler();
        String actionName = InternalUtils.getActionName(mapping);
        FlowController currentFC = RequestValues.getCurrentFlowController((ServletRequest)request);
        PageFlowException ex = loginHandler.getUserPrincipal(request) == null ? currentFC.createNotLoggedInException(actionName, request) : new UnfulfilledRolesException(mapping.getRoleNames(), mapping.getRoles(), actionName, currentFC);
        if (currentFC != null) {
            ActionForward fwd = currentFC.handleException(ex, mapping, null, request, response);
            this.processForwardConfig(request, response, (ForwardConfig)fwd);
        } else {
            assert (ex instanceof ResponseErrorCodeSender) : ex.getClass().getName();
            ((ResponseErrorCodeSender)((Object)ex)).sendResponseErrorCode(response);
        }
        return false;
    }

    private static String addScopeParams(String url, HttpServletRequest request) {
        String scopeID = request.getParameter("jpfScopeID");
        if (scopeID != null) {
            return InternalUtils.addParam(url, "jpfScopeID", scopeID);
        }
        return url;
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig fwd) throws IOException, ServletException {
        ServletContext servletContext = this.getServletContext();
        ForwardRedirectHandler fwdRedirectHandler = ContextCache.get(servletContext).getForwardRedirectHandler();
        if (fwd != null) {
            String path;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("processForwardConfig(" + fwd + ')'));
            }
            if (this.processTilesDefinition(fwd.getPath(), fwd.getContextRelative(), request, response)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  '" + fwd.getPath() + "' - processed as definition"));
                }
                return;
            }
            if (fwd instanceof PageFlowActionForward) {
                ActionMapping mapping = (ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance");
                assert (mapping != null);
                ActionForm form = InternalUtils.getFormBean(mapping, request);
                PageFlowController curJpf = PageFlowUtils.getCurrentPageFlow(request);
                Forward pfFwd = new Forward((ActionForward)fwd, servletContext);
                fwd = ForwardHandler.processForward(pfFwd, mapping, request, response, form, servletContext, curJpf);
            }
            if (FileUtils.isAbsoluteURI((String)(path = fwd.getPath()))) {
                fwdRedirectHandler.redirect(PageFlowRequestProcessor.addScopeParams(path, request), request, response);
            } else if (fwd.getRedirect()) {
                String redirectURI;
                if (path.startsWith("/") && fwd instanceof Forward && ((Forward)fwd).isExplicitPath()) {
                    redirectURI = path;
                } else if (fwd instanceof Forward && ((Forward)fwd).isExternalRedirect()) {
                    assert (path.startsWith("/")) : path;
                    redirectURI = path;
                } else {
                    redirectURI = request.getContextPath() + RequestUtils.forwardURL((HttpServletRequest)request, (ForwardConfig)fwd);
                }
                fwdRedirectHandler.redirect(PageFlowRequestProcessor.addScopeParams(redirectURI, request), request, response);
            } else {
                String fwdURI;
                if (path.startsWith("/") && fwd instanceof Forward && ((Forward)fwd).isExplicitPath()) {
                    fwdURI = path;
                } else {
                    fwdURI = RequestUtils.forwardURL((HttpServletRequest)request, (ForwardConfig)fwd);
                    ModuleConfig mc = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
                    if (InternalUtils.isSharedFlowModule(mc) && fwdURI.startsWith("/-")) {
                        fwdURI = '/' + fwdURI.substring(InternalConstants.SHARED_FLOW_MODULE_PREFIX_LEN);
                    }
                }
                this.doForward(fwdURI, request, response);
            }
        }
    }

    protected boolean changeScheme(String webappRelativeURI, String scheme, int port, HttpServletRequest request, HttpServletResponse response) throws URISyntaxException, IOException, ServletException {
        if (port == -1 && _log.isWarnEnabled()) {
            _log.warn((Object)("Could not change the scheme to " + scheme + " because the relevant port was not provided " + "by the ServerAdapter."));
            return false;
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        String queryString = null;
        ServletContext servletContext = this.getServletContext();
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            attrs.put(name, request.getAttribute(name));
        }
        if (!attrs.isEmpty()) {
            String hash = Integer.toString(request.hashCode());
            String key = PageFlowRequestProcessor.makeRedirectedRequestAttrsKey(webappRelativeURI, hash);
            request.getSession().setAttribute(key, attrs);
            queryString = URLRewriterService.rewriteName((ServletContext)servletContext, (ServletRequest)request, (String)REDIRECT_REQUEST_ATTRS_PARAM) + '=' + hash;
        }
        URI redirectURI = new URI(scheme, null, request.getServerName(), port, request.getContextPath() + webappRelativeURI, queryString, null);
        ForwardRedirectHandler fwdRedirectHandler = ContextCache.get(servletContext).getForwardRedirectHandler();
        fwdRedirectHandler.redirect(redirectURI.toString(), request, response);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Redirected to " + redirectURI));
        }
        return true;
    }

    protected boolean shouldDoSecureForwards() {
        return ContextCache.get(this.getServletContext()).shouldDoSecureForwards();
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        SecurityProtocol sp;
        boolean securityRedirected = false;
        ServletContext servletContext = this.getServletContext();
        ContextCache contextCache = ContextCache.get(servletContext);
        if (response.isCommitted()) {
            this.doInclude(uri, request, response);
            return;
        }
        if (contextCache.shouldDoSecureForwards() && !(sp = PageFlowUtils.getSecurityProtocol(uri, servletContext, request)).equals((Object)SecurityProtocol.UNSPECIFIED)) {
            try {
                if (request.isSecure()) {
                    if (sp.equals((Object)SecurityProtocol.UNSECURE)) {
                        int listenPort = this._serverAdapter.getListenPort(request);
                        securityRedirected = this.changeScheme(uri, SCHEME_UNSECURE, listenPort, request, response);
                    }
                } else if (sp.equals((Object)SecurityProtocol.SECURE)) {
                    int secureListenPort = this._serverAdapter.getSecureListenPort(request);
                    securityRedirected = this.changeScheme(uri, SCHEME_SECURE, secureListenPort, request, response);
                }
            }
            catch (URISyntaxException e) {
                _log.error((Object)("Bad forward URI " + uri), (Throwable)e);
            }
        }
        if (!securityRedirected && !this.processPageForward(uri, request, response)) {
            ForwardRedirectHandler fwdRedirectHandler = contextCache.getForwardRedirectHandler();
            fwdRedirectHandler.forward(uri, request, response);
        }
    }

    private boolean processPageForward(String pagePath, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Class pageServletClass = this._pageServletClasses.get(pagePath);
        if (pageServletClass == null) {
            String path;
            pageServletClass = Void.class;
            ClassLoader cl = DiscoveryUtils.getClassLoader();
            InputStream in = cl.getResourceAsStream(path = "META-INF/pageflow-page-servlets" + pagePath + ".properties");
            if (in != null) {
                String className = null;
                try {
                    Properties props = new Properties();
                    props.load(in);
                    className = props.getProperty(this._serverAdapter.getPlatformName());
                    if (className == null) {
                        className = props.getProperty("default");
                    }
                    if (className != null) {
                        pageServletClass = cl.loadClass(className);
                        if (Servlet.class.isAssignableFrom(pageServletClass)) {
                            if (_log.isInfoEnabled()) {
                                _log.info((Object)("Loaded page Servlet class " + className + " for path " + pagePath));
                            }
                        } else {
                            pageServletClass = Void.class;
                            _log.error((Object)("Page Servlet class " + className + " for path " + pagePath + " does not extend " + Servlet.class.getName()));
                        }
                    }
                }
                catch (IOException e) {
                    _log.error((Object)("Error while reading " + path), (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    _log.error((Object)("Error while loading page Servlet class " + className), (Throwable)e);
                }
            }
            this._pageServletClasses.put(pagePath, pageServletClass);
        }
        if (pageServletClass.equals(Void.class)) {
            return false;
        }
        try {
            Servlet pageServlet = (Servlet)pageServletClass.newInstance();
            pageServlet.init((ServletConfig)new PageServletConfig(pagePath));
            this._pageServletFilter.doFilter((ServletRequest)request, (ServletResponse)response, new PageServletFilterChain(pageServlet));
            return true;
        }
        catch (InstantiationException e) {
            _log.error((Object)("Error while instantiating page Servlet of type " + pageServletClass.getName()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            _log.error((Object)("Error while instantiating page Servlet of type " + pageServletClass.getName()), (Throwable)e);
        }
        return false;
    }

    protected void processNoCache(HttpServletRequest request, HttpServletResponse response) {
        if (this.moduleConfig.getControllerConfig().getNocache() || !this._serverAdapter.isInProductionMode()) {
            ServletUtils.preventCache((HttpServletResponse)response);
            PageFlowJspFilter.preventCache(request);
        }
    }

    protected ActionForward processActionPerform(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        InterceptorForward originalForward;
        InterceptorForward interceptorForward;
        String actionName;
        ActionInterceptorChain interceptorChain;
        FlowController fc;
        PageFlowController pfc = null;
        ServletContext servletContext = this.getServletContext();
        if (action instanceof FlowControllerAction && (fc = ((FlowControllerAction)action).getFlowController()) instanceof PageFlowController) {
            pfc = (PageFlowController)fc;
        }
        if (!ActionInterceptorChain.isReturningFromIntercept(request) && pfc != null) {
            InterceptorForward interceptorForward2;
            String actionName2 = InternalUtils.getActionName(mapping);
            ActionInterceptorChain interceptorChain2 = ActionInterceptorChain.getBeforeActionChain(actionName2, request, servletContext);
            if (interceptorChain2 != null && (interceptorForward2 = interceptorChain2.doIntercept(request, response, null, pfc, actionName2)) != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Before-action intercepted in processMapping; forwarding to " + interceptorForward2.getPath()));
                }
                return interceptorForward2;
            }
        } else {
            ActionInterceptorChain.setIsReturningFromIntercept(request, false);
        }
        ActionForward ret = super.processActionPerform(request, response, action, form, mapping);
        if (pfc != null && (interceptorChain = ActionInterceptorChain.getAfterActionChain(actionName = InternalUtils.getActionName(mapping), request, servletContext)) != null && (interceptorForward = interceptorChain.doIntercept(request, response, originalForward = ret != null ? new InterceptorForward(ret, servletContext) : null, pfc, actionName)) != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("After-action intercepted in processMapping; forwarding to " + interceptorForward.getPath()));
            }
            return interceptorForward;
        }
        return ret;
    }

    void processActionForward(HttpServletRequest request, HttpServletResponse response, ActionForward forward) throws IOException, ServletException {
        this.processForwardConfig(request, response, (ForwardConfig)forward);
    }

    private class PageServletConfig
    implements ServletConfig {
        private String _pagePath;

        public PageServletConfig(String pagePath) {
            this._pagePath = pagePath;
        }

        public String getServletName() {
            return this._pagePath;
        }

        public ServletContext getServletContext() {
            return PageFlowRequestProcessor.this.getServletContext();
        }

        public String getInitParameter(String s) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
    }

    private static class PageServletFilterChain
    implements FilterChain {
        private Servlet _pageServlet;

        public PageServletFilterChain(Servlet pageServlet) {
            this._pageServlet = pageServlet;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            this._pageServlet.service(request, response);
        }
    }

    private class PageServletFilter
    extends PageFlowPageFilter {
        public PageServletFilter() {
            super(PageFlowRequestProcessor.this.getServletContext());
        }

        protected Set getValidFileExtensions() {
            return null;
        }
    }

    public static class ExceptionHandledAction
    extends Action {
        public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
            assert (mapping instanceof ExceptionHandledActionMapping) : mapping.getClass().getName();
            return ((ExceptionHandledActionMapping)mapping).getActionForward();
        }
    }

    protected static class ExceptionHandledActionMapping
    extends ActionMapping {
        private ActionForward _fwd;

        public ExceptionHandledActionMapping(String actionPath, ActionForward fwd) {
            this.setPath(actionPath);
            this._fwd = fwd;
        }

        public String getType() {
            return ExceptionHandledAction.class.getName();
        }

        public ActionForward getActionForward() {
            return this._fwd;
        }

        public boolean getValidate() {
            return false;
        }
    }

    private static class RehydratedMultipartRequestWrapper
    extends MultipartRequestWrapper {
        public RehydratedMultipartRequestWrapper(HttpServletRequest req) {
            super(req);
            MultipartRequestHandler handler = MultipartRequestUtils.getCachedMultipartHandler(req);
            if (handler != null) {
                ScopedRequest scopedRequest = ScopedServletUtils.unwrapRequest((ServletRequest)req);
                Hashtable textElements = handler.getTextElements();
                this.parameters = scopedRequest != null ? scopedRequest.filterParameterMap((Map)textElements) : textElements;
            }
        }
    }
}

