/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.io.Serializable;
import java.util.Stack;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.interceptor.ActionInterceptor;
import org.apache.beehive.netui.pageflow.interceptor.ActionInterceptorChain;
import org.apache.beehive.netui.pageflow.interceptor.InterceptorForward;
import org.apache.beehive.netui.pageflow.internal.ServerAdapterManager;
import org.apache.beehive.netui.pageflow.scoping.ScopedServletUtils;
import org.apache.beehive.netui.util.logging.Logger;

public class PageFlowStack
implements HttpSessionBindingListener,
Serializable {
    private static final Logger _log = Logger.getInstance(PageFlowStack.class);
    private static final String JPF_STACK_ATTR = "_netui:nestingStack";
    private Stack _stack = new Stack();

    public static final PageFlowStack get(HttpServletRequest request) {
        return PageFlowStack.get(request, true);
    }

    public static PageFlowStack get(HttpServletRequest request, boolean createIfNotExist) {
        PageFlowStack jpfStack = (PageFlowStack)ScopedServletUtils.getScopedSessionAttr((String)JPF_STACK_ATTR, (HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
        if (jpfStack == null && createIfNotExist) {
            jpfStack = new PageFlowStack();
            jpfStack.save(request);
        }
        return jpfStack;
    }

    public static void destroy(HttpServletRequest request) {
        ScopedServletUtils.removeScopedSessionAttr((String)JPF_STACK_ATTR, (HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
    }

    PageFlowController popUntil(HttpServletRequest request, Class stopAt) {
        while (!this.isEmpty()) {
            PageFlowController popped = this.pop(request).getPageFlow();
            if (popped.getClass().equals(stopAt)) {
                if (this.isEmpty()) {
                    PageFlowStack.destroy(request);
                }
                return popped;
            }
            popped.destroy(request.getSession());
        }
        PageFlowStack.destroy(request);
        return null;
    }

    PageFlowController popUntil(HttpServletRequest request, int index) {
        for (int i = this._stack.size() - 1; i > index; --i) {
            this.pop(request);
        }
        return this.pop(request).getPageFlow();
    }

    int lastIndexOf(HttpServletRequest request, Class target) {
        for (int i = this._stack.size() - 1; i >= 0; --i) {
            if (!((PushedPageFlow)this._stack.elementAt(i)).getPageFlow().getClass().equals(target)) continue;
            return i;
        }
        return -1;
    }

    void ensureFailover(HttpServletRequest request, ServletContext servletContext) {
        String name = ScopedServletUtils.getScopedSessionAttrName((String)JPF_STACK_ATTR, (HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
        ServerAdapterManager.getServerAdapter(servletContext).ensureFailover(name, this, request);
    }

    void save(HttpServletRequest request) {
        ScopedServletUtils.setScopedSessionAttr((String)JPF_STACK_ATTR, (Object)this, (HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
    }

    PageFlowStack() {
    }

    public void push(PageFlowController pageFlow, HttpServletRequest request) {
        pageFlow.setIsOnNestingStack(true);
        ActionInterceptor interceptor = ActionInterceptorChain.getActiveInterceptor(request);
        InterceptorForward interceptedForward = ActionInterceptorChain.getInterceptedForward(request, true);
        this._stack.push(new PushedPageFlow(pageFlow, interceptor, interceptedForward));
        this.ensureFailover(request, pageFlow.getServletContext());
    }

    public PushedPageFlow pop(HttpServletRequest request) {
        PushedPageFlow ppf = (PushedPageFlow)this._stack.pop();
        PageFlowController pfc = ppf.getPageFlow();
        pfc.setIsOnNestingStack(false);
        if (request != null) {
            this.ensureFailover(request, pfc.getServletContext());
        }
        return ppf;
    }

    public PushedPageFlow peek() {
        return (PushedPageFlow)this._stack.peek();
    }

    public boolean isEmpty() {
        return this._stack.isEmpty();
    }

    public int size() {
        return this._stack.size();
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"The page flow stack is being unbound from the session.");
        }
        while (!this.isEmpty()) {
            PageFlowController jpf = this.pop(null).getPageFlow();
            jpf.destroy(event.getSession());
        }
    }

    Stack getLegacyStack() {
        Stack<PageFlowController> ret = new Stack<PageFlowController>();
        for (int i = 0; i < this._stack.size(); ++i) {
            ret.push(((PushedPageFlow)this._stack.get(i)).getPageFlow());
        }
        return ret;
    }

    public static class PushedPageFlow
    implements Serializable {
        private PageFlowController _pageFlow;
        private ActionInterceptor _interceptor;
        private InterceptorForward _interceptedForward;

        public PushedPageFlow(PageFlowController pageFlow, ActionInterceptor interceptor, InterceptorForward interceptedFwd) {
            this._pageFlow = pageFlow;
            this._interceptor = interceptor;
            this._interceptedForward = interceptedFwd;
        }

        public PageFlowController getPageFlow() {
            return this._pageFlow;
        }

        public void setPageFlow(PageFlowController pageFlow) {
            this._pageFlow = pageFlow;
        }

        public ActionInterceptor getInterceptor() {
            return this._interceptor;
        }

        public void setInterceptor(ActionInterceptor interceptor) {
            this._interceptor = interceptor;
        }

        public InterceptorForward getInterceptedForward() {
            return this._interceptedForward;
        }

        public void setInterceptedForward(InterceptorForward interceptedForward) {
            this._interceptedForward = interceptedForward;
        }
    }
}

