/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.beehive.netui.pageflow.MultipartRequestUtils;
import org.apache.beehive.netui.pageflow.RequestParameterHandler;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.script.Expression;
import org.apache.beehive.netui.script.ExpressionEvaluator;
import org.apache.beehive.netui.script.ExpressionEvaluatorFactory;
import org.apache.beehive.netui.script.ExpressionUpdateException;
import org.apache.beehive.netui.script.common.ImplicitObjectUtil;
import org.apache.beehive.netui.util.Bundle;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionForm;

public class ProcessPopulate {
    public static final String IDMAP_PARAMETER_NAME = "netuiIdMap";
    private static final Logger _logger = Logger.getInstance(ProcessPopulate.class);
    private static final String PAGE_FLOW_CONTEXT = "pageFlow";
    private static final String GLOBAL_APP_CONTEXT = "globalApp";
    private static final String WLW_TAG_HANDLER_PREFIX = "wlw-";
    private static final String WLW_TAG_HANDLER_SUFFIX = ":";
    private static final Map handlerMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPrefixHandler(String prefix, RequestParameterHandler handler) {
        Map map = handlerMap;
        synchronized (map) {
            String msg = "Register RequestParameterHandler with\n\tprefix: " + prefix + "\n\thandler: " + (handler != null ? handler.getClass().getName() : null);
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)msg);
            }
            handlerMap.put(prefix, handler);
        }
    }

    public static String writeHandlerName(String handler, String expression) {
        if (!ExpressionEvaluatorFactory.getInstance().isExpression(expression)) {
            throw new IllegalArgumentException(Bundle.getErrorString((String)"ProcessPopulate_handler_nonAtomicExpression", (Object[])new Object[]{expression}));
        }
        if (!handlerMap.containsKey(handler)) {
            throw new IllegalStateException(Bundle.getErrorString((String)"ProcessPopulate_handler_notRegistered", (Object[])new Object[]{handler}));
        }
        StringBuilder buf = new StringBuilder();
        buf.append(WLW_TAG_HANDLER_PREFIX);
        buf.append(handler);
        buf.append(WLW_TAG_HANDLER_SUFFIX);
        buf.append(expression);
        return buf.toString();
    }

    public static void populate(HttpServletRequest request, HttpServletResponse response, ActionForm form, boolean requestHasPopulated) throws ServletException {
        String key2 = null;
        HashMap strutsProperties = null;
        ExpressionEvaluator ee = ExpressionEvaluatorFactory.getInstance();
        boolean isMultipart = false;
        Map params = MultipartRequestUtils.handleMultipartRequest(request, form);
        if (params != null) {
            isMultipart = true;
        } else {
            params = request.getParameterMap();
        }
        if (params == null) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)"An error occurred checking a request for multipart status.  No model values were updated.");
            }
            return;
        }
        VariableResolver variableResolver = ImplicitObjectUtil.getUpdateVariableResolver(form, (ServletRequest)request, (ServletResponse)response, true);
        for (String key2 : params.keySet()) {
            String expr = null;
            expr = key2;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("key: " + key2 + " value type: " + params.get(key2).getClass().getName() + " value: " + params.get(key2)));
            }
            try {
                Object paramsValue = params.get(key2);
                if (ee.containsExpression(expr)) {
                    Object updateValue = null;
                    if (!isMultipart || paramsValue instanceof String[]) {
                        String[] values = (String[])paramsValue;
                        if (expr.startsWith(WLW_TAG_HANDLER_PREFIX)) {
                            if (_logger.isDebugEnabled()) {
                                _logger.debug((Object)"Found an expression requiring a TAG HANDLER");
                            }
                            ExpressionUpdateNode node = ProcessPopulate.doTagHandler(key2, expr, values, request);
                            expr = node.expression;
                            values = node.values;
                        }
                        updateValue = values != null && values.length == 1 ? values[0] : values;
                    } else {
                        updateValue = params.get(key2);
                    }
                    try {
                        if (!ee.isExpression(expr)) continue;
                        if (!requestHasPopulated) {
                            ee.update(expr, updateValue, variableResolver, true);
                            continue;
                        }
                        Expression pe = ee.parseExpression(expr);
                        String contextName = pe.getContext();
                        if (contextName.equals(PAGE_FLOW_CONTEXT) || contextName.equals(GLOBAL_APP_CONTEXT)) continue;
                        ee.update(expr, updateValue, variableResolver, true);
                    }
                    catch (ExpressionUpdateException e) {
                        String s = Bundle.getString((String)"ExprUpdateError", (Object[])new Object[]{expr, e});
                        System.err.println(s);
                        if (_logger.isErrorEnabled()) {
                            _logger.error((Object)s);
                        }
                        InternalUtils.addBindingUpdateError((ServletRequest)request, expr, s, e);
                    }
                    continue;
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("HTTP request parameter key \"" + key2 + "\" is not an expression, handle with Struts"));
                }
                if (strutsProperties == null) {
                    strutsProperties = new HashMap();
                }
                strutsProperties.put(key2, paramsValue);
            }
            catch (Exception e) {
                String s = Bundle.getString((String)"ProcessPopulate_exprUpdateError", (Object[])new Object[]{expr, e});
                System.err.println(s);
                if (_logger.isWarnEnabled()) {
                    _logger.warn((Object)s, (Throwable)e);
                }
                InternalUtils.addBindingUpdateError((ServletRequest)request, expr, s, e);
            }
        }
        ProcessPopulate.handleStrutsProperties(strutsProperties, form);
    }

    static final ExpressionUpdateNode doTagHandler(String key, String expression, String[] values, HttpServletRequest request) {
        String handlerName;
        RequestParameterHandler handler;
        String[] _values = values;
        String expr = expression;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Found prefixed tag; handlerName: " + key.substring(WLW_TAG_HANDLER_PREFIX.length(), key.indexOf(WLW_TAG_HANDLER_SUFFIX))));
        }
        if ((handler = (RequestParameterHandler)handlerMap.get(handlerName = expression.substring(WLW_TAG_HANDLER_PREFIX.length(), expression.indexOf(WLW_TAG_HANDLER_SUFFIX)))) != null) {
            expr = expression.substring(expression.indexOf(WLW_TAG_HANDLER_SUFFIX) + 1);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("found handler for prefix \"" + handlerName + "\" type: " + (handler != null ? handler.getClass().getName() : null) + "\n\t" + "key: \"" + key + "\" expr: \"" + expr + "\""));
            }
            ExpressionUpdateNode node = new ExpressionUpdateNode();
            node.expression = expr;
            node.values = _values;
            handler.process(request, key, expression, node);
            return node;
        }
        throw new IllegalStateException("Request parameter references a tag handler prefix \"" + handlerName + "\" that is not registered for expression \"" + key + "\"");
    }

    private static final void handleStrutsProperties(Map strutsProperties, ActionForm form) {
        if (strutsProperties != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"Handle Struts request parameters.");
            }
            try {
                BeanUtils.populate((Object)form, (Map)strutsProperties);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception processing bean and request parameters: ", e);
            }
        }
    }

    public static final class ExpressionUpdateNode {
        public String expression = null;
        public String[] values = null;

        private ExpressionUpdateNode() {
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("expression: " + this.expression + "\n");
            if (this.values != null) {
                for (int i = 0; i < this.values.length; ++i) {
                    buf.append("value[" + i + "]: " + this.values[i]);
                }
            } else {
                buf.append("values are null");
            }
            return buf.toString();
        }
    }
}

