/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.interceptor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.interceptor.ActionInterceptor;
import org.apache.beehive.netui.pageflow.interceptor.ActionInterceptorChainConfig;
import org.apache.beehive.netui.pageflow.interceptor.ActionInterceptorConfig;
import org.apache.beehive.netui.pageflow.interceptor.ActionInterceptorsConfig;
import org.apache.beehive.netui.pageflow.interceptor.InterceptorForward;
import org.apache.beehive.netui.pageflow.interceptor.OriginalForward;
import org.apache.beehive.netui.util.logging.Logger;

public class ActionInterceptorChain
implements Serializable {
    private ActionInterceptor[] _actionInterceptors;
    public static final String CONFIG_FILE = "/WEB-INF/pageflow-action-interceptor.xml";
    private static final String CONFIG_ATTR = "_netui:actionInterceptorConfig";
    private static final String BEFOREACTION_CACHE_ATTR = "_netui:beforeActionChain";
    private static final String AFTERACTION_CACHE_ATTR = "_netui:afterActionChain";
    private static final String ACTIVE_INTERCEPTOR_ATTR = "_netui:activeInterceptor";
    private static final String INTERCEPTED_FWD_ATTR = "_netui:interceptedFwd";
    private static final String IS_RETURNING_ATTR = "_netui:returningFromIntercept";
    private static final Logger _log = Logger.getInstance(ActionInterceptorChain.class);
    private static final ActionInterceptorChain NULL_CHAIN = new NullActionInterceptorChain();

    public ActionInterceptor[] getActionInterceptors() {
        return this._actionInterceptors;
    }

    public void setActionInterceptors(ActionInterceptor[] actionInterceptors) {
        this._actionInterceptors = actionInterceptors;
    }

    public static ActionInterceptorChain getBeforeActionChain(String actionName, HttpServletRequest request, ServletContext servletContext) {
        return ActionInterceptorChain.getActionChain(actionName, request, servletContext, BEFOREACTION_CACHE_ATTR, 1);
    }

    public static ActionInterceptorChain getAfterActionChain(String actionName, HttpServletRequest request, ServletContext servletContext) {
        return ActionInterceptorChain.getActionChain(actionName, request, servletContext, AFTERACTION_CACHE_ATTR, 2);
    }

    public static ActionInterceptor getActiveInterceptor(HttpServletRequest request) {
        return (ActionInterceptor)request.getAttribute(ACTIVE_INTERCEPTOR_ATTR);
    }

    public static InterceptorForward getInterceptedForward(HttpServletRequest request, boolean consume) {
        InterceptorForward ret = (InterceptorForward)((Object)request.getAttribute(INTERCEPTED_FWD_ATTR));
        if (consume) {
            request.removeAttribute(INTERCEPTED_FWD_ATTR);
        }
        return ret;
    }

    public static void setIsReturningFromIntercept(HttpServletRequest request, boolean isReturning) {
        if (isReturning) {
            request.setAttribute(IS_RETURNING_ATTR, (Object)Boolean.TRUE);
        } else {
            request.removeAttribute(IS_RETURNING_ATTR);
        }
    }

    public static boolean isReturningFromIntercept(HttpServletRequest request) {
        return request.getAttribute(IS_RETURNING_ATTR) != null;
    }

    public InterceptorForward doIntercept(HttpServletRequest request, HttpServletResponse response, InterceptorForward originalForward, PageFlowController pageFlow, String actionName) {
        if (this._actionInterceptors != null) {
            for (int i = 0; i < this._actionInterceptors.length; ++i) {
                ActionInterceptor interceptor = this._actionInterceptors[i];
                InterceptorForward interceptorForward = null;
                try {
                    interceptorForward = interceptor.doIntercept(request, response, pageFlow, originalForward, actionName);
                }
                catch (Exception e) {
                    _log.error((Object)("Exception in " + interceptor.getClass().getName() + ".doIntercept"), (Throwable)e);
                }
                if (interceptorForward == null) continue;
                if (originalForward == null) {
                    originalForward = new OriginalForward(request);
                }
                request.setAttribute(ACTIVE_INTERCEPTOR_ATTR, (Object)interceptor);
                request.setAttribute(INTERCEPTED_FWD_ATTR, (Object)originalForward);
                return interceptorForward;
            }
        }
        return null;
    }

    protected ActionInterceptorChain(ActionInterceptor[] interceptors) {
        this._actionInterceptors = interceptors;
    }

    private static ActionInterceptorChain getActionChain(String actionName, HttpServletRequest request, ServletContext servletContext, String cacheAttr, int type) {
        ActionInterceptorChain ret;
        ActionInterceptorConfig[] interceptors;
        String requestURI;
        ActionInterceptorChain cachedChain;
        assert (actionName == actionName);
        ConcurrentHashMap<String, ActionInterceptorChain> cache = (ConcurrentHashMap<String, ActionInterceptorChain>)servletContext.getAttribute(cacheAttr);
        if (cache == null) {
            cache = new ConcurrentHashMap<String, ActionInterceptorChain>();
            servletContext.setAttribute(cacheAttr, cache);
        }
        if ((cachedChain = (ActionInterceptorChain)cache.get(requestURI = request.getRequestURI())) != null) {
            return cachedChain instanceof NullActionInterceptorChain ? null : cachedChain;
        }
        ActionInterceptorsConfig config = ActionInterceptorChain.getConfig(servletContext);
        ActionInterceptorChainConfig chainConfig = config.getChainConfig(type);
        ActionInterceptorConfig[] actionInterceptorConfigArray = interceptors = chainConfig != null ? chainConfig.getInterceptors() : null;
        if (interceptors != null && interceptors.length > 0) {
            ArrayList<ActionInterceptor> interceptorsArray = new ArrayList<ActionInterceptor>();
            for (int i = 0; i < interceptors.length; ++i) {
                ActionInterceptorConfig interceptorConfig = interceptors[i];
                String className = interceptorConfig.getInterceptorClass();
                try {
                    Class<?> interceptorClass = Class.forName(className);
                    ActionInterceptor interceptor = (ActionInterceptor)interceptorClass.newInstance();
                    interceptor.init(interceptorConfig, servletContext);
                    interceptorsArray.add(interceptor);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    _log.error((Object)("Could not find action-interceptor class " + className));
                    continue;
                }
                catch (InstantiationException e) {
                    _log.error((Object)("Could not instantiate action-interceptor class " + className), (Throwable)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    _log.error((Object)("Could not instantiate action-interceptor class " + className), (Throwable)e);
                    continue;
                }
                catch (ClassCastException e) {
                    _log.error((Object)("Action-interceptor class " + className + " does not implement " + ActionInterceptor.class.getName()));
                }
            }
            ActionInterceptor[] ar = interceptorsArray.toArray(new ActionInterceptor[interceptorsArray.size()]);
            ret = new ActionInterceptorChain(ar);
        } else {
            ret = NULL_CHAIN;
        }
        cache.put(requestURI, ret);
        return ret;
    }

    private static ActionInterceptorsConfig getConfig(ServletContext servletContext) {
        ActionInterceptorsConfig config = (ActionInterceptorsConfig)servletContext.getAttribute(CONFIG_ATTR);
        if (config == null) {
            config = new ActionInterceptorsConfig();
            servletContext.setAttribute(CONFIG_ATTR, (Object)config);
        }
        return config;
    }

    private static class NullActionInterceptorChain
    extends ActionInterceptorChain {
        public NullActionInterceptorChain() {
            super(null);
        }
    }
}

