/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.interceptor;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.beehive.netui.pageflow.Forward;
import org.apache.beehive.netui.pageflow.interceptor.InterceptorForward;
import org.apache.beehive.netui.util.logging.Logger;

class OriginalForward
extends InterceptorForward {
    private Map _savedAttrs;
    private static final Logger _log = Logger.getInstance(OriginalForward.class);

    OriginalForward(Forward fwd, HttpServletRequest request) {
        super(fwd);
        this.saveRequestAttrs(request);
    }

    OriginalForward(HttpServletRequest request) {
        super(request);
        this.saveRequestAttrs(request);
    }

    private void saveRequestAttrs(HttpServletRequest request) {
        this._savedAttrs = new HashMap();
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String attrName = (String)e.nextElement();
            Object attrVal = request.getAttribute(attrName);
            if (attrVal instanceof Serializable) {
                this._savedAttrs.put(attrName, attrVal);
                continue;
            }
            if (!_log.isWarnEnabled()) continue;
            _log.warn((Object)("Dropping non-serializable request attribute " + attrName + " (" + attrVal + ")."));
        }
    }

    public void rehydrateRequest(HttpServletRequest request) {
        if (this._savedAttrs != null) {
            for (Map.Entry entry : this._savedAttrs.entrySet()) {
                String attrName = (String)entry.getKey();
                if (request.getAttribute(attrName) != null) continue;
                request.setAttribute(attrName, entry.getValue());
            }
        }
    }
}

