/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.internal;

import java.io.Serializable;
import javax.servlet.ServletContext;
import org.apache.beehive.netui.pageflow.PageFlowActionServlet;
import org.apache.beehive.netui.pageflow.PageFlowContextListener;
import org.apache.beehive.netui.pageflow.handler.ExceptionsHandler;
import org.apache.beehive.netui.pageflow.handler.ForwardRedirectHandler;
import org.apache.beehive.netui.pageflow.handler.Handler;
import org.apache.beehive.netui.pageflow.handler.LoginHandler;
import org.apache.beehive.netui.pageflow.handler.ReloadableClassHandler;
import org.apache.beehive.netui.pageflow.internal.DefaultExceptionsHandler;
import org.apache.beehive.netui.pageflow.internal.DefaultForwardRedirectHandler;
import org.apache.beehive.netui.pageflow.internal.DefaultLoginHandler;
import org.apache.beehive.netui.pageflow.internal.DefaultReloadableClassHandler;
import org.apache.beehive.netui.util.config.ConfigUtil;
import org.apache.beehive.netui.util.config.bean.NetuiConfigDocument;
import org.apache.beehive.netui.util.config.bean.PageflowConfig;
import org.apache.beehive.netui.util.config.bean.PageflowHandlers;
import org.apache.beehive.netui.util.logging.Logger;

public class ContextCache
implements Serializable {
    private static final Logger _log = Logger.getInstance(ContextCache.class);
    private static final String CACHE_ATTR = "_netui:_cache";
    private static final String DEFAULT_LOGIN_HANDLER_CLASS = DefaultLoginHandler.class.getName();
    private static final String DEFAULT_FWD_REDIRECT_HANDLER_CLASS = DefaultForwardRedirectHandler.class.getName();
    private static final String DEFAULT_RELOADABLE_CLASS_HANDLER_CLASS = DefaultReloadableClassHandler.class.getName();
    private static final String DEFAULT_EXCEPTIONS_HANDLER_CLASS = DefaultExceptionsHandler.class.getName();
    private static final int DEFAULT_MAX_FORWARDS_PER_REQUEST = 25;
    private static final int DEFAULT_MAX_NESTING_STACK_DEPTH = 10;
    public static final int serialVersionUID = 1;
    private boolean _secureForwards = false;
    private int _forwardOverflowCount;
    private int _nestingOverflowCount;
    private ForwardRedirectHandler _forwardRedirectHandler = null;
    private LoginHandler _loginHandler = null;
    private ReloadableClassHandler _reloadableClassHandler = null;
    private ExceptionsHandler _exceptionsHandler = null;

    public ForwardRedirectHandler getForwardRedirectHandler() {
        return this._forwardRedirectHandler;
    }

    public LoginHandler getLoginHandler() {
        return this._loginHandler;
    }

    public ReloadableClassHandler getReloadableClassHandler() {
        return this._reloadableClassHandler;
    }

    public ExceptionsHandler getExceptionsHandler() {
        return this._exceptionsHandler;
    }

    public static ContextCache get(ServletContext servletContext) {
        ContextCache cache = (ContextCache)servletContext.getAttribute(CACHE_ATTR);
        if (cache == null) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)("Page Flow ServletContext cache not initialized; either " + PageFlowActionServlet.class.getName() + " must be the Struts action servlet, or " + PageFlowContextListener.class.getName() + " must be registered as a listener in web.xml."));
            }
            return ContextCache.init(servletContext);
        }
        cache.reinit(servletContext);
        return cache;
    }

    private void reinit(ServletContext servletContext) {
        this._exceptionsHandler.reinit(servletContext);
        this._forwardRedirectHandler.reinit(servletContext);
        this._loginHandler.reinit(servletContext);
        this._reloadableClassHandler.reinit(servletContext);
    }

    public static ContextCache init(ServletContext servletContext) {
        ContextCache cache = new ContextCache(servletContext);
        servletContext.setAttribute(CACHE_ATTR, (Object)cache);
        return cache;
    }

    private void loadLegacySettings(ServletContext servletContext) {
        Integer forwardOverflowCount;
        PageflowConfig pageflowConfig = ConfigUtil.getConfig().getPageflowConfig();
        if (pageflowConfig == null) {
            pageflowConfig = ConfigUtil.getConfig().addNewPageflowConfig();
        }
        this._forwardOverflowCount = (forwardOverflowCount = ContextCache.loadLegacyParam("jpf-forward-overflow-count", servletContext, "max-forwards-per-request")) != null ? forwardOverflowCount : (pageflowConfig.isSetMaxForwardsPerRequest() ? pageflowConfig.getMaxForwardsPerRequest() : 25);
        Integer nestingOverflowCount = ContextCache.loadLegacyParam("jpf-nesting-overflow-count", servletContext, "max-nesting-stack-depth");
        this._nestingOverflowCount = nestingOverflowCount != null ? nestingOverflowCount : (pageflowConfig.isSetMaxNestingStackDepth() ? pageflowConfig.getMaxNestingStackDepth() : 10);
        String doSecureForwards = servletContext.getInitParameter("jpf-secure-forwards");
        if (doSecureForwards != null) {
            _log.warn((Object)"Servlet context-param jpf-secure-forwards is deprecated; use the ensure-secure-forwards element within pageflow-config in /WEB-INF/netui-config.xml");
            this._secureForwards = Boolean.parseBoolean(doSecureForwards);
        } else {
            this._secureForwards = pageflowConfig.getEnsureSecureForwards();
        }
    }

    private ContextCache(ServletContext servletContext) {
        this.loadLegacySettings(servletContext);
        NetuiConfigDocument.NetuiConfig netuiConfig = ConfigUtil.getConfig();
        PageflowHandlers handlers = netuiConfig.getPageflowHandlers();
        if (handlers != null) {
            this._loginHandler = (LoginHandler)this.getHandlerInstance(handlers.getLoginHandlerClass(), DEFAULT_LOGIN_HANDLER_CLASS, LoginHandler.class, servletContext);
            this._forwardRedirectHandler = (ForwardRedirectHandler)this.getHandlerInstance(handlers.getForwardRedirectHandlerClass(), DEFAULT_FWD_REDIRECT_HANDLER_CLASS, ForwardRedirectHandler.class, servletContext);
            this._reloadableClassHandler = (ReloadableClassHandler)this.getHandlerInstance(handlers.getReloadableClassHandlerClass(), DEFAULT_RELOADABLE_CLASS_HANDLER_CLASS, ReloadableClassHandler.class, servletContext);
            this._exceptionsHandler = (ExceptionsHandler)this.getHandlerInstance(handlers.getExceptionsHandlerClass(), DEFAULT_EXCEPTIONS_HANDLER_CLASS, ExceptionsHandler.class, servletContext);
        } else {
            this._loginHandler = (LoginHandler)this.getHandlerInstance(DEFAULT_LOGIN_HANDLER_CLASS, null, LoginHandler.class, servletContext);
            this._forwardRedirectHandler = (ForwardRedirectHandler)this.getHandlerInstance(DEFAULT_FWD_REDIRECT_HANDLER_CLASS, null, ForwardRedirectHandler.class, servletContext);
            this._reloadableClassHandler = (ReloadableClassHandler)this.getHandlerInstance(DEFAULT_RELOADABLE_CLASS_HANDLER_CLASS, null, ReloadableClassHandler.class, servletContext);
            this._exceptionsHandler = (ExceptionsHandler)this.getHandlerInstance(DEFAULT_EXCEPTIONS_HANDLER_CLASS, null, ExceptionsHandler.class, servletContext);
        }
    }

    private Handler getHandlerInstance(String className, String alternateClassName, Class desiredClass, ServletContext servletContext) {
        if (className != null) {
            _log.info((Object)("Loading handler class " + className));
            try {
                Object instance = Class.forName(className).newInstance();
                if (desiredClass.isInstance(instance)) {
                    Handler handlerInstance = (Handler)instance;
                    handlerInstance.init(servletContext);
                    return handlerInstance;
                }
                _log.error((Object)("Handler instance is of wrong type; expected " + desiredClass.getName() + ", got " + instance.getClass().getName()));
            }
            catch (ClassNotFoundException e) {
                _log.error((Object)("Could not find Handler class " + className), (Throwable)e);
            }
            catch (InstantiationException e) {
                _log.error((Object)("Could not instantiate Handler of type " + className), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                _log.error((Object)("Could not instantiate Handler of type " + className), (Throwable)e);
            }
        }
        if (alternateClassName != null) {
            return this.getHandlerInstance(alternateClassName, null, desiredClass, servletContext);
        }
        return null;
    }

    public boolean shouldDoSecureForwards() {
        return this._secureForwards;
    }

    public int getForwardOverflowCount() {
        return this._forwardOverflowCount;
    }

    public int getNestingOverflowCount() {
        return this._nestingOverflowCount;
    }

    private static Integer loadLegacyParam(String paramName, ServletContext servletContext, String configElementName) {
        String strVal = servletContext.getInitParameter(paramName);
        if (strVal != null) {
            _log.warn((Object)("Servlet context-param " + paramName + "is deprecated; use the " + configElementName + " element within pageflow-config in " + "/WEB-INF/netui-config.xml"));
            try {
                return Integer.parseInt(strVal);
            }
            catch (NumberFormatException e) {
                _log.error((Object)("Could not parse integer value from context-param " + paramName + '.'));
            }
        }
        return null;
    }
}

