/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.internal;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.pageflow.PageFlowStack;
import org.apache.beehive.netui.pageflow.handler.ForwardRedirectHandler;
import org.apache.beehive.netui.pageflow.internal.ContextCache;
import org.apache.beehive.netui.pageflow.internal.DefaultHandler;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.pageflow.internal.RequestValues;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.upload.MultipartRequestWrapper;

public class DefaultForwardRedirectHandler
extends DefaultHandler
implements ForwardRedirectHandler {
    private static final Logger _log = Logger.getInstance(DefaultForwardRedirectHandler.class);

    public void redirect(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.sendRedirect(response.encodeRedirectURL(uri));
    }

    public void forward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd;
        int forwardOverflowCount;
        ContextCache contextCache = ContextCache.get(this.getServletContext());
        int requestCount = RequestValues.getForwardedRequestCount((ServletRequest)request);
        if (requestCount > (forwardOverflowCount = contextCache.getForwardOverflowCount())) {
            InternalUtils.sendDevTimeError("PageFlow_Forward_Overflow", null, 500, request, response, this.getServletContext(), forwardOverflowCount, uri);
            return;
        }
        PageFlowStack pfStack = PageFlowStack.get(request, false);
        int nestingOverflowCount = contextCache.getNestingOverflowCount();
        if (pfStack != null && pfStack.size() > nestingOverflowCount) {
            InternalUtils.sendDevTimeError("PageFlow_Nesting_Overflow", null, 500, request, response, this.getServletContext(), pfStack.size(), nestingOverflowCount);
            return;
        }
        RequestValues.setForwardedRequestCount((ServletRequest)request, requestCount + 1);
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        if ((rd = request.getRequestDispatcher(uri)) == null) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)("Could not get requestDispatcher for URI " + uri));
            }
            response.sendError(404);
            return;
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }
}

