/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.internal;

import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.beehive.netui.core.urls.MutableURI;
import org.apache.beehive.netui.core.urls.URLRewriter;
import org.apache.beehive.netui.pageflow.ServerAdapter;
import org.apache.beehive.netui.pageflow.internal.ServerAdapterManager;
import org.apache.beehive.netui.pageflow.util.TemplateHelper;
import org.apache.beehive.netui.util.logging.Logger;

public class DefaultURLRewriter
extends URLRewriter {
    private static final Logger _log = Logger.getInstance(DefaultURLRewriter.class);

    public String rewriteName(ServletContext servletContext, ServletRequest request, String name) {
        return name;
    }

    public void rewriteURL(ServletContext servletContext, ServletRequest request, ServletResponse response, MutableURI url, URLRewriter.URLType type, boolean needsToBeSecure) {
        String scopeID;
        String templateType = org.apache.beehive.netui.pageflow.util.URLRewriter.ACTION_UNSECURE;
        if (type.equals((Object)URLRewriter.URLType.ACTION)) {
            templateType = needsToBeSecure ? org.apache.beehive.netui.pageflow.util.URLRewriter.ACTION_SECURE : org.apache.beehive.netui.pageflow.util.URLRewriter.ACTION_UNSECURE;
        } else if (type.equals((Object)URLRewriter.URLType.RESOURCE)) {
            templateType = needsToBeSecure ? org.apache.beehive.netui.pageflow.util.URLRewriter.RESOURCE_SECURE : org.apache.beehive.netui.pageflow.util.URLRewriter.RESOURCE_UNSECURE;
        }
        TemplateHelper templateHelper = new TemplateHelper((HttpServletRequest)request, (HttpServletResponse)response);
        if (templateHelper.hasTemplateRef(templateType)) {
            String templateName = templateHelper.getTemplateName(templateType);
            templateHelper.setTemplate(templateName);
            templateHelper.setUrl(url.toString());
            String templateURI = templateHelper.toString();
            try {
                MutableURI uri = new MutableURI(templateURI);
                url.setScheme(uri.getScheme());
                url.setUserInfo(uri.getUserInfo());
                url.setHost(uri.getHost());
                url.setPort(uri.getPort());
                url.setPath(uri.getPath());
                url.setQuery(null);
                url.addParameters(uri.getParameters(), true);
                url.setFragment(uri.getFragment());
            }
            catch (URISyntaxException e) {
                _log.error((Object)("Invalid URI from template " + templateName + ": " + templateURI));
            }
        } else {
            ServerAdapter serverAdapter = ServerAdapterManager.getServerAdapter(servletContext);
            if (!url.isAbsolute()) {
                if (needsToBeSecure) {
                    if (!request.isSecure()) {
                        int securePort = serverAdapter.getSecureListenPort((HttpServletRequest)request);
                        if (securePort != -1) {
                            DefaultURLRewriter.internalRewriteUrl(url, "https", securePort, request.getServerName());
                        } else if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Could not rewrite URL " + url.toString() + " to be secure because a secure port was" + " not provided by the ServerAdapter."));
                        }
                    }
                } else if (request.isSecure()) {
                    int listenPort = serverAdapter.getListenPort((HttpServletRequest)request);
                    if (listenPort != -1) {
                        DefaultURLRewriter.internalRewriteUrl(url, "http", listenPort, request.getServerName());
                    } else if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Could not rewrite URL " + url.toString() + " to be secure because a secure port was" + " not provided by the ServerAdapter."));
                    }
                }
            }
        }
        if ((scopeID = request.getParameter("jpfScopeID")) != null && url.getParameter("jpfScopeID") == null) {
            url.addParameter("jpfScopeID", scopeID, true);
        }
    }

    private static void internalRewriteUrl(MutableURI url, String protocol, int port, String serverName) {
        url.setScheme(protocol);
        url.setHost(serverName);
        url.setPort(port);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object != null && object.getClass().equals(((Object)((Object)this)).getClass());
    }

    public int hashCode() {
        return 0;
    }
}

