/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.internal;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.commons.el.EnumeratedMap;
import org.apache.commons.el.ExpressionEvaluatorImpl;

public class InternalExpressionUtils {
    private static final Logger _logger = Logger.getInstance(InternalExpressionUtils.class);

    public static final boolean evaluateCondition(String expression, Object actionForm, HttpServletRequest request, ServletContext servletContext) throws ELException {
        return (Boolean)InternalExpressionUtils.evaluate(expression, Boolean.class, actionForm, request, servletContext);
    }

    public static final String evaluateMessage(String expression, Object actionForm, HttpServletRequest request, ServletContext servletContext) throws ELException {
        return (String)InternalExpressionUtils.evaluate(expression, String.class, actionForm, request, servletContext);
    }

    private InternalExpressionUtils() {
    }

    private static final Object evaluate(String expression, Class expectedType, Object actionForm, HttpServletRequest request, ServletContext servletContext) throws ELException {
        ExpressionEvaluator ee = InternalExpressionUtils.getExpressionEvaluator();
        return ee.evaluate(expression, expectedType, InternalExpressionUtils.getVariableResolver(actionForm, request, servletContext), null);
    }

    private static final ExpressionEvaluator getExpressionEvaluator() {
        return new ExpressionEvaluatorImpl();
    }

    private static final VariableResolver getVariableResolver(Object actionForm, HttpServletRequest request, ServletContext servletContext) {
        return new SimpleActionVariableResolver(actionForm, request, servletContext);
    }

    private static class SimpleActionVariableResolver
    implements VariableResolver {
        private Object _actionForm = null;
        private HttpServletRequest _request = null;
        private ServletContext _servletContext = null;

        private SimpleActionVariableResolver(Object actionForm, HttpServletRequest request, ServletContext servletContext) {
            this._actionForm = actionForm;
            this._request = request;
            this._servletContext = servletContext;
        }

        public Object resolveVariable(String name) {
            if (name.equals("actionForm")) {
                return this._actionForm;
            }
            if (name.equals("requestScope")) {
                return SimpleActionVariableResolver.buildRequestScopeMap(this._request);
            }
            if (name.equals("sessionScope")) {
                return SimpleActionVariableResolver.buildSessionScopeMap(this._request);
            }
            if (name.equals("applicationScope")) {
                return SimpleActionVariableResolver.buildServletContextMap(this._servletContext);
            }
            if (name.equals("param")) {
                return SimpleActionVariableResolver.buildParamMap(this._request);
            }
            if (name.equals("paramValues")) {
                return SimpleActionVariableResolver.buildParamsMap(this._request);
            }
            if (name.equals("header")) {
                return SimpleActionVariableResolver.buildHeaderMap(this._request);
            }
            if (name.equals("headerValues")) {
                return SimpleActionVariableResolver.buildHeadersMap(this._request);
            }
            if (name.equals("cookie")) {
                return SimpleActionVariableResolver.buildCookieMap(this._request);
            }
            if (name.equals("initParam")) {
                return SimpleActionVariableResolver.buildInitParamMap(this._servletContext);
            }
            if (this._request.getAttribute(name) != null) {
                return this._request.getAttribute(name);
            }
            if (this._request.getSession(false) != null && this._request.getSession(false).getAttribute(name) != null) {
                return this._request.getSession(false).getAttribute(name);
            }
            return this._servletContext.getAttribute(name);
        }

        private static final Map buildCookieMap(HttpServletRequest httpServletRequest) {
            HttpServletRequest servletRequest = httpServletRequest;
            HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
            Cookie[] cookies = servletRequest.getCookies();
            for (int i = 0; i < cookies.length; ++i) {
                if (cookieMap.containsKey(cookies[i].getName())) continue;
                cookieMap.put(cookies[i].getName(), cookies[i]);
            }
            return cookieMap;
        }

        private static final Map buildHeadersMap(HttpServletRequest httpServletRequest) {
            final HttpServletRequest _servletRequest = httpServletRequest;
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return _servletRequest.getHeaderNames();
                }

                public Object getValue(Object key) {
                    return key instanceof String ? _servletRequest.getHeaders((String)key) : null;
                }

                public boolean isMutable() {
                    return false;
                }
            };
        }

        private static final Map buildHeaderMap(HttpServletRequest httpServletRequest) {
            final HttpServletRequest _servletRequest = httpServletRequest;
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return _servletRequest.getHeaderNames();
                }

                public Object getValue(Object key) {
                    return key instanceof String ? _servletRequest.getHeader((String)key) : null;
                }

                public boolean isMutable() {
                    return false;
                }
            };
        }

        private static final Map buildInitParamMap(ServletContext servletContext) {
            final ServletContext _servletContext = servletContext;
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return _servletContext.getInitParameterNames();
                }

                public Object getValue(Object key) {
                    return key instanceof String ? _servletContext.getInitParameter((String)key) : null;
                }

                public boolean isMutable() {
                    return false;
                }
            };
        }

        private static final Map buildParamsMap(HttpServletRequest servletRequest) {
            final HttpServletRequest _servletRequest = servletRequest;
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return _servletRequest.getParameterNames();
                }

                public Object getValue(Object key) {
                    return key instanceof String ? _servletRequest.getParameterValues((String)key) : null;
                }

                public boolean isMutable() {
                    return false;
                }
            };
        }

        private static final Map buildParamMap(HttpServletRequest servletRequest) {
            final HttpServletRequest _servletRequest = servletRequest;
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return _servletRequest.getParameterNames();
                }

                public Object getValue(Object key) {
                    return key instanceof String ? _servletRequest.getParameter((String)key) : null;
                }

                public boolean isMutable() {
                    return false;
                }
            };
        }

        private static final Map buildRequestScopeMap(HttpServletRequest servletRequest) {
            final HttpServletRequest _servletRequest = servletRequest;
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return _servletRequest.getAttributeNames();
                }

                public Object getValue(Object key) {
                    return key instanceof String ? _servletRequest.getAttribute((String)key) : null;
                }

                public boolean isMutable() {
                    return false;
                }
            };
        }

        private static final Map buildSessionScopeMap(HttpServletRequest servletRequest) {
            if (servletRequest.getSession(false) == null) {
                return null;
            }
            final HttpSession _session = servletRequest.getSession(false);
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return _session.getAttributeNames();
                }

                public Object getValue(Object key) {
                    return key instanceof String ? _session.getAttribute((String)key) : null;
                }

                public boolean isMutable() {
                    return false;
                }
            };
        }

        private static final Map buildServletContextMap(ServletContext servletContext) {
            final ServletContext _servletContext = servletContext;
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return _servletContext.getAttributeNames();
                }

                public Object getValue(Object key) {
                    return key instanceof String ? _servletContext.getAttribute((String)key) : null;
                }

                public boolean isMutable() {
                    return false;
                }
            };
        }
    }
}

