/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.internal;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.beehive.netui.pageflow.ActionResolver;
import org.apache.beehive.netui.pageflow.AutoRegisterActionServlet;
import org.apache.beehive.netui.pageflow.FacesBackingBean;
import org.apache.beehive.netui.pageflow.FlowController;
import org.apache.beehive.netui.pageflow.FlowControllerFactory;
import org.apache.beehive.netui.pageflow.PageFlowConstants;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.PageFlowException;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.SessionExpiredException;
import org.apache.beehive.netui.pageflow.SharedFlowController;
import org.apache.beehive.netui.pageflow.config.PageFlowActionMapping;
import org.apache.beehive.netui.pageflow.config.PageFlowControllerConfig;
import org.apache.beehive.netui.pageflow.handler.ReloadableClassHandler;
import org.apache.beehive.netui.pageflow.internal.AnyBeanActionForm;
import org.apache.beehive.netui.pageflow.internal.BindingUpdateError;
import org.apache.beehive.netui.pageflow.internal.ContextCache;
import org.apache.beehive.netui.pageflow.internal.InternalConstants;
import org.apache.beehive.netui.pageflow.internal.RequestValues;
import org.apache.beehive.netui.pageflow.internal.ResponseOutputException;
import org.apache.beehive.netui.pageflow.internal.ServerAdapterManager;
import org.apache.beehive.netui.pageflow.internal.XmlBeanActionForm;
import org.apache.beehive.netui.pageflow.scoping.ScopedServletUtils;
import org.apache.beehive.netui.util.Bundle;
import org.apache.beehive.netui.util.ServletUtils;
import org.apache.beehive.netui.util.config.ConfigUtil;
import org.apache.beehive.netui.util.config.bean.PageflowConfig;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.action.DynaActionFormClass;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ModuleConfig;

public class InternalUtils
implements PageFlowConstants {
    private static final Logger _log = Logger.getInstance(InternalUtils.class);
    private static final String BEA_XMLOBJECT_CLASSNAME = "com.bea.xml.XmlObject";
    private static final String APACHE_XMLOBJECT_CLASSNAME = "org.apache.xmlbeans.XmlObject";
    private static final Class BEA_XMLOBJECT_CLASS = InternalUtils.loadClassNonFatal("com.bea.xml.XmlObject");
    private static final Class APACHE_XMLOBJECT_CLASS = InternalUtils.loadClassNonFatal("org.apache.xmlbeans.XmlObject");
    private static final String LONGLIVED_PAGEFLOWS_ATTR_PREFIX = "_netui:longLivedPageFlow:";
    private static final String ACTIONOUTPUT_MAP_ATTR = "_netui:actionOutputs";
    private static final String BINDING_UPDATE_ERRORS_ATTR = "_netui:bindingUpdateErrors";
    private static final String SHARED_FLOW_CLASSNAME_ATTR = "_netui:sharedFlowClass";
    private static final String SERVLET_CONTEXT_ATTR = "_netui:servletContext";

    public static void sendDevTimeError(String messageKey, Throwable cause, int productionTimeErrorCode, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Object ... messageArgs) throws IOException {
        InternalUtils.sendDevTimeError(messageKey, messageArgs, cause, productionTimeErrorCode, request, response, servletContext);
    }

    public static void sendDevTimeError(String messageKey, Object[] messageArgs, Throwable cause, int productionTimeErrorCode, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException {
        boolean prodMode = ServerAdapterManager.getServerAdapter(servletContext).isInProductionMode();
        if (prodMode && !RequestValues.avoidDirectResponseOutput((ServletRequest)request)) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)("Error (message key " + messageKey + ") occurred.  Response error was set to " + productionTimeErrorCode), cause);
            }
            response.sendError(productionTimeErrorCode);
        } else {
            InternalUtils.sendError(messageKey, messageArgs, request, response, cause);
        }
    }

    public static void sendError(String messageKey, Throwable cause, HttpServletRequest request, HttpServletResponse response, Object ... messageArgs) throws IOException {
        InternalUtils.sendError(messageKey, messageArgs, request, response, cause);
    }

    public static void sendError(String messageKey, Object[] messageArgs, HttpServletRequest request, HttpServletResponse response, Throwable cause) throws IOException {
        assert (messageArgs.length == 0 || !(messageArgs[0] instanceof Object[])) : "Object[] passed to sendError; this is probably a mistaken use of varargs";
        if (request != null && RequestValues.avoidDirectResponseOutput((ServletRequest)request)) {
            String baseMessage = Bundle.getString((String)(messageKey + "_Message"), (Object[])messageArgs);
            throw new ResponseOutputException(baseMessage, cause);
        }
        String html = Bundle.getString((String)(messageKey + "_Page"), (Object[])messageArgs);
        response.setContentType("text/html;charset=UTF-8");
        response.getWriter().println(html);
        ServletUtils.preventCache((HttpServletResponse)response);
    }

    public static Object unwrapFormBean(ActionForm form) {
        if (form == null) {
            return null;
        }
        if (form instanceof AnyBeanActionForm) {
            return ((AnyBeanActionForm)form).getBean();
        }
        return form;
    }

    public static ActionForm wrapFormBean(Object formBean) {
        if (formBean == null) {
            return null;
        }
        if (formBean instanceof ActionForm) {
            return (ActionForm)formBean;
        }
        Class<?> formClass = formBean.getClass();
        if (BEA_XMLOBJECT_CLASS != null && BEA_XMLOBJECT_CLASS.isAssignableFrom(formClass)) {
            return new XmlBeanActionForm(formBean);
        }
        if (APACHE_XMLOBJECT_CLASS != null && APACHE_XMLOBJECT_CLASS.isAssignableFrom(formClass)) {
            return new XmlBeanActionForm(formBean);
        }
        return new AnyBeanActionForm(formBean);
    }

    private static Class loadClassNonFatal(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Could not load class " + className));
            }
            return null;
        }
    }

    public static Method lookupMethod(Class parentClass, String methodName, Class[] signature) {
        try {
            return parentClass.getDeclaredMethod(methodName, signature);
        }
        catch (NoSuchMethodException e) {
            Class superClass = parentClass.getSuperclass();
            return superClass != null ? InternalUtils.lookupMethod(superClass, methodName, signature) : null;
        }
    }

    public static String getFlowControllerClassName(String modulePath, ServletRequest request, ServletContext context) {
        ModuleConfig mc = InternalUtils.ensureModuleConfig(modulePath, request, context);
        return mc != null ? InternalUtils.getFlowControllerClassName(mc) : null;
    }

    public static String getFlowControllerClassName(ModuleConfig mc) {
        ControllerConfig cc = mc.getControllerConfig();
        return cc instanceof PageFlowControllerConfig ? ((PageFlowControllerConfig)cc).getControllerClass() : null;
    }

    public static boolean isLongLived(ModuleConfig moduleConfig) {
        ControllerConfig cc = moduleConfig.getControllerConfig();
        if (cc instanceof PageFlowControllerConfig) {
            return ((PageFlowControllerConfig)cc).isLongLivedPageFlow();
        }
        return false;
    }

    public static boolean isNestable(ModuleConfig moduleConfig) {
        ControllerConfig cc = moduleConfig.getControllerConfig();
        return cc instanceof PageFlowControllerConfig && ((PageFlowControllerConfig)cc).isNestedPageFlow();
    }

    public static String getLongLivedFlowAttr(String modulePath) {
        return LONGLIVED_PAGEFLOWS_ATTR_PREFIX + modulePath;
    }

    public static void setCurrentPageFlow(PageFlowController jpf, HttpServletRequest request) {
        InternalUtils.setCurrentActionResolver(jpf, request);
    }

    public static void deleteCurrentPageFlow(HttpServletRequest request) {
        HttpServletRequest unwrappedRequest = PageFlowUtils.unwrapMultipart(request);
        ScopedServletUtils.removeScopedSessionAttr((String)"_netui:curPageFlow", (HttpServletRequest)unwrappedRequest);
        ScopedServletUtils.removeScopedSessionAttr((String)"_netui:curLongLivedModule", (HttpServletRequest)unwrappedRequest);
    }

    public static String getDecodedURI(HttpServletRequest request) {
        return request.getContextPath() + request.getServletPath();
    }

    public static String getDecodedServletPath(HttpServletRequest request) {
        return request.getServletPath();
    }

    public static void addActionOutputs(Map toAdd, ServletRequest request, boolean overwrite) {
        if (toAdd != null) {
            Map map = InternalUtils.getActionOutputMap(request, true);
            for (Map.Entry entry : toAdd.entrySet()) {
                String name = (String)entry.getKey();
                boolean alreadyExists = map.containsKey(name);
                if (!overwrite && alreadyExists) continue;
                if (alreadyExists && _log.isWarnEnabled()) {
                    _log.warn((Object)("Overwriting action output \"" + name + "\"."));
                }
                map.put(name, entry.getValue());
            }
        }
    }

    public static void addValidationError(String propertyName, ActionError error, ServletRequest request) {
        ActionErrors errors = (ActionErrors)request.getAttribute("org.apache.struts.action.ERROR");
        if (errors == null) {
            errors = new ActionErrors();
            request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        }
        errors.add(propertyName, error);
    }

    public static Object newReloadableInstance(String className, HttpServletRequest request, ServletContext servletContext) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return InternalUtils.getReloadableClass(className, request, servletContext).newInstance();
    }

    public static Class getReloadableClass(String className, HttpServletRequest request, ServletContext servletContext) throws ClassNotFoundException {
        ReloadableClassHandler handler = ContextCache.get(servletContext).getReloadableClassHandler();
        return handler.loadClass(className);
    }

    public static Map getActionOutputMap(ServletRequest request, boolean createIfNotExist) {
        HashMap map = (HashMap)request.getAttribute(ACTIONOUTPUT_MAP_ATTR);
        if (map == null && createIfNotExist) {
            map = new HashMap();
            request.setAttribute(ACTIONOUTPUT_MAP_ATTR, map);
        }
        return map;
    }

    public static Map getPageInputMap(ServletRequest request) {
        Map actionOutputsFromPageFlow = InternalUtils.getActionOutputMap(request, false);
        if (actionOutputsFromPageFlow != null) {
            return actionOutputsFromPageFlow;
        }
        FacesBackingBean fbb = InternalUtils.getFacesBackingBean(request);
        return fbb != null ? fbb.getPageInputMap() : null;
    }

    public static ModuleConfig getModuleConfig(String modulePath, ServletContext context) {
        return (ModuleConfig)context.getAttribute("org.apache.struts.action.MODULE" + modulePath);
    }

    public static ModuleConfig ensureModuleConfig(String modulePath, ServletRequest request, ServletContext context) {
        try {
            ModuleConfig ret = InternalUtils.getModuleConfig(modulePath, context);
            if (ret != null) {
                return ret;
            }
            ActionServlet as = InternalUtils.getActionServlet(context);
            if (as instanceof AutoRegisterActionServlet) {
                return ((AutoRegisterActionServlet)as).ensureModuleRegistered(modulePath, request);
            }
        }
        catch (IOException e) {
            _log.error((Object)("Error while registering Struts module " + modulePath), (Throwable)e);
        }
        catch (ServletException e) {
            _log.error((Object)("Error while registering Struts module " + modulePath), (Throwable)e);
        }
        return null;
    }

    public static ActionServlet getActionServlet(ServletContext context) {
        if (context == null) {
            return null;
        }
        return (ActionServlet)context.getAttribute("org.apache.struts.action.ACTION_SERVLET");
    }

    public static void addBindingUpdateError(ServletRequest request, String expression, String message, Throwable cause) {
        LinkedHashMap<String, BindingUpdateError> errors = (LinkedHashMap<String, BindingUpdateError>)request.getAttribute(BINDING_UPDATE_ERRORS_ATTR);
        if (errors == null) {
            errors = new LinkedHashMap<String, BindingUpdateError>();
            request.setAttribute(BINDING_UPDATE_ERRORS_ATTR, errors);
        }
        errors.put(expression, new BindingUpdateError(expression, message, cause));
    }

    public static Map getBindingUpdateErrors(ServletRequest request) {
        return (Map)request.getAttribute(BINDING_UPDATE_ERRORS_ATTR);
    }

    public static void dumpRequest(HttpServletRequest request, PrintStream output) {
        String name;
        if (output == null) {
            output = System.err;
        }
        output.println("*** HttpServletRequest " + request);
        output.println("        uri = " + request.getRequestURI());
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            output.println("            parameter " + name + " = " + request.getParameter(name));
        }
        e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            output.println("            attribute " + name + " = " + request.getAttribute(name));
        }
        e = request.getSession().getAttributeNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            output.println("            session attribute " + name + " = " + request.getSession().getAttribute(name));
        }
    }

    public static void dumpServletContext(ServletContext context, PrintStream output) {
        if (output == null) {
            output = System.err;
        }
        output.println("*** ServletContext " + context);
        Enumeration e = context.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            output.println("            attribute " + name + " = " + context.getAttribute(name));
        }
    }

    public static void setCurrentModule(ModuleConfig mc, ServletRequest request) {
        request.setAttribute("org.apache.struts.action.MODULE", (Object)mc);
    }

    public static ActionForm createActionForm(HttpServletRequest request, ActionMapping mapping, ModuleConfig moduleConfig, ActionServlet actionServlet, ServletContext servletContext) {
        String formName = mapping.getName();
        if (formName == null) {
            return null;
        }
        FormBeanConfig config = moduleConfig.findFormBeanConfig(formName);
        if (config == null) {
            return null;
        }
        try {
            ActionForm bean;
            if (config.getDynamic()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Creating new DynaActionForm instance of type " + config.getType()));
                }
                DynaActionFormClass dynaClass = DynaActionFormClass.createDynaActionFormClass((FormBeanConfig)config);
                bean = (ActionForm)dynaClass.newInstance();
                ((DynaActionForm)bean).initialize(mapping);
            } else {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Creating new ActionForm instance of type " + config.getType()));
                }
                bean = (ActionForm)InternalUtils.newReloadableInstance(config.getType(), request, servletContext);
            }
            bean.setServlet(actionServlet);
            return bean;
        }
        catch (Exception e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)("Error creating action form of type " + config.getType()), (Throwable)e);
            }
            return null;
        }
    }

    public static void setFormInScope(String formName, ActionForm form, ActionMapping mapping, HttpServletRequest request, boolean overwrite) {
        if (formName != null && form != null) {
            if (InternalUtils.isSessionScope(mapping)) {
                HttpSession session = request.getSession();
                if (overwrite || session.getAttribute(formName) == null) {
                    session.setAttribute(formName, (Object)form);
                }
            } else if (overwrite || request.getAttribute(formName) == null) {
                request.setAttribute(formName, (Object)form);
            }
        }
    }

    public static boolean isSessionScope(ActionMapping mapping) {
        return mapping.getScope() == null || mapping.getScope().equals("session");
    }

    public static ActionForm getFormBean(ActionMapping mapping, HttpServletRequest request) {
        String formBeanName = mapping.getName();
        if (formBeanName != null) {
            if (InternalUtils.isSessionScope(mapping)) {
                return (ActionForm)request.getSession().getAttribute(formBeanName);
            }
            return (ActionForm)request.getAttribute(formBeanName);
        }
        return null;
    }

    public static void setCurrentActionResolver(ActionResolver resolver, HttpServletRequest request) {
        HttpServletRequest unwrappedRequest = PageFlowUtils.unwrapMultipart(request);
        if (resolver == null) {
            ScopedServletUtils.removeScopedSessionAttr((String)"_netui:curPageFlow", (HttpServletRequest)unwrappedRequest);
            ScopedServletUtils.removeScopedSessionAttr((String)"_netui:curLongLivedModule", (HttpServletRequest)unwrappedRequest);
            return;
        }
        if (resolver.isPageFlow() && InternalUtils.isLongLived(((PageFlowController)resolver).getModuleConfig())) {
            String longLivedAttrName = InternalUtils.getLongLivedFlowAttr(resolver.getModulePath());
            ScopedServletUtils.setScopedSessionAttr((String)longLivedAttrName, (Object)resolver, (HttpServletRequest)unwrappedRequest);
            ScopedServletUtils.setScopedSessionAttr((String)"_netui:curLongLivedModule", (Object)resolver.getModulePath(), (HttpServletRequest)unwrappedRequest);
            ScopedServletUtils.removeScopedSessionAttr((String)"_netui:curPageFlow", (HttpServletRequest)unwrappedRequest);
        } else {
            ScopedServletUtils.setScopedSessionAttr((String)"_netui:curPageFlow", (Object)resolver, (HttpServletRequest)unwrappedRequest);
            ScopedServletUtils.removeScopedSessionAttr((String)"_netui:curLongLivedModule", (HttpServletRequest)unwrappedRequest);
        }
    }

    public static String getSharedFlowClassName(HttpServletRequest request, ServletContext servletContext) {
        return InternalUtils.getSharedFlowClassNameForRelativeURI(InternalUtils.getDecodedServletPath(request), request, servletContext);
    }

    public static String getSharedFlowClassNameForRelativeURI(String relativeURI, HttpServletRequest request, ServletContext servletContext) {
        String cachedInRequest = (String)request.getAttribute(SHARED_FLOW_CLASSNAME_ATTR);
        if (cachedInRequest != null) {
            return cachedInRequest.length() > 0 ? cachedInRequest : null;
        }
        String parentDir = PageFlowUtils.getModulePathForRelativeURI(relativeURI);
        String className = null;
        if (parentDir.length() > 0) {
            int lastSlash;
            assert (parentDir.charAt(0) == '/') : parentDir;
            parentDir = "/-" + parentDir.substring(1);
            while ((className = InternalUtils.getFlowControllerClassName(parentDir, (ServletRequest)request, servletContext)) == null && (parentDir = parentDir.substring(0, lastSlash = parentDir.lastIndexOf(47))).length() > 0) {
            }
        }
        if (className == null) {
            className = InternalUtils.getFlowControllerClassName("/-webappRoot", (ServletRequest)request, servletContext);
        }
        if (className == null) {
            className = InternalUtils.getFlowControllerClassName("/-global", (ServletRequest)request, servletContext);
        }
        request.setAttribute(SHARED_FLOW_CLASSNAME_ATTR, (Object)(className != null ? className : ""));
        return className;
    }

    public static FlowController getFlowController(String fcClassName, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ClassNotFoundException {
        Class fcClass = InternalUtils.getReloadableClass(fcClassName, request, servletContext);
        return InternalUtils.getFlowController(fcClass, request, response, servletContext);
    }

    public static FlowController getFlowController(Class fcClass, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        if (PageFlowController.class.isAssignableFrom(fcClass)) {
            PageFlowController current = PageFlowUtils.getCurrentPageFlow(request);
            if (current != null && current.getClass().equals(fcClass)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Using current page flow: " + current));
                }
                current.reinitialize(request, response, servletContext);
                return current;
            }
            return FlowControllerFactory.getPageFlow(fcClass, request, response, servletContext);
        }
        assert (SharedFlowController.class.isAssignableFrom(fcClass)) : fcClass.getName();
        SharedFlowController current = PageFlowUtils.getSharedFlow(fcClass.getName(), request);
        if (current != null) {
            return current;
        }
        return FlowControllerFactory.getSharedFlow(fcClass, request, response, servletContext);
    }

    public static boolean isSharedFlowModule(ModuleConfig mc) {
        ControllerConfig cc = mc.getControllerConfig();
        return cc instanceof PageFlowControllerConfig && ((PageFlowControllerConfig)cc).isSharedFlow();
    }

    public static FacesBackingBean getFacesBackingBean(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpSession session = ((HttpServletRequest)request).getSession(false);
            return session != null ? (FacesBackingBean)session.getAttribute("_netui:facesBacking") : null;
        }
        return null;
    }

    public static String inferModulePathFromClassName(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(0, lastDot);
            return '/' + className.replace('.', '/');
        }
        return "";
    }

    public static boolean isMultipartHandlingEnabled(HttpServletRequest request) {
        ModuleConfig moduleConfig = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
        return moduleConfig.getControllerConfig().getMultipartClass() != null;
    }

    public static PageflowConfig.MultipartHandler.Enum getMultipartHandlerType() {
        PageflowConfig pfConfig = ConfigUtil.getConfig().getPageflowConfig();
        return pfConfig != null ? pfConfig.getMultipartHandler() : null;
    }

    public static void setServletContext(HttpServletRequest request, ServletContext servletContext) {
        ScopedServletUtils.getOuterRequest((HttpServletRequest)request).setAttribute(SERVLET_CONTEXT_ATTR, (Object)servletContext);
    }

    public static ServletContext getServletContext(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session != null ? session.getServletContext() : (ServletContext)ScopedServletUtils.getOuterRequest((HttpServletRequest)request).getAttribute(SERVLET_CONTEXT_ATTR);
    }

    public static String createActionURL(HttpServletRequest servletRequest, String qualifiedAction) {
        String pageURI = InternalUtils.getDecodedURI(servletRequest);
        int lastSlash = pageURI.lastIndexOf(47);
        if (lastSlash != -1) {
            StringBuilder value = new StringBuilder(qualifiedAction.length() + 16);
            value.append(pageURI.substring(0, lastSlash));
            value.append(qualifiedAction);
            return value.toString();
        }
        return qualifiedAction;
    }

    public static String createActionPath(HttpServletRequest request, String qualifiedAction) {
        ModuleConfig appConfig = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
        if (appConfig != null) {
            StringBuilder value = new StringBuilder(qualifiedAction.length() + 16);
            value.append(appConfig.getPrefix());
            value.append(qualifiedAction);
            return value.toString();
        }
        return qualifiedAction;
    }

    public static String qualifyAction(ServletContext servletContext, String action) {
        assert (action != null);
        StringBuilder sb = new StringBuilder(32);
        String servletMapping = (String)servletContext.getAttribute("org.apache.struts.action.SERVLET_MAPPING");
        if (servletMapping != null) {
            String queryString = null;
            int question = action.indexOf(63);
            if (question >= 0) {
                queryString = action.substring(question);
            }
            String actionMapping = InternalUtils.getActionMappingName(action);
            if (servletMapping.startsWith("*.")) {
                sb.append(actionMapping);
                sb.append(servletMapping.substring(1));
            } else if (servletMapping.endsWith("/*")) {
                sb.append(servletMapping.substring(0, servletMapping.length() - 2));
                sb.append(actionMapping);
            } else if (servletMapping.equals("/")) {
                sb.append(actionMapping);
            }
            if (queryString != null) {
                sb.append(queryString);
            }
        } else {
            if (!action.startsWith("/")) {
                sb.append('/');
            }
            sb.append(action);
        }
        return sb.toString();
    }

    public static String getActionMappingName(String action) {
        return InternalUtils.getCleanActionName(action, true);
    }

    public static String getCleanActionName(String action, boolean prependSlash) {
        int question = action.indexOf(63);
        if (question >= 0) {
            action = action.substring(0, question);
        }
        if (action.endsWith(".do")) {
            action = action.substring(0, action.length() - InternalConstants.ACTION_EXTENSION_LEN);
        }
        if (action.charAt(0) == '/') {
            if (!prependSlash) {
                action = action.substring(1);
            }
        } else if (prependSlash) {
            action = '/' + action;
        }
        return action;
    }

    public static String addParam(String url, String paramName, String paramVal) {
        return url + (url.indexOf(63) != -1 ? (char)'&' : '?') + paramName + '=' + paramVal;
    }

    public static String getActionName(ActionMapping mapping) {
        String unqualifiedAction;
        if (mapping == null) {
            return null;
        }
        String actionName = mapping.getPath();
        if (actionName.charAt(0) == '/') {
            actionName = actionName.substring(1);
        }
        if (mapping instanceof PageFlowActionMapping && (unqualifiedAction = ((PageFlowActionMapping)mapping).getUnqualifiedActionName()) != null) {
            actionName = unqualifiedAction;
        }
        return actionName;
    }

    public static ActionMapping getCurrentActionMapping(HttpServletRequest request) {
        return (ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance");
    }

    public static ActionForm getCurrentActionForm(HttpServletRequest request) {
        String attribute;
        ActionMapping mapping = InternalUtils.getCurrentActionMapping(request);
        String string = attribute = mapping != null ? mapping.getAttribute() : null;
        if (attribute == null) {
            return null;
        }
        if ("request".equals(mapping.getScope())) {
            return (ActionForm)request.getAttribute(attribute);
        }
        HttpSession session = request.getSession(false);
        return session != null ? (ActionForm)session.getAttribute(attribute) : null;
    }

    public static boolean sessionExpired(HttpServletRequest request) {
        String requestedSessionID = request.getRequestedSessionId();
        if (requestedSessionID != null) {
            HttpSession session = request.getSession(false);
            return session == null || !requestedSessionID.equals(session.getId());
        }
        return false;
    }

    public static void throwPageFlowException(PageFlowException ex) {
        InternalUtils.throwPageFlowException(ex, null);
    }

    public static void throwPageFlowException(PageFlowException effect, HttpServletRequest request) throws PageFlowException {
        PageflowConfig pfc;
        if (request != null && effect.causeMayBeSessionExpiration() && InternalUtils.sessionExpired(request) && (pfc = ConfigUtil.getConfig().getPageflowConfig()) != null && pfc.getThrowSessionExpiredException()) {
            throw new SessionExpiredException(effect);
        }
        throw effect;
    }

    public static ActionConfig findActionConfig(String actionConfigPath, String modulePath, ServletContext context) {
        ModuleConfig moduleConfig = InternalUtils.getModuleConfig(modulePath, context);
        assert (moduleConfig != null);
        return moduleConfig.findActionConfig(actionConfigPath);
    }

    public static String getActionMappingPath(ServletRequest request) {
        ActionMapping actionMapping = (ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance");
        return actionMapping != null ? actionMapping.getPath() : null;
    }

    public static String getModulePathFromReqAttr(HttpServletRequest request) {
        ModuleConfig config = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
        return config != null ? config.getPrefix() : PageFlowUtils.getModulePath(request);
    }
}

