/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.internal;

import java.beans.beancontext.BeanContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.beehive.controls.api.bean.Control;
import org.apache.beehive.controls.api.bean.ControlBean;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.api.properties.AnnotatedElementMap;
import org.apache.beehive.controls.api.properties.PropertyMap;
import org.apache.beehive.controls.runtime.servlet.ServletBeanContext;
import org.apache.beehive.netui.pageflow.internal.ServerAdapterManager;
import org.apache.beehive.netui.util.logging.Logger;

public class JavaControlUtils {
    private static final Logger _log = Logger.getInstance(JavaControlUtils.class);
    private static final String CONTROL_CONTEXT_CLASSNAME = ServletBeanContext.class.getName();
    private static final Class[] CONTROL_BEAN_CONSTRUCTOR_SIGNATURE = new Class[]{ControlBeanContext.class, String.class, PropertyMap.class};
    private static ConcurrentHashMap<String, Map<Field, PropertyMap>> _controlFieldCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Constructor> _controlConstructors = new ConcurrentHashMap();

    public static void initializeControlContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        ControlBeanContext beanContext = JavaControlUtils.getControlBeanContext(request, response, servletContext, true);
        if (beanContext instanceof ServletBeanContext) {
            ((ServletBeanContext)beanContext).beginContext(servletContext, (ServletRequest)request, (ServletResponse)response);
        }
    }

    public static void uninitializeControlContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        ControlBeanContext beanContext = JavaControlUtils.getControlBeanContext(request, response, servletContext, false);
        if (beanContext instanceof ServletBeanContext) {
            ((ServletBeanContext)beanContext).endContext();
        }
    }

    public static ControlBeanContext getControlBeanContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, boolean createIfMissing) {
        ControlBeanContext beanContext = (ControlBeanContext)request.getAttribute(CONTROL_CONTEXT_CLASSNAME);
        if (beanContext != null) {
            return beanContext;
        }
        HttpSession session = request.getSession(false);
        if (session != null && (beanContext = (ControlBeanContext)session.getAttribute(CONTROL_CONTEXT_CLASSNAME)) != null) {
            request.setAttribute(CONTROL_CONTEXT_CLASSNAME, (Object)beanContext);
            return beanContext;
        }
        if (createIfMissing) {
            beanContext = ServerAdapterManager.getServerAdapter(servletContext).createControlBeanContext(request, response);
            request.getSession().setAttribute(CONTROL_CONTEXT_CLASSNAME, (Object)beanContext);
            request.setAttribute(CONTROL_CONTEXT_CLASSNAME, (Object)beanContext);
        }
        return beanContext;
    }

    public static ControlBean createControl(String controlClassName, boolean isBeanClass, String controlID, PropertyMap properties, ControlBeanContext beanContext) throws ControlInstantiationException {
        if (!isBeanClass) {
            controlClassName = controlClassName + "Bean";
        }
        try {
            Constructor<?> constructor = _controlConstructors.get(controlClassName);
            if (constructor == null) {
                Class<?> beanClass = Class.forName(controlClassName);
                constructor = beanClass.getConstructor(CONTROL_BEAN_CONSTRUCTOR_SIGNATURE);
                _controlConstructors.put(controlClassName, constructor);
            }
            Object instance = constructor.newInstance(beanContext, controlID, properties);
            assert (instance instanceof ControlBean) : instance.getClass().getName();
            return (ControlBean)instance;
        }
        catch (ClassNotFoundException e) {
            _log.error((Object)("Could not find control bean class " + controlClassName));
            throw new ControlInstantiationException(controlClassName, e);
        }
        catch (NoSuchMethodException e) {
            _log.error((Object)"Missing constructor (ControlBeanContext, String controlID) on control bean class.", (Throwable)e);
            throw new ControlInstantiationException(controlClassName, e);
        }
        catch (Exception e) {
            assert (e instanceof InstantiationException || e instanceof IllegalAccessException || e instanceof InvocationTargetException) : e.getClass().getName();
            _log.error((Object)("Error while constructing control bean of type " + controlClassName), (Throwable)e);
            throw new ControlInstantiationException(controlClassName, e);
        }
    }

    public static void destroyControl(Object controlInstance) {
        assert (controlInstance instanceof ControlBean) : controlInstance.getClass().getName();
        BeanContext beanContext = ((ControlBean)controlInstance).getBeanContext();
        if (beanContext != null) {
            beanContext.remove(controlInstance);
        }
    }

    public static Map getAccessibleControlFieldAnnotations(Class controlContainerClass) {
        String className = controlContainerClass.getName();
        Map<Field, PropertyMap> cached = _controlFieldCache.get(className);
        if (cached != null) {
            return cached;
        }
        HashMap<Field, AnnotatedElementMap> ret = new HashMap<Field, AnnotatedElementMap>();
        boolean accessPrivateFields = true;
        do {
            Field[] fields = controlContainerClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || field.getAnnotation(Control.class) == null || !accessPrivateFields && Modifier.isPrivate(modifiers)) continue;
                field.setAccessible(true);
                ret.put(field, new AnnotatedElementMap((AnnotatedElement)field));
            }
            _controlFieldCache.put(className, ret);
            accessPrivateFields = false;
        } while ((controlContainerClass = controlContainerClass.getSuperclass()) != null);
        return ret;
    }

    public static class ControlInstantiationException
    extends Exception {
        private String _controlBeanClassName;

        public ControlInstantiationException(String controlBeanClassName, Throwable cause) {
            super(cause);
            this._controlBeanClassName = controlBeanClassName;
        }

        public String getControlBeanClassName() {
            return this._controlBeanClassName;
        }
    }
}

