/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.internal;

import javax.servlet.ServletRequest;
import org.apache.beehive.netui.pageflow.FlowController;
import org.apache.beehive.netui.pageflow.internal.ViewRenderer;
import org.apache.struts.action.ActionForm;

public class RequestValues {
    private static final String FORWARDED_REQUEST_COUNT_ATTR = "_netui:forwardedRequestCount";
    private static final String AVOID_DIRECT_RESPONSE_OUTPUT_ATTR = "_netui:_avoidDirectResponseOutput";
    private static final String ORIGINAL_SERVLET_PATH_ATTR = "_netui:origServletPath";
    private static final String FORWARDED_FORMBEAN_ATTR = "_netui:forwardedForm";
    private static final String CURRENT_FLOWCONTROLLER_ATTR = "_netui:flowController";
    private static final String VIEW_RENDERER_ATTR = "_netui:viewRenderer";

    public static boolean isForwardedRequest(ServletRequest request) {
        return request.getAttribute(FORWARDED_REQUEST_COUNT_ATTR) != null;
    }

    public static int getForwardedRequestCount(ServletRequest request) {
        Integer count = (Integer)request.getAttribute(FORWARDED_REQUEST_COUNT_ATTR);
        return count != null ? count : 0;
    }

    public static void setForwardedRequestCount(ServletRequest request, int count) {
        request.setAttribute(FORWARDED_REQUEST_COUNT_ATTR, (Object)count);
    }

    public static boolean avoidDirectResponseOutput(ServletRequest request) {
        Boolean avoid = (Boolean)request.getAttribute(AVOID_DIRECT_RESPONSE_OUTPUT_ATTR);
        return avoid != null && avoid != false;
    }

    public static void setAvoidDirectResponseOutput(ServletRequest request) {
        request.setAttribute(AVOID_DIRECT_RESPONSE_OUTPUT_ATTR, (Object)Boolean.TRUE);
    }

    public static void setOriginalServletPath(ServletRequest request, String servletPath) {
        request.setAttribute(ORIGINAL_SERVLET_PATH_ATTR, (Object)servletPath);
    }

    public static String getOriginalServletPath(ServletRequest request) {
        return (String)request.getAttribute(ORIGINAL_SERVLET_PATH_ATTR);
    }

    public static void setForwardedFormBean(ServletRequest request, ActionForm form) {
        if (form == null) {
            request.removeAttribute(FORWARDED_FORMBEAN_ATTR);
        } else {
            request.setAttribute(FORWARDED_FORMBEAN_ATTR, (Object)form);
        }
    }

    public static ActionForm getForwardedForm(ServletRequest request, boolean removeFromRequest) {
        ActionForm form = (ActionForm)request.getAttribute(FORWARDED_FORMBEAN_ATTR);
        if (removeFromRequest) {
            request.removeAttribute(FORWARDED_FORMBEAN_ATTR);
        }
        return form;
    }

    public static void setCurrentFlowController(ServletRequest request, FlowController fc) {
        request.setAttribute(CURRENT_FLOWCONTROLLER_ATTR, (Object)fc);
    }

    public static FlowController getCurrentFlowController(ServletRequest request) {
        return (FlowController)request.getAttribute(CURRENT_FLOWCONTROLLER_ATTR);
    }

    public static void removeCurrentFlowController(ServletRequest request) {
        request.removeAttribute(CURRENT_FLOWCONTROLLER_ATTR);
    }

    public static ViewRenderer getViewRenderer(ServletRequest request) {
        return (ViewRenderer)request.getAttribute(VIEW_RENDERER_ATTR);
    }

    public static void setViewRenderer(ServletRequest request, ViewRenderer viewRenderer) {
        request.setAttribute(VIEW_RENDERER_ATTR, (Object)viewRenderer);
    }
}

