/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.internal;

import javax.servlet.ServletContext;
import org.apache.beehive.netui.pageflow.DefaultServerAdapter;
import org.apache.beehive.netui.pageflow.ServerAdapter;
import org.apache.beehive.netui.util.DiscoveryUtils;
import org.apache.beehive.netui.util.logging.Logger;

public class ServerAdapterManager {
    private static final Logger _log = Logger.getInstance(ServerAdapterManager.class);
    private static final String SERVER_ADAPTER_ATTR = "_netui:_serverAdapter";
    private static final String SERVER_ADAPTER_PROP = "pageflow.serveradapter";

    public static ServerAdapter getServerAdapter(ServletContext servletContext) {
        ServerAdapter adapter = (ServerAdapter)servletContext.getAttribute(SERVER_ADAPTER_ATTR);
        if (adapter == null) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)"ServletAdapter manager not initialized correctly.");
            }
            return ServerAdapterManager.init(servletContext);
        }
        return adapter;
    }

    public static ServerAdapter init(ServletContext servletContext) {
        ServerAdapter serverAdapter = ServerAdapterManager.createServerAdapter(servletContext);
        servletContext.setAttribute(SERVER_ADAPTER_ATTR, (Object)serverAdapter);
        return serverAdapter;
    }

    private static ServerAdapter tryServerAdapter(Class serverAdapterClass, ServletContext servletContext) {
        try {
            ServerAdapter sa = (ServerAdapter)serverAdapterClass.newInstance();
            try {
                if (sa.accept(servletContext)) {
                    _log.info((Object)("ServerAdapter " + serverAdapterClass.getName() + " accepted."));
                    sa.setServletContext(servletContext);
                    return sa;
                }
                _log.info((Object)("ServerAdapter " + serverAdapterClass.getName() + " is present but did not accept."));
            }
            catch (Exception e) {
                _log.error((Object)(serverAdapterClass.getName() + ".accept() threw an exception."), (Throwable)e);
            }
            catch (LinkageError e) {
                _log.error((Object)(serverAdapterClass.getName() + ".accept() caused a linkage error and may be out of date."), (Throwable)e);
            }
        }
        catch (InstantiationException e) {
            _log.error((Object)("Could not create instance of ServerAdapter class " + serverAdapterClass.getName()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            _log.error((Object)("Could not create instance of ServerAdapter class " + serverAdapterClass.getName()), (Throwable)e);
        }
        catch (Exception e) {
            _log.error((Object)("Error creating instance of ServerAdapter class " + serverAdapterClass.getName()), (Throwable)e);
        }
        return null;
    }

    private static ServerAdapter createServerAdapter(ServletContext servletContext) {
        ServerAdapter sa;
        Class serverAdapterClass;
        String serverAdapterClassName = System.getProperty(SERVER_ADAPTER_PROP);
        if (serverAdapterClassName != null && (serverAdapterClass = DiscoveryUtils.loadImplementorClass((String)serverAdapterClassName, ServerAdapter.class)) != null && (sa = ServerAdapterManager.tryServerAdapter(serverAdapterClass, servletContext)) != null) {
            return sa;
        }
        Class[] classes = DiscoveryUtils.getImplementorClasses(ServerAdapter.class);
        for (int i = 0; i < classes.length; ++i) {
            ServerAdapter sa2 = ServerAdapterManager.tryServerAdapter(classes[i], servletContext);
            if (sa2 == null) continue;
            return sa2;
        }
        _log.info((Object)("No ServerAdapter specified or discovered; using " + DefaultServerAdapter.class));
        DefaultServerAdapter sa2 = new DefaultServerAdapter(){

            public boolean accept(ServletContext servletContext) {
                return true;
            }
        };
        sa2.setServletContext(servletContext);
        return sa2;
    }
}

