/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.beehive.netui.pageflow.config.PageFlowActionMapping;
import org.apache.beehive.netui.pageflow.internal.AnyBeanActionForm;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.action.ActionMapping;

public class XmlBeanActionForm
extends AnyBeanActionForm {
    private static final Logger _log = Logger.getInstance(XmlBeanActionForm.class);
    private String _formClassName;

    public XmlBeanActionForm() {
    }

    public XmlBeanActionForm(Object xml) {
        this.setBean(xml);
    }

    public String getXmlString() {
        Object xmlBean = this.getBean();
        if (xmlBean == null) {
            return null;
        }
        try {
            return (String)xmlBean.getClass().getMethod("xmlText", new Class[0]).invoke(xmlBean, new Object[0]);
        }
        catch (InvocationTargetException e) {
            _log.error((Object)"Error while getting XML String", e.getCause());
        }
        catch (Exception e) {
            assert (e instanceof NoSuchMethodException || e instanceof IllegalAccessException) : e.getClass().getName();
            _log.error((Object)"Error while getting XML String", (Throwable)e);
        }
        return null;
    }

    public void setXmlString(String xml) {
        assert (this._formClassName != null);
        this.setBean(this.invokeFactoryMethod("parse", new Class[]{String.class}, new Object[]{xml}));
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        if (this._formClassName == null) {
            assert (mapping instanceof PageFlowActionMapping) : mapping.getClass().getName();
            this._formClassName = ((PageFlowActionMapping)mapping).getFormClass();
            assert (this._formClassName != null);
        }
        if (this.getBean() == null) {
            this.setBean(this.invokeFactoryMethod("newInstance", new Class[0], new Object[0]));
        }
    }

    private Object invokeFactoryMethod(String methodName, Class[] argTypes, Object[] args) {
        String factoryClassName = this._formClassName + "$Factory";
        try {
            Class<?> factoryClass = Class.forName(factoryClassName);
            Method newInstanceMethod = factoryClass.getMethod(methodName, argTypes);
            return newInstanceMethod.invoke(factoryClass, args);
        }
        catch (Exception e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)("Error while creating XML object of type " + this._formClassName), (Throwable)e);
            }
            return null;
        }
    }
}

