/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.script.common;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.beehive.netui.script.common.AbstractScriptableMap;
import org.apache.beehive.netui.script.common.BundleContext;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;

public class BundleMap
extends AbstractScriptableMap {
    private static final Logger _logger = Logger.getInstance(BundleMap.class);
    private BundleContext _bundleContext = null;
    private HttpServletRequest _request = null;
    private HttpSession _session = null;
    private ServletContext _application = null;

    public BundleMap(HttpServletRequest request, ServletContext application, BundleContext bundleContext) {
        assert (request != null);
        assert (application != null);
        this._request = request;
        this._session = request.getSession(false);
        this._application = application;
        this._bundleContext = bundleContext;
    }

    public BundleContext getBundleContext() {
        return this._bundleContext;
    }

    public Object get(Object name) {
        assert (name instanceof String);
        return this.createScriptableBundle((String)name);
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        assert (key instanceof String);
        String name = (String)key;
        if (this._bundleContext != null && this._bundleContext.containsBundle(name)) {
            return true;
        }
        if (name.equals("default")) {
            return this.getDefaultStrutsModuleBundle() != null;
        }
        if (this._application.getAttribute(name) != null) {
            return this.getNamedStrutsModuleBundle(name) != null;
        }
        return false;
    }

    public Set entrySet() {
        MessageResources resources;
        ArrayList<AbstractScriptableMap.Entry> entries = new ArrayList<AbstractScriptableMap.Entry>();
        if (this._bundleContext != null) {
            Iterator iterator = this._bundleContext.getBundleNames();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                BundleContext.BundleNode node = this._bundleContext.getBundle(name);
                entries.add(new AbstractScriptableMap.Entry(name, node));
            }
        }
        if ((resources = this.getDefaultStrutsModuleBundle()) != null) {
            entries.add(new AbstractScriptableMap.Entry("default", BundleContext.createBundleNode("default", resources, this.retrieveUserLocale())));
        }
        return new AbstractScriptableMap.EntrySet(entries.toArray(new AbstractScriptableMap.Entry[0]));
    }

    private Object createScriptableBundle(String name) {
        MessageResources resources;
        if (this._bundleContext != null && this._bundleContext.containsBundle(name)) {
            try {
                return new ScriptableBundle(name, this._bundleContext.getBundle(name));
            }
            catch (Exception e) {
                String msg = "Unable to load bundle named \"" + name + "\"; Cause: " + e.getMessage() + ".  Cause: " + e;
                if (_logger.isErrorEnabled()) {
                    _logger.error((Object)msg, (Throwable)e);
                }
                throw new RuntimeException(msg, e);
            }
        }
        if (name.equals("default")) {
            resources = this.getDefaultStrutsModuleBundle();
            if (resources != null) {
                BundleContext.BundleNode bundleNode = BundleContext.createBundleNode(name, resources, this.retrieveUserLocale());
                return new ScriptableBundle(name, bundleNode);
            }
        } else if (this._application.getAttribute(name) != null && (resources = this.getNamedStrutsModuleBundle(name)) != null) {
            BundleContext.BundleNode bundleNode = BundleContext.createBundleNode(name, resources, this.retrieveUserLocale());
            return new ScriptableBundle(name, bundleNode);
        }
        String bundleList = this.createBundleList();
        String strutsBundleList = this.createStrutsBundleList();
        String msg = "The bundle named \"" + name + "\" was not found in the list of registered bundles with names " + bundleList + " or implicit bundle names " + strutsBundleList + ".";
        if (_logger.isErrorEnabled()) {
            _logger.error((Object)msg);
        }
        throw new RuntimeException(msg);
    }

    private MessageResources getDefaultStrutsModuleBundle() {
        Object value = this._request.getAttribute("org.apache.struts.action.MESSAGE");
        if (value instanceof MessageResources) {
            return (MessageResources)value;
        }
        if (value != null && _logger.isWarnEnabled()) {
            _logger.warn((Object)("Can not resolve the default module bundle.  The object resolved from the request is of type " + (value != null ? value.getClass() : "null")));
        }
        return null;
    }

    private MessageResources getNamedStrutsModuleBundle(String name) {
        Object value = this._application.getAttribute(name);
        if (value instanceof MessageResources) {
            return (MessageResources)value;
        }
        if (value != null && _logger.isWarnEnabled()) {
            _logger.warn((Object)("Can not resolve module bundle with name \"" + name + "\".  The object resolved from ServletContext is of type " + (value != null ? value.getClass() : "null")));
        }
        return null;
    }

    private final Locale retrieveUserLocale() {
        String locale = null;
        Locale userLocale = null;
        if (locale == null) {
            locale = "org.apache.struts.action.LOCALE";
        }
        if (this._session != null) {
            userLocale = (Locale)this._session.getAttribute(locale);
        }
        if (userLocale == null) {
            userLocale = this._request.getLocale();
        }
        return userLocale;
    }

    private final String createBundleList() {
        StringBuilder nameList = new StringBuilder(32);
        nameList.append("[");
        if (this._bundleContext != null) {
            Iterator iterator = this._bundleContext.getBundleNames();
            int i = 0;
            while (iterator.hasNext()) {
                if (i > 0) {
                    nameList.append(", ");
                }
                nameList.append(iterator.next().toString());
                ++i;
            }
        }
        nameList.append("]");
        return nameList.toString();
    }

    private final String createStrutsBundleList() {
        MessageResourcesConfig[] mrs;
        StringBuilder strutsNameList = new StringBuilder(32);
        strutsNameList.append("[");
        ModuleConfig config = (ModuleConfig)this._request.getAttribute("org.apache.struts.action.MODULE");
        if (config != null && (mrs = config.findMessageResourcesConfigs()) != null) {
            for (int i = 0; i < mrs.length; ++i) {
                if (i > 0) {
                    strutsNameList.append(", ");
                }
                if (mrs[i].getKey().equals("org.apache.struts.action.MESSAGE")) {
                    strutsNameList.append("default");
                    continue;
                }
                strutsNameList.append(mrs[i].getKey() + config.getPrefix());
            }
        }
        strutsNameList.append("]");
        return strutsNameList.toString();
    }

    public class ScriptableBundle
    extends AbstractScriptableMap {
        private BundleContext.BundleNode _bundle = null;
        private String _propertiesName = null;

        ScriptableBundle(String propertiesName, BundleContext.BundleNode bundle) {
            assert (bundle != null);
            assert (propertiesName != null);
            this._bundle = bundle;
            this._propertiesName = propertiesName;
        }

        public Set entrySet() {
            ArrayList<AbstractScriptableMap.Entry> list = new ArrayList<AbstractScriptableMap.Entry>();
            Enumeration enumeration = this._bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String msg = this._bundle.getString(key);
                list.add(new AbstractScriptableMap.Entry(key, msg));
            }
            return new AbstractScriptableMap.EntrySet(list.toArray(new AbstractScriptableMap.Entry[0]));
        }

        public Object get(Object name) {
            assert (name instanceof String);
            String result = this._bundle.getString((String)name);
            if (result == null) {
                String msg = "The bundle property name \"" + name + "\" could not be found in the properties bundle \"" + this._propertiesName + "\".";
                if (_logger.isErrorEnabled()) {
                    _logger.error((Object)msg);
                }
                throw new RuntimeException(msg);
            }
            return result;
        }

        public boolean containsKey(Object key) {
            return this._bundle.getString(key.toString()) != null;
        }
    }
}

