/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.script.common;

import java.util.Stack;
import javax.servlet.jsp.JspContext;
import org.apache.beehive.netui.script.common.DataAccessProviderBean;
import org.apache.beehive.netui.script.common.IDataAccessProvider;

public class DataAccessProviderStack {
    private static final String KEY = "org.apache.beehive.netui.script.common.DataAccessProviderStack";
    private Stack _stack = new Stack();

    public static final void addDataAccessProvider(IDataAccessProvider provider, JspContext jspContext) {
        assert (jspContext != null);
        DataAccessProviderBean bean = new DataAccessProviderBean(provider);
        Object val = jspContext.getAttribute(KEY);
        DataAccessProviderStack curStack = null;
        if (val == null) {
            curStack = new DataAccessProviderStack();
            jspContext.setAttribute(KEY, (Object)curStack);
        } else {
            curStack = (DataAccessProviderStack)val;
        }
        curStack.push(bean);
        jspContext.setAttribute("container", (Object)bean);
    }

    public static final DataAccessProviderBean removeDataAccessProvider(JspContext jspContext) {
        assert (jspContext != null);
        Object val = jspContext.getAttribute(KEY);
        if (val != null) {
            DataAccessProviderStack curStack = (DataAccessProviderStack)val;
            DataAccessProviderBean lastTop = curStack.pop();
            if (!curStack.isEmpty()) {
                jspContext.setAttribute("container", (Object)curStack.peek());
            } else {
                jspContext.removeAttribute("container");
            }
            return lastTop;
        }
        return null;
    }

    public boolean isEmpty() {
        return this._stack.empty();
    }

    public DataAccessProviderBean peek() {
        return (DataAccessProviderBean)this._stack.peek();
    }

    public DataAccessProviderBean pop() {
        return (DataAccessProviderBean)this._stack.pop();
    }

    public void push(DataAccessProviderBean bean) {
        this._stack.push(bean);
    }
}

